/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LogicalExpression;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpressionUtils {
    private final Metadata metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testAnd() {
        Identifier a = TestExpressionUtils.name("a");
        Identifier b = TestExpressionUtils.name("b");
        Identifier c = TestExpressionUtils.name("c");
        Identifier d = TestExpressionUtils.name("d");
        Identifier e = TestExpressionUtils.name("e");
        Assertions.assertThat((Object)IrUtils.and((Expression[])new Expression[]{a, b, c, d, e})).isEqualTo((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)a, (Object)b, (Object)c, (Object)d, (Object)e)));
        Assertions.assertThat((Object)IrUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{a, b, a, c, d, c, e})).isEqualTo((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)a, (Object)b, (Object)c, (Object)d, (Object)e)));
    }

    private static Identifier name(String name) {
        return new Identifier(name);
    }
}

