/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public abstract class AbstractPredicatePushdownTest
extends BasePlanTest {
    private final boolean enableDynamicFiltering;

    protected AbstractPredicatePushdownTest(boolean enableDynamicFiltering) {
        super((Map<String, String>)ImmutableMap.of((Object)"enable_dynamic_filtering", (Object)Boolean.toString(enableDynamicFiltering)));
        this.enableDynamicFiltering = enableDynamicFiltering;
    }

    @Test
    public abstract void testCoercions();

    @Test
    public void testPushDownToLhsOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders)) WHERE linenumber = 2", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", this.enableDynamicFiltering, PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_NUMBER = 2", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_NUMBER", (Object)"linenumber", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))));
    }

    @Test
    public void testNonDeterministicPredicatePropagatesOnlyToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey = random(5)", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", this.enableDynamicFiltering, PlanMatchPattern.filter("LINE_ORDER_KEY = CAST(random(5) AS bigint)", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey"))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))));
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey NOT IN (SELECT orderkey FROM orders) AND orderkey = random(5)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.filter("LINE_ORDER_KEY = CAST(random(5) AS bigint)", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))));
    }

    @Test
    public void testGreaterPredicateFromFilterSidePropagatesToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey > 2))", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", this.enableDynamicFiltering, PlanMatchPattern.filter("LINE_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testEqualsPredicateFromFilterSidePropagatesToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey = 2))", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", this.enableDynamicFiltering, PlanMatchPattern.filter("LINE_ORDER_KEY = BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY = BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testPredicateFromFilterSideNotPropagatesToSourceSideOfSemiJoinIfNotIn() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey NOT IN (SELECT orderkey FROM orders WHERE orderkey > 2))", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testGreaterPredicateFromSourceSidePropagatesToFilterSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey > 2)", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", this.enableDynamicFiltering, PlanMatchPattern.filter("LINE_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testEqualPredicateFromSourceSidePropagatesToFilterSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey = 2)", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", this.enableDynamicFiltering, PlanMatchPattern.filter("LINE_ORDER_KEY = BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY = BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testPredicateFromSourceSideNotPropagatesToFilterSideOfSemiJoinIfNotIn() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey NOT IN (SELECT orderkey FROM orders) AND orderkey > 2)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.filter("LINE_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity"))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))));
    }

    @Test
    public void testPredicateFromFilterSideNotPropagatesToSourceSideOfSemiJoinUsedInProjection() {
        this.assertPlan("SELECT orderkey IN (SELECT orderkey FROM orders WHERE orderkey > 2) FROM lineitem", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testFilteredSelectFromPartitionedTable() {
        List allOptimizers = this.getPlanTester().getPlanOptimizers(false);
        this.assertPlan("SELECT DISTINCT orderstatus FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")), allOptimizers);
        this.assertPlan("SELECT orderstatus FROM orders WHERE orderstatus = 'O'", PlanMatchPattern.output(PlanMatchPattern.tableScan("orders")), allOptimizers);
        this.assertPlan("SELECT orderstatus FROM orders WHERE orderstatus = 'no_such_partition_value'", PlanMatchPattern.output(PlanMatchPattern.values("orderstatus")), allOptimizers);
    }

    @Test
    public void testPredicatePushDownThroughMarkDistinct() {
        this.assertPlan("SELECT (SELECT a FROM (VALUES 1, 2, 3) t(a) WHERE a = b) FROM (VALUES 0, 1) p(b) WHERE b = 1", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("A", "B").left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.filter("A = 1", PlanMatchPattern.values("A")))).right(PlanMatchPattern.filter("1 = B", PlanMatchPattern.values("B"))))));
    }

    @Test
    public void testPredicatePushDownOverProjection() {
        this.assertPlan("WITH t AS (SELECT orderkey * 2 x FROM orders) SELECT * FROM t WHERE x + x > 1", PlanMatchPattern.anyTree(PlanMatchPattern.filter("((expr + expr) > BIGINT '1')", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("orderkey * BIGINT '2'")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertPlan("with t AS (SELECT orderkey * 2 x, 1 y FROM orders) SELECT * FROM t WHERE x + y + y >1", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter("(((orderkey * BIGINT '2') + BIGINT '1') + BIGINT '1') > BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertPlan("WITH t AS (SELECT orderkey * 2 x FROM orders) SELECT * FROM t WHERE x > 1", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter("(orderkey * BIGINT '2') > BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertPlan("with t AS (SELECT orderkey * 2 x, orderkey y FROM orders) SELECT * FROM t WHERE x + y > 1", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter("((orderkey * BIGINT '2') + orderkey) > BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertPlan("WITH t AS (SELECT orderkey x FROM orders) SELECT * FROM t WHERE x >1", PlanMatchPattern.anyTree(PlanMatchPattern.filter("orderkey > BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))));
        this.assertPlan("WITH t AS (SELECT rand() * orderkey x FROM orders) SELECT * FROM t WHERE x > 5000", PlanMatchPattern.anyTree(PlanMatchPattern.filter("expr > 5E3", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("random() * CAST(orderkey AS double)")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
    }

    @Test
    public void testPredicatePushDownOverSymbolReferences() {
        this.assertPlan("WITH t AS (SELECT orderkey x, (orderkey + 1) x2 FROM orders) SELECT * FROM t WHERE x > 1 OR x < 0", PlanMatchPattern.anyTree(PlanMatchPattern.filter("orderkey < BIGINT '0' OR orderkey > BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))));
    }

    @Test
    public void testConjunctsOrder() {
        this.assertPlan("select partkey from (  select    partkey,    100/(size-1) x  from part  where size <> 1) where x = 2", PlanMatchPattern.anyTree(PlanMatchPattern.filter("size <> 1 AND 100/(size - 1) = 2", PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey", (Object)"size", (Object)"size")))));
    }

    @Test
    public void testPredicateOnPartitionSymbolsPushedThroughWindow() {
        PlanMatchPattern tableScan = PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUST_KEY", (Object)"custkey", (Object)"ORDER_KEY", (Object)"orderkey"));
        this.assertPlan("SELECT * FROM (SELECT custkey, orderkey, rank() OVER (PARTITION BY custkey  ORDER BY orderdate ASC)FROM orders) WHERE custkey = 0 AND orderkey > 0", PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDER_KEY > BIGINT '0'", PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.filter("CUST_KEY = BIGINT '0'", tableScan)))))));
    }

    @Test
    public void testPredicateOnNonDeterministicSymbolsPushedDown() {
        this.assertPlan("SELECT * FROM (SELECT random_column, orderkey, rank() OVER (PARTITION BY random_column  ORDER BY orderdate ASC)FROM (select round(custkey*rand()) random_column, * from orders) ) WHERE random_column > 100", PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.filter("\"ROUND\" > 1E2", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ROUND", (Object)PlanMatchPattern.expression("round(CAST(CUST_KEY AS double) * random())")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUST_KEY", (Object)"custkey"))))))));
    }

    @Test
    public void testNonDeterministicPredicateNotPushedDown() {
        this.assertPlan("SELECT * FROM (SELECT custkey, orderkey, rank() OVER (PARTITION BY custkey  ORDER BY orderdate ASC)FROM orders) WHERE custkey > 100*rand()", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(CUST_KEY AS double) > (random() * 1E2)", PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUST_KEY", (Object)"custkey"))))))));
    }

    @Test
    public void testRemovesRedundantTableScanPredicate() {
        this.assertPlan("SELECT t1.orderstatus FROM (SELECT orderstatus FROM orders WHERE rand() = orderkey AND orderkey = 123) t1, (VALUES 'F', 'K') t2(col) WHERE t1.orderstatus = t2.col AND (t2.col = 'F' OR t2.col = 'K') AND length(t1.orderstatus) < 42", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.filter("(ORDERKEY = BIGINT '123') AND random() = CAST(ORDERKEY AS double) AND length(ORDERSTATUS) < BIGINT '42'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERSTATUS", (Object)"orderstatus", (Object)"ORDERKEY", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.values("COL")))));
    }

    @Test
    public void testTablePredicateIsExtracted() {
        this.assertPlan("SELECT * FROM orders, nation WHERE orderstatus = CAST(nation.name AS varchar(1)) AND orderstatus BETWEEN 'A' AND 'O'", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.filter("ORDERSTATUS IN ('F', 'O')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERSTATUS", (Object)"orderstatus"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(NAME AS varchar(1)) IN ('F', 'O')", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))))));
        PlanMatchPattern ordersTableScan = PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERSTATUS", (Object)"orderstatus"));
        this.assertPlan("SELECT * FROM orders JOIN nation ON orderstatus = CAST(nation.name AS varchar(1))", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, this.enableDynamicFiltering ? PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, ordersTableScan) : ordersTableScan, PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(NAME AS varchar(1)) IN ('F', 'O', 'P')", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))))));
    }

    @Test
    public void testOnlyNullPredicateIsPushDownThroughJoinFilters() {
        this.assertPlan("WITH t(a) AS (VALUES 'a', 'b')\nSELECT *\nFROM t t1 JOIN t t2 ON true\nWHERE t1.a = 'aa'\n", PlanMatchPattern.output(PlanMatchPattern.values("field", "field_0")));
    }

    @Test
    public void testSimplifyNonInferrableInheritedPredicate() {
        this.assertPlan("SELECT * FROM (SELECT * FROM nation WHERE nationkey = regionkey AND regionkey = 5) a, nation b WHERE a.nationkey = b.nationkey AND a.nationkey + 11 > 15", PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria((List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of()).left(PlanMatchPattern.filter("((L_NATIONKEY = L_REGIONKEY) AND (L_REGIONKEY = BIGINT '5'))", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"L_NATIONKEY", (Object)"nationkey", (Object)"L_REGIONKEY", (Object)"regionkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.filter("R_NATIONKEY = BIGINT '5'", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"R_NATIONKEY", (Object)"nationkey"))))))));
    }

    @Test
    public void testDoesNotCreatePredicateFromInferredPredicate() {
        this.assertPlan("SELECT * FROM (SELECT *, nationkey + 1 as nationkey2 FROM nation) a JOIN nation b ON a.nationkey2 = b.nationkey", PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("L_NATIONKEY2", "R_NATIONKEY").left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"L_NATIONKEY2", (Object)PlanMatchPattern.expression("L_NATIONKEY + BIGINT '1'")), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"L_NATIONKEY", (Object)"nationkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"R_NATIONKEY", (Object)"nationkey")))))));
        this.assertPlan("SELECT * FROM (SELECT * FROM nation WHERE nationkey = 5) a JOIN (SELECT * FROM nation WHERE nationkey = 5) b ON a.nationkey = b.nationkey", PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria((List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of()).left(PlanMatchPattern.filter("L_NATIONKEY = BIGINT '5'", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"L_NATIONKEY", (Object)"nationkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.filter("R_NATIONKEY = BIGINT '5'", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"R_NATIONKEY", (Object)"nationkey"))))))));
    }

    @Test
    public void testSimplifiesStraddlingPredicate() {
        this.assertPlan("SELECT * FROM (SELECT * FROM NATION WHERE nationkey = 5) a JOIN nation b ON a.nationkey = b.nationkey AND a.nationkey = a.regionkey + b.regionkey", PlanMatchPattern.output(PlanMatchPattern.filter("L_REGIONKEY + R_REGIONKEY = BIGINT '5'", PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria((List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of()).left(PlanMatchPattern.filter("L_NATIONKEY = BIGINT '5'", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"L_NATIONKEY", (Object)"nationkey", (Object)"L_REGIONKEY", (Object)"regionkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.filter("R_NATIONKEY = BIGINT '5'", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"R_NATIONKEY", (Object)"nationkey", (Object)"R_REGIONKEY", (Object)"regionkey")))))))));
    }

    protected Session noSemiJoinRewrite() {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("rewrite_filtering_semi_join_to_inner_join", "false").build();
    }
}

