/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestDereferencePushDown
extends BasePlanTest {
    @Test
    public void testDereferencePushdownMultiLevel() {
        this.assertPlan("WITH t(msg) AS (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))), ROW(CAST(ROW(3, 4.0) AS ROW(x BIGINT, y DOUBLE)))) SELECT a.msg.x, a.msg, b.msg.y FROM t a CROSS JOIN t b", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"a_msg_x", (Object)"a_msg", (Object)"b_msg_y"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_msg_x", (Object)PlanMatchPattern.expression("a_msg[1]"), (Object)"a_msg", (Object)PlanMatchPattern.expression("a_msg"), (Object)"b_msg_y", (Object)PlanMatchPattern.expression("b_msg_y")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.values("a_msg")).right(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b_msg_y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new DoubleLiteral("2e0")), (Object)ImmutableList.of((Object)new DoubleLiteral("4e0")))))))));
    }

    @Test
    public void testDereferencePushdownJoin() {
        this.assertPlan("WITH t(msg) AS (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))SELECT b.msg.x FROM t a, t b WHERE a.msg.y = b.msg.y", PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_x", (Object)PlanMatchPattern.expression("b_x")), PlanMatchPattern.filter("a_y = b_y", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b_x", (Object)"b_y", (Object)"a_y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new GenericLiteral("BIGINT", "1"), (Object)new DoubleLiteral("2e0"), (Object)new DoubleLiteral("2e0"))))))));
        this.assertPlan("WITH t(msg) AS (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))SELECT a.msg.y FROM t a JOIN t b ON a.msg.y = b.msg.y WHERE a.msg.x > BIGINT '5'", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"a_y"), PlanMatchPattern.values("a_y")));
        this.assertPlan("WITH t(msg) AS (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))SELECT b.msg.x FROM t a JOIN t b ON a.msg.y = b.msg.y WHERE a.msg.x + b.msg.x < BIGINT '10'", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"b_x"), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.project(PlanMatchPattern.filter("a_y = 2e0", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a_y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new DoubleLiteral("2e0"))))))).right(PlanMatchPattern.project(PlanMatchPattern.filter("b_y = 2e0", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b_x", (Object)"b_y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new GenericLiteral("BIGINT", "1"), (Object)new DoubleLiteral("2e0"))))))))));
    }

    @Test
    public void testDereferencePushdownFilter() {
        this.assertPlan("WITH t(msg) AS (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))SELECT a.msg.y, b.msg.x FROM t a CROSS JOIN t b WHERE a.msg.x = 7 OR IS_FINITE(b.msg.y)", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_y", (Object)PlanMatchPattern.expression("a_y"), (Object)"b_x", (Object)PlanMatchPattern.expression("b_x")), PlanMatchPattern.filter("((a_x = BIGINT '7') OR is_finite(b_y))", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b_x", (Object)"b_y", (Object)"a_x", (Object)"a_y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new GenericLiteral("BIGINT", "1"), (Object)new DoubleLiteral("2e0"), (Object)new GenericLiteral("BIGINT", "1"), (Object)new DoubleLiteral("2e0"))))))));
    }

    @Test
    public void testDereferencePushdownWindow() {
        this.assertPlan("WITH t(msg) AS (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))SELECT msg.x AS x, ROW_NUMBER() OVER (PARTITION BY msg.y) AS rn FROM t ", PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x", (Object)"y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new GenericLiteral("BIGINT", "1"), (Object)new DoubleLiteral("2e0"))))));
        this.assertPlanWithSession("WITH t(msg1, msg2, msg3, msg4, msg5) AS (VALUES ROW(   CAST(ROW(1, 0.0) AS ROW(x BIGINT, y DOUBLE)),   CAST(ROW(2, 0.0) AS ROW(x BIGINT, y DOUBLE)),   CAST(ROW(3, 0.0) AS ROW(x BIGINT, y DOUBLE)),   CAST(ROW(4, 0.0) AS ROW(x BIGINT, y DOUBLE)),   CAST(ROW(5, 0.0) AS ROW(x BIGINT, y DOUBLE))),ROW(   CAST(ROW(1, 1.0) AS ROW(x BIGINT, y DOUBLE)),   CAST(ROW(2, 2.0) AS ROW(x BIGINT, y DOUBLE)),   CAST(ROW(3, 3.0) AS ROW(x BIGINT, y DOUBLE)),   CAST(ROW(4, 4.0) AS ROW(x BIGINT, y DOUBLE)),   CAST(ROW(5, 5.0) AS ROW(x BIGINT, y DOUBLE))))SELECT    msg1.x AS x1,    msg2.x AS x2,    msg3.x AS x3,    msg4.x AS x4,    msg5.x AS x5,    MIN(msg3) OVER (PARTITION BY msg1 ORDER BY msg2) AS msg6,   MIN(msg4.x) OVER (PARTITION BY msg1 ORDER BY msg2) AS bigint_msg4 FROM t", Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("merge_project_with_values", "false").build(), true, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"msg1", (Object)PlanMatchPattern.expression("msg1"), (Object)"msg2", (Object)PlanMatchPattern.expression("msg2"), (Object)"msg3", (Object)PlanMatchPattern.expression("msg3"), (Object)"msg4_x", (Object)PlanMatchPattern.expression("msg4[1]"), (Object)"msg5_x", (Object)PlanMatchPattern.expression("msg5[1]")), PlanMatchPattern.values("msg1", "msg2", "msg3", "msg4", "msg5"))));
    }

    @Test
    public void testDereferencePushdownSemiJoin() {
        this.assertPlan("WITH t(msg) AS (VALUES ROW(CAST(ROW(1, 2.0, 3) AS ROW(x BIGINT, y DOUBLE, z BIGINT)))) SELECT msg.y FROM t WHERE msg.x IN (SELECT msg.z FROM t)", Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("rewrite_filtering_semi_join_to_inner_join", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("a_x", "b_z", "semi_join_symbol", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_y", (Object)PlanMatchPattern.expression("msg[2]")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"msg", (Object)"a_x"), (List<List<Expression>>)ImmutableList.of())), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b_z"), (List<List<Expression>>)ImmutableList.of()))));
    }

    @Test
    public void testDereferencePushdownLimit() {
        this.assertPlan("WITH t(msg) AS (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))), ROW(CAST(ROW(3, 4.0) AS ROW(x BIGINT, y DOUBLE))))SELECT msg.x * 3  FROM t limit 1", PlanMatchPattern.anyTree(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x_into_3", (Object)PlanMatchPattern.expression("msg_x * BIGINT '3'")), PlanMatchPattern.limit(1L, PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"msg_x", (Object)PlanMatchPattern.expression("msg[1]")), PlanMatchPattern.values("msg"))))));
        this.assertPlan("WITH t(msg) AS (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))SELECT b.msg.x FROM t a, t b WHERE a.msg.y = b.msg.y LIMIT 100", PlanMatchPattern.output(PlanMatchPattern.limit(100L, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_x", (Object)PlanMatchPattern.expression("b_x")), PlanMatchPattern.filter("a_y = b_y", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b_x", (Object)"b_y", (Object)"a_y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new GenericLiteral("BIGINT", "1"), (Object)new DoubleLiteral("2e0"), (Object)new DoubleLiteral("2e0")))))))));
        this.assertPlan("WITH t(msg) AS (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))SELECT a.msg.y FROM t a JOIN t b ON a.msg.y = b.msg.y WHERE a.msg.x > BIGINT '5' LIMIT 100", PlanMatchPattern.anyTree(PlanMatchPattern.limit(100L, PlanMatchPattern.values("a_y"))));
        this.assertPlan("WITH t(msg) AS (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE))))SELECT b.msg.x FROM t a JOIN t b ON a.msg.y = b.msg.y WHERE a.msg.x + b.msg.x < BIGINT '10' LIMIT 100", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.project(PlanMatchPattern.filter("a_y = 2e0", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a_y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new DoubleLiteral("2e0"))))))).right(PlanMatchPattern.project(PlanMatchPattern.filter("b_y = 2e0", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b_x", (Object)"b_y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new GenericLiteral("BIGINT", "1"), (Object)new DoubleLiteral("2e0"))))))))));
    }

    @Test
    public void testDereferencePushdownUnnest() {
        this.assertPlan("WITH t(msg, array) AS (VALUES ROW(CAST(ROW(1, 2.0) AS ROW(x BIGINT, y DOUBLE)), ARRAY[1, 2, 3])) SELECT a.msg.x FROM t a JOIN t b ON a.msg.y = b.msg.y CROSS JOIN UNNEST (a.array) WHERE a.msg.x + b.msg.x < BIGINT '10'", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"expr"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("a_x")), PlanMatchPattern.unnest(PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.project(PlanMatchPattern.filter("a_y = 2e0", PlanMatchPattern.values("array", "a_x", "a_y")))).right(PlanMatchPattern.project(PlanMatchPattern.filter("b_y = 2e0", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b_y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new DoubleLiteral("2e0"))))))))))));
    }
}

