/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.sql.planner.AbstractPredicatePushdownTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinType;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPredicatePushdown
extends AbstractPredicatePushdownTest {
    public TestPredicatePushdown() {
        super(true);
    }

    @Override
    @Test
    public void testCoercions() {
        this.assertPlan("WITH     t(k, v) AS (SELECT nationkey, CAST(name AS varchar(4)) FROM nation),    u(k, v) AS (SELECT nationkey, CAST(name AS varchar(4)) FROM nation) SELECT 1 FROM t JOIN u ON t.k = u.k AND t.v = u.v WHERE t.v = 'x'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("t_k", "u_k").dynamicFilter("t_k", "u_k").left(PlanMatchPattern.project(PlanMatchPattern.filter("CAST('x' AS varchar(4)) = CAST(t_v AS varchar(4))", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"t_k", (Object)"nationkey", (Object)"t_v", (Object)"name"))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter("CAST('x' AS varchar(4)) = CAST(u_v AS varchar(4))", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"u_k", (Object)"nationkey", (Object)"u_v", (Object)"name")))))))));
        this.assertPlan("WITH     t(k, v) AS (SELECT nationkey, CAST(name AS varchar(4)) FROM nation),    u(k, v) AS (SELECT nationkey, CAST(name AS varchar(5)) FROM nation) SELECT 1 FROM t JOIN u ON t.k = u.k AND t.v = u.v WHERE t.v = 'x'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("t_k", "u_k").dynamicFilter("t_k", "u_k").left(PlanMatchPattern.project(PlanMatchPattern.filter("CAST('x' AS varchar(4)) = CAST(t_v AS varchar(4))", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"t_k", (Object)"nationkey", (Object)"t_v", (Object)"name"))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter("CAST('x' AS varchar(5)) = CAST(u_v AS varchar(5))", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"u_k", (Object)"nationkey", (Object)"u_v", (Object)"name")))))))));
    }

    @Test
    public void testNormalizeOuterJoinToInner() {
        Session disableJoinReordering = Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("join_reordering_strategy", "NONE").build();
        this.assertPlan("SELECT customer.name, orders.orderdate FROM orders LEFT JOIN customer ON orders.custkey = customer.custkey WHERE customer.name IS NOT NULL", disableJoinReordering, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("o_custkey", "c_custkey").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderdate", (Object)"orderdate", (Object)"o_custkey", (Object)"custkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (c_name IS NULL)", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"c_custkey", (Object)"custkey", (Object)"c_name", (Object)"name"))))))));
        this.assertPlan("SELECT customer.name, lineitem.partkey FROM lineitem LEFT JOIN orders ON lineitem.orderkey = orders.orderkey LEFT JOIN customer ON orders.custkey = customer.custkey WHERE customer.name IS NOT NULL", disableJoinReordering, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("o_custkey", "c_custkey").left(PlanMatchPattern.join(JoinType.INNER, leftJoinBuilder -> leftJoinBuilder.equiCriteria("l_orderkey", "o_orderkey").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey", (Object)"o_custkey", (Object)"custkey")))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT (c_name IS NULL)", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"c_custkey", (Object)"custkey", (Object)"c_name", (Object)"name"))))))));
    }

    @Test
    public void testNonDeterministicPredicateDoesNotPropagateFromFilteringSideToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey = random(5))", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", true, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey"))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.filter("ORDERS_ORDER_KEY = CAST(random(5) AS bigint)", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testNonStraddlingJoinExpression() {
        this.assertPlan("SELECT * FROM orders JOIN lineitem ON orders.orderkey = lineitem.orderkey AND cast(lineitem.linenumber AS varchar) = '2'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("LINEITEM_OK", "ORDERS_OK").left(PlanMatchPattern.filter("cast(LINEITEM_LINENUMBER as varchar) = VARCHAR '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey", (Object)"LINEITEM_LINENUMBER", (Object)"linenumber")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))))));
    }
}

