/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestRecursiveCte
extends BasePlanTest {
    @Override
    protected PlanTester createPlanTester() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setSystemProperty("max_recursion_depth", "1");
        return PlanTester.create((Session)sessionBuilder.build());
    }

    @Test
    public void testRecursiveQuery() {
        String sql = "WITH RECURSIVE t(n) AS (                SELECT 1                UNION ALL                SELECT n + 2 FROM t WHERE n < 6                )                SELECT * from t";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("1")), PlanMatchPattern.values(new String[0])))), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_0", (Object)PlanMatchPattern.expression("expr + 2")), PlanMatchPattern.filter("expr < 6", PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("1")), PlanMatchPattern.values(new String[0])))))))), PlanMatchPattern.filter("IF((count >= BIGINT '0'), " + String.format("CAST(fail(INTEGER '%d', VARCHAR 'Recursion depth limit exceeded (1). Use ''max_recursion_depth'' session property to modify the limit.') AS boolean), ", StandardErrorCode.NOT_SUPPORTED.toErrorCode().getCode()) + "true)", PlanMatchPattern.window(windowBuilder -> windowBuilder.addFunction("count", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_1", (Object)PlanMatchPattern.expression("expr + 2")), PlanMatchPattern.filter("expr < 6", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("expr_0")), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_0", (Object)PlanMatchPattern.expression("expr + 2")), PlanMatchPattern.filter("expr < 6", PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("1")), PlanMatchPattern.values(new String[0])))))))))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }
}

