/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.tracing.Tracing;
import io.trino.FeaturesConfig;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogServiceProvider;
import io.trino.metadata.BlockEncodingManager;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.LanguageFunctionManager;
import io.trino.metadata.LanguageFunctionProvider;
import io.trino.metadata.LiteralFunction;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.SqlFunction;
import io.trino.metadata.SystemFunctionBundle;
import io.trino.metadata.TypeRegistry;
import io.trino.operator.scalar.json.JsonExistsFunction;
import io.trino.operator.scalar.json.JsonQueryFunction;
import io.trino.operator.scalar.json.JsonValueFunction;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.type.ParametricType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.PlannerContext;
import io.trino.sql.parser.SqlParser;
import io.trino.transaction.TransactionManager;
import io.trino.type.BlockTypeOperators;
import io.trino.type.InternalTypeManager;
import io.trino.type.JsonPath2016Type;
import io.trino.type.TypeDeserializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class TestingPlannerContext {
    public static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().build();

    private TestingPlannerContext() {
    }

    public static Builder plannerContextBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Metadata metadata;
        private TransactionManager transactionManager;
        private final List<Type> types = new ArrayList<Type>();
        private final List<ParametricType> parametricTypes = new ArrayList<ParametricType>();
        private final List<FunctionBundle> functionBundles = new ArrayList<FunctionBundle>();

        private Builder() {
        }

        public Builder withMetadata(Metadata metadata) {
            Preconditions.checkState((this.metadata == null ? 1 : 0) != 0, (Object)"metadata already set");
            Preconditions.checkState((this.transactionManager == null ? 1 : 0) != 0, (Object)"transactionManager already set");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            return this;
        }

        public Builder withTransactionManager(TransactionManager transactionManager) {
            Preconditions.checkState((this.metadata == null ? 1 : 0) != 0, (Object)"metadata already set");
            Preconditions.checkState((this.transactionManager == null ? 1 : 0) != 0, (Object)"transactionManager already set");
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
            return this;
        }

        public Builder addType(Type type) {
            this.types.add(type);
            return this;
        }

        public Builder addParametricType(ParametricType parametricType) {
            this.parametricTypes.add(parametricType);
            return this;
        }

        public Builder addFunctions(FunctionBundle functionBundle) {
            this.functionBundles.add(functionBundle);
            return this;
        }

        public PlannerContext build() {
            FeaturesConfig featuresConfig = new FeaturesConfig();
            TypeOperators typeOperators = new TypeOperators();
            TypeRegistry typeRegistry = new TypeRegistry(typeOperators, featuresConfig);
            InternalTypeManager typeManager = new InternalTypeManager(typeRegistry);
            this.types.forEach(arg_0 -> ((TypeRegistry)typeRegistry).addType(arg_0));
            this.parametricTypes.forEach(arg_0 -> ((TypeRegistry)typeRegistry).addParametricType(arg_0));
            GlobalFunctionCatalog globalFunctionCatalog = new GlobalFunctionCatalog(() -> {
                throw new UnsupportedOperationException();
            }, () -> {
                throw new UnsupportedOperationException();
            }, () -> {
                throw new UnsupportedOperationException();
            });
            globalFunctionCatalog.addFunctions(SystemFunctionBundle.create((FeaturesConfig)featuresConfig, (TypeOperators)typeOperators, (BlockTypeOperators)new BlockTypeOperators(typeOperators), (NodeVersion)NodeVersion.UNKNOWN));
            this.functionBundles.forEach(arg_0 -> ((GlobalFunctionCatalog)globalFunctionCatalog).addFunctions(arg_0));
            InternalBlockEncodingSerde blockEncodingSerde = new InternalBlockEncodingSerde(new BlockEncodingManager(), (TypeManager)typeManager);
            globalFunctionCatalog.addFunctions((FunctionBundle)new InternalFunctionBundle(new SqlFunction[]{new LiteralFunction((BlockEncodingSerde)blockEncodingSerde)}));
            LanguageFunctionManager languageFunctionManager = new LanguageFunctionManager(new SqlParser(), (TypeManager)typeManager, user -> ImmutableSet.of());
            Metadata metadata = this.metadata;
            if (metadata == null) {
                MetadataManager.TestMetadataManagerBuilder builder = MetadataManager.testMetadataManagerBuilder().withTypeManager((TypeManager)typeManager).withLanguageFunctionManager(languageFunctionManager).withGlobalFunctionCatalog(globalFunctionCatalog);
                if (this.transactionManager != null) {
                    builder.withTransactionManager(this.transactionManager);
                }
                metadata = builder.build();
            }
            FunctionManager functionManager = new FunctionManager(CatalogServiceProvider.fail(), globalFunctionCatalog, LanguageFunctionProvider.DISABLED);
            globalFunctionCatalog.addFunctions((FunctionBundle)new InternalFunctionBundle(new SqlFunction[]{new JsonExistsFunction(functionManager, metadata, (TypeManager)typeManager), new JsonValueFunction(functionManager, metadata, (TypeManager)typeManager), new JsonQueryFunction(functionManager, metadata, (TypeManager)typeManager)}));
            typeRegistry.addType((Type)new JsonPath2016Type(new TypeDeserializer((TypeManager)typeManager), (BlockEncodingSerde)blockEncodingSerde));
            return new PlannerContext(metadata, typeOperators, (BlockEncodingSerde)blockEncodingSerde, (TypeManager)typeManager, functionManager, languageFunctionManager, Tracing.noopTracer());
        }
    }
}

