/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.operator.join.JoinUtils;
import io.trino.sql.DynamicFilters;
import io.trino.sql.planner.ExpressionExtractor;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionVerifier;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NotExpression;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class JoinMatcher
implements Matcher {
    private final JoinType joinType;
    private final List<ExpectedValueProvider<JoinNode.EquiJoinClause>> equiCriteria;
    private final boolean ignoreEquiCriteria;
    private final Optional<Expression> filter;
    private final Optional<JoinNode.DistributionType> distributionType;
    private final Optional<Boolean> spillable;
    private final Optional<List<PlanMatchPattern.DynamicFilterPattern>> expectedDynamicFilter;

    JoinMatcher(JoinType joinType, List<ExpectedValueProvider<JoinNode.EquiJoinClause>> equiCriteria, boolean ignoreEquiCriteria, Optional<Expression> filter, Optional<JoinNode.DistributionType> distributionType, Optional<Boolean> spillable, Optional<List<PlanMatchPattern.DynamicFilterPattern>> expectedDynamicFilter) {
        this.joinType = Objects.requireNonNull(joinType, "joinType is null");
        this.equiCriteria = Objects.requireNonNull(equiCriteria, "equiCriteria is null");
        if (ignoreEquiCriteria && !equiCriteria.isEmpty()) {
            throw new IllegalArgumentException("ignoreEquiCriteria passed with non-empty equiCriteria");
        }
        this.ignoreEquiCriteria = ignoreEquiCriteria;
        this.filter = Objects.requireNonNull(filter, "filter cannot be null");
        this.distributionType = Objects.requireNonNull(distributionType, "distributionType is null");
        this.spillable = Objects.requireNonNull(spillable, "spillable is null");
        this.expectedDynamicFilter = Objects.requireNonNull(expectedDynamicFilter, "expectedDynamicFilter is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof JoinNode)) {
            return false;
        }
        JoinNode joinNode = (JoinNode)node;
        return joinNode.getType() == this.joinType;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        JoinNode joinNode = (JoinNode)node;
        if (!this.ignoreEquiCriteria && joinNode.getCriteria().size() != this.equiCriteria.size()) {
            return MatchResult.NO_MATCH;
        }
        if (this.filter.isPresent()) {
            if (joinNode.getFilter().isEmpty()) {
                return MatchResult.NO_MATCH;
            }
            if (!((Boolean)new ExpressionVerifier(symbolAliases).process((Node)joinNode.getFilter().get(), this.filter.get())).booleanValue()) {
                return MatchResult.NO_MATCH;
            }
        } else if (joinNode.getFilter().isPresent()) {
            return MatchResult.NO_MATCH;
        }
        if (this.distributionType.isPresent() && !this.distributionType.equals(joinNode.getDistributionType())) {
            return MatchResult.NO_MATCH;
        }
        if (this.spillable.isPresent() && !this.spillable.equals(joinNode.isSpillable())) {
            return MatchResult.NO_MATCH;
        }
        if (!this.ignoreEquiCriteria) {
            ImmutableSet actual = ImmutableSet.copyOf((Collection)joinNode.getCriteria());
            Set expected = (Set)this.equiCriteria.stream().map(maker -> (JoinNode.EquiJoinClause)maker.getExpectedValue(symbolAliases)).collect(ImmutableSet.toImmutableSet());
            if (!expected.equals(actual)) {
                return MatchResult.NO_MATCH;
            }
        }
        return new MatchResult(this.matchDynamicFilters(joinNode, symbolAliases));
    }

    private boolean matchDynamicFilters(JoinNode joinNode, SymbolAliases symbolAliases) {
        if (this.expectedDynamicFilter.isEmpty()) {
            return true;
        }
        Map idToBuildSymbolMap = JoinUtils.getJoinDynamicFilters((JoinNode)joinNode);
        Set dynamicFilterIds = idToBuildSymbolMap.keySet();
        List descriptors = (List)PlanNodeSearcher.searchFrom((PlanNode)joinNode.getLeft()).where(FilterNode.class::isInstance).findAll().stream().flatMap(filterNode -> ExpressionExtractor.extractExpressions((PlanNode)filterNode).stream()).flatMap(expression -> DynamicFilters.extractDynamicFilters((Expression)expression).getDynamicConjuncts().stream()).filter(descriptor -> dynamicFilterIds.contains(descriptor.getId())).collect(ImmutableList.toImmutableList());
        HashSet<ComparisonExpression> actual = new HashSet<ComparisonExpression>();
        for (DynamicFilters.Descriptor descriptor2 : descriptors) {
            Expression probe = descriptor2.getInput();
            Symbol build = (Symbol)idToBuildSymbolMap.get(descriptor2.getId());
            if (build == null) {
                return false;
            }
            Object expression2 = descriptor2.isNullAllowed() ? new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, probe, (Expression)build.toSymbolReference())) : new ComparisonExpression(descriptor2.getOperator(), probe, (Expression)build.toSymbolReference());
            actual.add((ComparisonExpression)expression2);
        }
        Set expected = (Set)this.expectedDynamicFilter.get().stream().map(pattern -> pattern.getExpression(symbolAliases)).collect(ImmutableSet.toImmutableSet());
        return expected.equals(actual);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("type", (Object)this.joinType).add("equiCriteria", this.equiCriteria).add("filter", this.filter.orElse(null)).add("distributionType", this.distributionType).add("dynamicFilter", this.expectedDynamicFilter).toString();
    }

    public static class Builder {
        private final JoinType joinType;
        private Optional<List<ExpectedValueProvider<JoinNode.EquiJoinClause>>> equiCriteria = Optional.empty();
        private Optional<List<PlanMatchPattern.DynamicFilterPattern>> dynamicFilter = Optional.empty();
        private Optional<JoinNode.DistributionType> distributionType = Optional.empty();
        private Optional<Boolean> expectedSpillable = Optional.empty();
        private PlanMatchPattern left;
        private PlanMatchPattern right;
        private Optional<String> filter = Optional.empty();
        private boolean ignoreEquiCriteria;

        public Builder(JoinType joinType) {
            this.joinType = joinType;
        }

        @CanIgnoreReturnValue
        public Builder equiCriteria(List<ExpectedValueProvider<JoinNode.EquiJoinClause>> expectedEquiCriteria) {
            this.equiCriteria = Optional.of(expectedEquiCriteria);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder equiCriteria(String left, String right) {
            this.equiCriteria = Optional.of(ImmutableList.of(PlanMatchPattern.equiJoinClause(left, right)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder filter(String expectedFilter) {
            this.filter = Optional.of(expectedFilter);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder dynamicFilter(Map<String, String> expectedDynamicFilter) {
            this.dynamicFilter = Optional.of((List)expectedDynamicFilter.entrySet().stream().map(entry -> new PlanMatchPattern.DynamicFilterPattern((String)entry.getKey(), ComparisonExpression.Operator.EQUAL, (String)entry.getValue())).collect(ImmutableList.toImmutableList()));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder dynamicFilter(String key, String value) {
            this.dynamicFilter = Optional.of(ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern(key, ComparisonExpression.Operator.EQUAL, value)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder dynamicFilter(List<PlanMatchPattern.DynamicFilterPattern> expectedDynamicFilter) {
            this.dynamicFilter = Optional.of(expectedDynamicFilter);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder distributionType(JoinNode.DistributionType expectedDistributionType) {
            this.distributionType = Optional.of(expectedDistributionType);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder spillable(Boolean expectedSpillable) {
            this.expectedSpillable = Optional.of(expectedSpillable);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder left(PlanMatchPattern left) {
            this.left = left;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder right(PlanMatchPattern right) {
            this.right = right;
            return this;
        }

        public Builder ignoreEquiCriteria() {
            this.ignoreEquiCriteria = true;
            return this;
        }

        public PlanMatchPattern build() {
            return PlanMatchPattern.node(JoinNode.class, this.left, this.right).with(new JoinMatcher(this.joinType, this.equiCriteria.orElse((List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of()), this.ignoreEquiCriteria, this.filter.map(PlanBuilder::expression), this.distributionType, this.expectedSpillable, this.dynamicFilter));
        }
    }
}

