/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.PlanTestSymbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.AddIntermediateAggregations;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestAddIntermediateAggregations
extends BaseRuleTest {
    public TestAddIntermediateAggregations() {
        super(new Plugin[0]);
    }

    @Test
    public void testBasic() {
        ExpectedValueProvider<AggregationFunction> aggregationPattern = PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol()));
        this.tester().assertThat((Rule<?>)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "true").setSystemProperty("task_concurrency", "4").on(p -> p.aggregation(af -> af.globalGrouping().step(AggregationNode.Step.FINAL).addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE, (PlanNode)p.aggregation(ap -> ap.globalGrouping().step(AggregationNode.Step.PARTIAL).addAggregation(p.symbol("b"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a")))))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0)))))))))));
    }

    @Test
    public void testNoInputCount() {
        ExpectedValueProvider<AggregationFunction> rawInputCount = PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of());
        ExpectedValueProvider<AggregationFunction> partialInputCount = PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol()));
        this.tester().assertThat((Rule<?>)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "true").setSystemProperty("task_concurrency", "4").on(p -> p.aggregation(af -> af.globalGrouping().step(AggregationNode.Step.FINAL).addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE, (PlanNode)p.aggregation(ap -> ap.globalGrouping().step(AggregationNode.Step.PARTIAL).addAggregation(p.symbol("b"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).source((PlanNode)p.values(p.symbol("a")))))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), partialInputCount), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), partialInputCount), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), partialInputCount), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), rawInputCount), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0)))))))))));
    }

    @Test
    public void testMultipleExchanges() {
        ExpectedValueProvider<AggregationFunction> aggregationPattern = PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol()));
        this.tester().assertThat((Rule<?>)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "true").setSystemProperty("task_concurrency", "4").on(p -> p.aggregation(af -> af.globalGrouping().step(AggregationNode.Step.FINAL).addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE, (PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE, (PlanNode)p.aggregation(ap -> ap.globalGrouping().step(AggregationNode.Step.PARTIAL).addAggregation(p.symbol("b"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a"))))))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0))))))))))));
    }

    @Test
    public void testSessionDisable() {
        this.tester().assertThat((Rule<?>)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "false").setSystemProperty("task_concurrency", "4").on(p -> p.aggregation(af -> af.globalGrouping().step(AggregationNode.Step.FINAL).addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE, (PlanNode)p.aggregation(ap -> ap.globalGrouping().step(AggregationNode.Step.PARTIAL).addAggregation(p.symbol("b"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
    }

    @Test
    public void testNoLocalParallel() {
        ExpectedValueProvider<AggregationFunction> aggregationPattern = PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol()));
        this.tester().assertThat((Rule<?>)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "true").setSystemProperty("task_concurrency", "1").on(p -> p.aggregation(af -> af.globalGrouping().step(AggregationNode.Step.FINAL).addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE, (PlanNode)p.aggregation(ap -> ap.globalGrouping().step(AggregationNode.Step.PARTIAL).addAggregation(p.symbol("b"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a")))))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0))))))));
    }

    @Test
    public void testWithGroups() {
        this.tester().assertThat((Rule<?>)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "true").setSystemProperty("task_concurrency", "4").on(p -> p.aggregation(af -> af.singleGroupingSet(p.symbol("c")).step(AggregationNode.Step.FINAL).addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE, (PlanNode)p.aggregation(ap -> ap.singleGroupingSet(p.symbol("b")).step(AggregationNode.Step.PARTIAL).addAggregation(p.symbol("b"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
    }

    @Test
    public void testInterimProject() {
        ExpectedValueProvider<AggregationFunction> aggregationPattern = PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol()));
        this.tester().assertThat((Rule<?>)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "true").setSystemProperty("task_concurrency", "4").on(p -> p.aggregation(af -> af.globalGrouping().step(AggregationNode.Step.FINAL).addAggregation(p.symbol("c"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE, (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("b")}), (PlanNode)p.aggregation(ap -> ap.globalGrouping().step(AggregationNode.Step.PARTIAL).addAggregation(p.symbol("b"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a"))))))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), aggregationPattern), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0))))))))))));
    }
}

