/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.rule.CanonicalizeExpressions;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import org.junit.jupiter.api.Test;

public class TestCanonicalizeExpressions
extends BaseRuleTest {
    public TestCanonicalizeExpressions() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireForExpressionsInCanonicalForm() {
        CanonicalizeExpressions canonicalizeExpressions = new CanonicalizeExpressions(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer());
        this.tester().assertThat(canonicalizeExpressions.filterExpressionRewrite()).on(p -> p.filter((Expression)BooleanLiteral.FALSE_LITERAL, (PlanNode)p.values(new Symbol[0]))).doesNotFire();
    }

    @Test
    public void testDoesNotFireForUnfilteredJoin() {
        CanonicalizeExpressions canonicalizeExpressions = new CanonicalizeExpressions(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer());
        this.tester().assertThat(canonicalizeExpressions.joinExpressionRewrite()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireForCanonicalExpressions() {
        CanonicalizeExpressions canonicalizeExpressions = new CanonicalizeExpressions(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer());
        this.tester().assertThat(canonicalizeExpressions.joinExpressionRewrite()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]), (Expression)BooleanLiteral.FALSE_LITERAL, new JoinNode.EquiJoinClause[0])).doesNotFire();
    }
}

