/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ImplementTableFunctionSource;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestImplementTableFunctionSource
extends BaseRuleTest {
    public TestImplementTableFunctionSource() {
        super(new Plugin[0]);
    }

    @Test
    public void testNoSources() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<PlanNode>)ImmutableList.of(), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of(), (List<List<String>>)ImmutableList.of())).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a"))));
    }

    @Test
    public void testSingleSourceWithRowSemantics() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("table_argument", true, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of()), (List)ImmutableList.of((Object)c), Optional.empty())), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of())).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"))), PlanMatchPattern.values("c")));
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("table_argument", true, true, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, false))), (List)ImmutableList.of((Object)c), Optional.empty())), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"))), PlanMatchPattern.values("c")));
    }

    @Test
    public void testSingleSourceWithSetSemantics() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("table_argument", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of()), (List)ImmutableList.of((Object)c, (Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)d), (Map)ImmutableMap.of((Object)d, (Object)SortOrder.ASC_NULLS_LAST))))))), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of())).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c", (Object)"d"))).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"d"), (Map<String, SortOrder>)ImmutableMap.of((Object)"d", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.values("c", "d")));
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("table_argument", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c, (Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)d), (Map)ImmutableMap.of((Object)d, (Object)SortOrder.ASC_NULLS_LAST))))))), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c", (Object)"d"))).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of((Object)"d"), (Map<String, SortOrder>)ImmutableMap.of((Object)"d", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.values("c", "d")));
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("table_argument", false, false, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true), (Object)new TableFunctionNode.PassThroughColumn(d, false))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty())))), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c", (Object)"d"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"d"))).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())), PlanMatchPattern.values("c", "d")));
    }

    @Test
    public void testTwoSourcesWithSetSemantics() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d), (Object)p.values(e, f)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, false, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, false), (Object)new TableFunctionNode.PassThroughColumn(f, false))), (List)ImmutableList.of((Object)f), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.empty())))), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"e", (Object)"f"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"f"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_1", (Object)"e", (Object)"marker_2", (Object)"f", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression("IF(input_1_row_number = combined_row_number, input_1_row_number, CAST(null AS bigint))"), (Object)"marker_2", (Object)PlanMatchPattern.expression("IF(input_2_row_number = combined_row_number, input_2_row_number, CAST(null AS bigint))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_row_number, BIGINT '-1') > COALESCE(input_2_row_number, BIGINT '-1'), input_1_row_number, input_2_row_number)"), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_partition_size, BIGINT '-1') > COALESCE(input_2_partition_size, BIGINT '-1'), input_1_partition_size, input_2_partition_size)")), PlanMatchPattern.join(JoinType.FULL, joinBuilder -> joinBuilder.filter("input_1_row_number = input_2_row_number OR\ninput_1_row_number > input_2_partition_size AND input_2_row_number = BIGINT '1' OR\ninput_2_row_number > input_1_partition_size AND input_1_row_number = BIGINT '1'\n").left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_1_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("c", "d"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_2_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("e", "f"))))))));
    }

    @Test
    public void testThreeSourcesWithSetSemantics() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            Symbol g = p.symbol("g");
            Symbol h = p.symbol("h");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d), (Object)p.values(e, f), (Object)p.values(g, h)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, false, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, false), (Object)new TableFunctionNode.PassThroughColumn(f, false))), (List)ImmutableList.of((Object)f), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_3", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of()), (List)ImmutableList.of((Object)h), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)h), (Map)ImmutableMap.of((Object)h, (Object)SortOrder.DESC_NULLS_FIRST))))))), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"e", (Object)"f"), (Object)ImmutableList.of())).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"f"), (Object)ImmutableList.of((Object)"h"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_1", (Object)"e", (Object)"marker_2", (Object)"f", (Object)"marker_2", (Object)"g", (Object)"marker_3", (Object)"h", (Object)"marker_3")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of((Object)"combined_row_number_1_2_3"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number_1_2_3", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression("IF(input_1_row_number = combined_row_number_1_2_3, input_1_row_number, CAST(null AS bigint))"), (Object)"marker_2", (Object)PlanMatchPattern.expression("IF(input_2_row_number = combined_row_number_1_2_3, input_2_row_number, CAST(null AS bigint))"), (Object)"marker_3", (Object)PlanMatchPattern.expression("IF(input_3_row_number = combined_row_number_1_2_3, input_3_row_number, CAST(null AS bigint))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_1_2_3", (Object)PlanMatchPattern.expression("IF(COALESCE(combined_row_number_1_2, BIGINT '-1') > COALESCE(input_3_row_number, BIGINT '-1'), combined_row_number_1_2, input_3_row_number)"), (Object)"combined_partition_size_1_2_3", (Object)PlanMatchPattern.expression("IF(COALESCE(combined_partition_size_1_2, BIGINT '-1') > COALESCE(input_3_partition_size, BIGINT '-1'), combined_partition_size_1_2, input_3_partition_size)")), PlanMatchPattern.join(JoinType.FULL, joinBuilder -> joinBuilder.filter("combined_row_number_1_2 = input_3_row_number OR\ncombined_row_number_1_2 > input_3_partition_size AND input_3_row_number = BIGINT '1' OR\ninput_3_row_number > combined_partition_size_1_2 AND combined_row_number_1_2 = BIGINT '1'\n").left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_1_2", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_row_number, BIGINT '-1') > COALESCE(input_2_row_number, BIGINT '-1'), input_1_row_number, input_2_row_number)"), (Object)"combined_partition_size_1_2", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_partition_size, BIGINT '-1') > COALESCE(input_2_partition_size, BIGINT '-1'), input_1_partition_size, input_2_partition_size)")), PlanMatchPattern.join(JoinType.FULL, nestedJoinBuilder -> nestedJoinBuilder.filter("input_1_row_number = input_2_row_number OR\ninput_1_row_number > input_2_partition_size AND input_2_row_number = BIGINT '1' OR\ninput_2_row_number > input_1_partition_size AND input_1_row_number = BIGINT '1'\n").left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_1_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("c", "d"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_2_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("e", "f")))))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"h"), (Map<String, SortOrder>)ImmutableMap.of((Object)"h", (Object)SortOrder.DESC_NULLS_FIRST))).addFunction("input_3_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_3_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("g", "h"))))))));
    }

    @Test
    public void testTwoCoPartitionedSources() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d), (Object)p.values(e, f)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c, (Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, false, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, true), (Object)new TableFunctionNode.PassThroughColumn(f, false))), (List)ImmutableList.of((Object)f), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)e), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)f), (Map)ImmutableMap.of((Object)f, (Object)SortOrder.DESC_NULLS_FIRST))))))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"e", (Object)"f"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)ImmutableList.of((Object)"f"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_1", (Object)"e", (Object)"marker_2", (Object)"f", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression("IF(input_1_row_number = combined_row_number, input_1_row_number, CAST(null AS bigint))"), (Object)"marker_2", (Object)PlanMatchPattern.expression("IF(input_2_row_number = combined_row_number, input_2_row_number, CAST(null AS bigint))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_row_number, BIGINT '-1') > COALESCE(input_2_row_number, BIGINT '-1'), input_1_row_number, input_2_row_number)"), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_partition_size, BIGINT '-1') > COALESCE(input_2_partition_size, BIGINT '-1'), input_1_partition_size, input_2_partition_size)"), (Object)"combined_partition_column", (Object)PlanMatchPattern.expression("COALESCE(c, e)")), PlanMatchPattern.join(JoinType.LEFT, joinBuilder -> joinBuilder.filter("NOT (c IS DISTINCT FROM e)\nAND (\n     input_1_row_number = input_2_row_number OR\n     input_1_row_number > input_2_partition_size AND input_2_row_number = BIGINT '1' OR\n     input_2_row_number > input_1_partition_size AND input_1_row_number = BIGINT '1')\n").left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_1_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("c", "d"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"e"), (List<String>)ImmutableList.of((Object)"f"), (Map<String, SortOrder>)ImmutableMap.of((Object)"f", (Object)SortOrder.DESC_NULLS_FIRST))).addFunction("input_2_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_2_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("e", "f"))))))));
    }

    @Test
    public void testCoPartitionJoinTypes() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c), (Object)p.values(d)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)d), Optional.empty())))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression("IF(input_1_row_number = combined_row_number, input_1_row_number, CAST(null AS bigint))"), (Object)"marker_2", (Object)PlanMatchPattern.expression("IF(input_2_row_number = combined_row_number, input_2_row_number, CAST(null AS bigint))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_row_number, BIGINT '-1') > COALESCE(input_2_row_number, BIGINT '-1'), input_1_row_number, input_2_row_number)"), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_partition_size, BIGINT '-1') > COALESCE(input_2_partition_size, BIGINT '-1'), input_1_partition_size, input_2_partition_size)"), (Object)"combined_partition_column", (Object)PlanMatchPattern.expression("COALESCE(c, d)")), PlanMatchPattern.join(JoinType.INNER, joinBuilder -> joinBuilder.filter("NOT (c IS DISTINCT FROM d)\nAND (\n     input_1_row_number = input_2_row_number OR\n     input_1_row_number > input_2_partition_size AND input_2_row_number = BIGINT '1' OR\n     input_2_row_number > input_1_partition_size AND input_1_row_number = BIGINT '1')\n").left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_1_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("c"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_2_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("d"))))))));
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c), (Object)p.values(d)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)d), Optional.empty())))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression("IF(input_1_row_number = combined_row_number, input_1_row_number, CAST(null AS bigint))"), (Object)"marker_2", (Object)PlanMatchPattern.expression("IF(input_2_row_number = combined_row_number, input_2_row_number, CAST(null AS bigint))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_row_number, BIGINT '-1') > COALESCE(input_2_row_number, BIGINT '-1'), input_1_row_number, input_2_row_number)"), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_partition_size, BIGINT '-1') > COALESCE(input_2_partition_size, BIGINT '-1'), input_1_partition_size, input_2_partition_size)"), (Object)"combined_partition_column", (Object)PlanMatchPattern.expression("COALESCE(c, d)")), PlanMatchPattern.join(JoinType.LEFT, joinBuilder -> joinBuilder.filter("NOT (c IS DISTINCT FROM d)\nAND (\n     input_1_row_number = input_2_row_number OR\n     input_1_row_number > input_2_partition_size AND input_2_row_number = BIGINT '1' OR\n     input_2_row_number > input_1_partition_size AND input_1_row_number = BIGINT '1')\n").left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_1_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("c"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_2_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("d"))))))));
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c), (Object)p.values(d)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)d), Optional.empty())))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression("IF(input_1_row_number = combined_row_number, input_1_row_number, CAST(null AS bigint))"), (Object)"marker_2", (Object)PlanMatchPattern.expression("IF(input_2_row_number = combined_row_number, input_2_row_number, CAST(null AS bigint))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression("IF(COALESCE(input_2_row_number, BIGINT '-1') > COALESCE(input_1_row_number, BIGINT '-1'), input_2_row_number, input_1_row_number)"), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression("IF(COALESCE(input_2_partition_size, BIGINT '-1') > COALESCE(input_1_partition_size, BIGINT '-1'), input_2_partition_size, input_1_partition_size)"), (Object)"combined_partition_column", (Object)PlanMatchPattern.expression("COALESCE(d, c)")), PlanMatchPattern.join(JoinType.LEFT, joinBuilder -> joinBuilder.filter("NOT (d IS DISTINCT FROM c)\nAND (\n     input_2_row_number = input_1_row_number OR\n     input_2_row_number > input_1_partition_size AND input_1_row_number = BIGINT '1' OR\n     input_1_row_number > input_2_partition_size AND input_2_row_number = BIGINT '1')\n").left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_2_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("d"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_1_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("c"))))))));
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c), (Object)p.values(d)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)d), Optional.empty())))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression("IF(input_1_row_number = combined_row_number, input_1_row_number, CAST(null AS bigint))"), (Object)"marker_2", (Object)PlanMatchPattern.expression("IF(input_2_row_number = combined_row_number, input_2_row_number, CAST(null AS bigint))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_row_number, BIGINT '-1') > COALESCE(input_2_row_number, BIGINT '-1'), input_1_row_number, input_2_row_number)"), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_partition_size, BIGINT '-1') > COALESCE(input_2_partition_size, BIGINT '-1'), input_1_partition_size, input_2_partition_size)"), (Object)"combined_partition_column", (Object)PlanMatchPattern.expression("COALESCE(c, d)")), PlanMatchPattern.join(JoinType.FULL, joinBuilder -> joinBuilder.filter("NOT (c IS DISTINCT FROM d)\nAND (\n     input_1_row_number = input_2_row_number OR\n     input_1_row_number > input_2_partition_size AND input_2_row_number = BIGINT '1' OR\n     input_2_row_number > input_1_partition_size AND input_1_row_number = BIGINT '1')\n").left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_1_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("c"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_2_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("d"))))))));
    }

    @Test
    public void testThreeCoPartitionedSources() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c), (Object)p.values(d), (Object)p.values(e)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)d), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_3", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, true))), (List)ImmutableList.of((Object)e), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)e), Optional.empty())))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2", (Object)"input_3")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"e"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"e"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_2", (Object)"e", (Object)"marker_3")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column_1_2_3"), (List<String>)ImmutableList.of((Object)"combined_row_number_1_2_3"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number_1_2_3", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression("IF(input_1_row_number = combined_row_number_1_2_3, input_1_row_number, CAST(null AS bigint))"), (Object)"marker_2", (Object)PlanMatchPattern.expression("IF(input_2_row_number = combined_row_number_1_2_3, input_2_row_number, CAST(null AS bigint))"), (Object)"marker_3", (Object)PlanMatchPattern.expression("IF(input_3_row_number = combined_row_number_1_2_3, input_3_row_number, CAST(null AS bigint))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_1_2_3", (Object)PlanMatchPattern.expression("IF(COALESCE(combined_row_number_1_2, BIGINT '-1') > COALESCE(input_3_row_number, BIGINT '-1'), combined_row_number_1_2, input_3_row_number)"), (Object)"combined_partition_size_1_2_3", (Object)PlanMatchPattern.expression("IF(COALESCE(combined_partition_size_1_2, BIGINT '-1') > COALESCE(input_3_partition_size, BIGINT '-1'), combined_partition_size_1_2, input_3_partition_size)"), (Object)"combined_partition_column_1_2_3", (Object)PlanMatchPattern.expression("COALESCE(combined_partition_column_1_2, e)")), PlanMatchPattern.join(JoinType.LEFT, joinBuilder -> joinBuilder.filter("NOT (combined_partition_column_1_2 IS DISTINCT FROM e)\nAND (\n     combined_row_number_1_2 = input_3_row_number OR\n     combined_row_number_1_2 > input_3_partition_size AND input_3_row_number = BIGINT '1' OR\n     input_3_row_number > combined_partition_size_1_2 AND combined_row_number_1_2 = BIGINT '1')\n").left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_1_2", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_row_number, BIGINT '-1') > COALESCE(input_2_row_number, BIGINT '-1'), input_1_row_number, input_2_row_number)"), (Object)"combined_partition_size_1_2", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_partition_size, BIGINT '-1') > COALESCE(input_2_partition_size, BIGINT '-1'), input_1_partition_size, input_2_partition_size)"), (Object)"combined_partition_column_1_2", (Object)PlanMatchPattern.expression("COALESCE(c, d)")), PlanMatchPattern.join(JoinType.INNER, nestedJoinBuilder -> nestedJoinBuilder.filter("NOT (c IS DISTINCT FROM d)\nAND (\n     input_1_row_number = input_2_row_number OR\n     input_1_row_number > input_2_partition_size AND input_2_row_number = BIGINT '1' OR\n     input_2_row_number > input_1_partition_size AND input_1_row_number = BIGINT '1')\n").left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_1_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("c"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_2_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("d")))))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"e"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_3_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_3_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("e"))))))));
    }

    @Test
    public void testTwoCoPartitionLists() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            Symbol g = p.symbol("g");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c), (Object)p.values(d), (Object)p.values(e), (Object)p.values(f, g)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)d), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_3", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, true))), (List)ImmutableList.of((Object)e), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)e), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_4", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(f, true))), (List)ImmutableList.of((Object)g), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)f), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)g), (Map)ImmutableMap.of((Object)g, (Object)SortOrder.DESC_NULLS_FIRST))))))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2"), (Object)ImmutableList.of((Object)"input_3", (Object)"input_4")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"e"), (Object)ImmutableList.of((Object)"f"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"e"), (Object)ImmutableList.of((Object)"g"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_2", (Object)"e", (Object)"marker_3", (Object)"f", (Object)"marker_4", (Object)"g", (Object)"marker_4")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column_1_2", (Object)"combined_partition_column_3_4"), (List<String>)ImmutableList.of((Object)"combined_row_number_1_2_3_4"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number_1_2_3_4", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression("IF(input_1_row_number = combined_row_number_1_2_3_4, input_1_row_number, CAST(null AS bigint))"), (Object)"marker_2", (Object)PlanMatchPattern.expression("IF(input_2_row_number = combined_row_number_1_2_3_4, input_2_row_number, CAST(null AS bigint))"), (Object)"marker_3", (Object)PlanMatchPattern.expression("IF(input_3_row_number = combined_row_number_1_2_3_4, input_3_row_number, CAST(null AS bigint))"), (Object)"marker_4", (Object)PlanMatchPattern.expression("IF(input_4_row_number = combined_row_number_1_2_3_4, input_4_row_number, CAST(null AS bigint))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_1_2_3_4", (Object)PlanMatchPattern.expression("IF(COALESCE(combined_row_number_1_2, BIGINT '-1') > COALESCE(combined_row_number_3_4, BIGINT '-1'), combined_row_number_1_2, combined_row_number_3_4)"), (Object)"combined_partition_size_1_2_3_4", (Object)PlanMatchPattern.expression("IF(COALESCE(combined_partition_size_1_2, BIGINT '-1') > COALESCE(combined_partition_size_3_4, BIGINT '-1'), combined_partition_size_1_2, combined_partition_size_3_4)")), PlanMatchPattern.join(JoinType.LEFT, joinBuilder -> joinBuilder.filter("combined_row_number_1_2 = combined_row_number_3_4 OR\ncombined_row_number_1_2 > combined_partition_size_3_4 AND combined_row_number_3_4 = BIGINT '1' OR\ncombined_row_number_3_4 > combined_partition_size_1_2 AND combined_row_number_1_2 = BIGINT '1'\n").left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_1_2", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_row_number, BIGINT '-1') > COALESCE(input_2_row_number, BIGINT '-1'), input_1_row_number, input_2_row_number)"), (Object)"combined_partition_size_1_2", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_partition_size, BIGINT '-1') > COALESCE(input_2_partition_size, BIGINT '-1'), input_1_partition_size, input_2_partition_size)"), (Object)"combined_partition_column_1_2", (Object)PlanMatchPattern.expression("COALESCE(c, d)")), PlanMatchPattern.join(JoinType.INNER, nestedJoinBuilder -> nestedJoinBuilder.filter("NOT (c IS DISTINCT FROM d)\nAND (\n     input_1_row_number = input_2_row_number OR\n     input_1_row_number > input_2_partition_size AND input_2_row_number = BIGINT '1' OR\n     input_2_row_number > input_1_partition_size AND input_1_row_number = BIGINT '1')\n").left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_1_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("c"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_2_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("d")))))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_3_4", (Object)PlanMatchPattern.expression("IF(COALESCE(input_3_row_number, BIGINT '-1') > COALESCE(input_4_row_number, BIGINT '-1'), input_3_row_number, input_4_row_number)"), (Object)"combined_partition_size_3_4", (Object)PlanMatchPattern.expression("IF(COALESCE(input_3_partition_size, BIGINT '-1') > COALESCE(input_4_partition_size, BIGINT '-1'), input_3_partition_size, input_4_partition_size)"), (Object)"combined_partition_column_3_4", (Object)PlanMatchPattern.expression("COALESCE(e, f)")), PlanMatchPattern.join(JoinType.FULL, nestedJoinBuilder -> nestedJoinBuilder.filter("NOT (e IS DISTINCT FROM f)\nAND (\n     input_3_row_number = input_4_row_number OR\n     input_3_row_number > input_4_partition_size AND input_4_row_number = BIGINT '1' OR\n     input_4_row_number > input_3_partition_size AND input_3_row_number = BIGINT '1')\n").left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"e"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_3_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_3_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("e"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"f"), (List<String>)ImmutableList.of((Object)"g"), (Map<String, SortOrder>)ImmutableMap.of((Object)"g", (Object)SortOrder.DESC_NULLS_FIRST))).addFunction("input_4_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_4_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("f", "g")))))))))));
    }

    @Test
    public void testCoPartitionedAndNotCoPartitionedSources() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c), (Object)p.values(d), (Object)p.values(e)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)d), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_3", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, true))), (List)ImmutableList.of((Object)e), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)e), Optional.empty())))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_2", (Object)"input_3")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"e"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"e"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_2", (Object)"e", (Object)"marker_3")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column_2_3", (Object)"c"), (List<String>)ImmutableList.of((Object)"combined_row_number_2_3_1"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number_2_3_1", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression("IF(input_1_row_number = combined_row_number_2_3_1, input_1_row_number, CAST(null AS bigint))"), (Object)"marker_2", (Object)PlanMatchPattern.expression("IF(input_2_row_number = combined_row_number_2_3_1, input_2_row_number, CAST(null AS bigint))"), (Object)"marker_3", (Object)PlanMatchPattern.expression("IF(input_3_row_number = combined_row_number_2_3_1, input_3_row_number, CAST(null AS bigint))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_2_3_1", (Object)PlanMatchPattern.expression("IF(COALESCE(combined_row_number_2_3, BIGINT '-1') > COALESCE(input_1_row_number, BIGINT '-1'), combined_row_number_2_3, input_1_row_number)"), (Object)"combined_partition_size_2_3_1", (Object)PlanMatchPattern.expression("IF(COALESCE(combined_partition_size_2_3, BIGINT '-1') > COALESCE(input_1_partition_size, BIGINT '-1'), combined_partition_size_2_3, input_1_partition_size)")), PlanMatchPattern.join(JoinType.INNER, joinBuilder -> joinBuilder.filter("combined_row_number_2_3 = input_1_row_number OR\ncombined_row_number_2_3 > input_1_partition_size AND input_1_row_number = BIGINT '1' OR\ninput_1_row_number > combined_partition_size_2_3 AND combined_row_number_2_3 = BIGINT '1'\n").left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number_2_3", (Object)PlanMatchPattern.expression("IF(COALESCE(input_2_row_number, BIGINT '-1') > COALESCE(input_3_row_number, BIGINT '-1'), input_2_row_number, input_3_row_number)"), (Object)"combined_partition_size_2_3", (Object)PlanMatchPattern.expression("IF(COALESCE(input_2_partition_size, BIGINT '-1') > COALESCE(input_3_partition_size, BIGINT '-1'), input_2_partition_size, input_3_partition_size)"), (Object)"combined_partition_column_2_3", (Object)PlanMatchPattern.expression("COALESCE(d, e)")), PlanMatchPattern.join(JoinType.LEFT, nestedJoinBuilder -> nestedJoinBuilder.filter("NOT (d IS DISTINCT FROM e)\nAND (\n     input_2_row_number = input_3_row_number OR\n     input_2_row_number > input_3_partition_size AND input_3_row_number = BIGINT '1' OR\n     input_3_row_number > input_2_partition_size AND input_2_row_number = BIGINT '1')\n").left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_2_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("d"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"e"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_3_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_3_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("e")))))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_1_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("c"))))))));
    }

    @Test
    public void testCoerceForCopartitioning() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c", (Type)TinyintType.TINYINT);
            Symbol cCoerced = p.symbol("c_coerced", (Type)IntegerType.INTEGER);
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e", (Type)IntegerType.INTEGER);
            Symbol f = p.symbol("f");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.project(Assignments.builder().put(c, PlanBuilder.expression("c")).put(d, PlanBuilder.expression("d")).put(cCoerced, PlanBuilder.expression("CAST(c AS INTEGER)")).build(), (PlanNode)p.values(c, d)), (Object)p.values(e, f)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)c, (Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)cCoerced), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, false, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, true), (Object)new TableFunctionNode.PassThroughColumn(f, false))), (List)ImmutableList.of((Object)f), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)e), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)f), (Map)ImmutableMap.of((Object)f, (Object)SortOrder.DESC_NULLS_FIRST))))))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"e", (Object)"f"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)ImmutableList.of((Object)"f"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"c_coerced", (Object)"marker_1", (Object)"d", (Object)"marker_1", (Object)"e", (Object)"marker_2", (Object)"f", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression("IF(input_1_row_number = combined_row_number, input_1_row_number, CAST(null AS bigint))"), (Object)"marker_2", (Object)PlanMatchPattern.expression("IF(input_2_row_number = combined_row_number, input_2_row_number, CAST(null AS bigint))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_row_number, BIGINT '-1') > COALESCE(input_2_row_number, BIGINT '-1'), input_1_row_number, input_2_row_number)"), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_partition_size, BIGINT '-1') > COALESCE(input_2_partition_size, BIGINT '-1'), input_1_partition_size, input_2_partition_size)"), (Object)"combined_partition_column", (Object)PlanMatchPattern.expression("COALESCE(c_coerced, e)")), PlanMatchPattern.join(JoinType.LEFT, joinBuilder -> joinBuilder.filter("NOT (c_coerced IS DISTINCT FROM e)\nAND (\n     input_1_row_number = input_2_row_number OR\n     input_1_row_number > input_2_partition_size AND input_2_row_number = BIGINT '1' OR\n     input_2_row_number > input_1_partition_size AND input_1_row_number = BIGINT '1')\n").left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c_coerced"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_1_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c_coerced", (Object)PlanMatchPattern.expression("CAST(c AS INTEGER)")), PlanMatchPattern.values("c", "d")))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"e"), (List<String>)ImmutableList.of((Object)"f"), (Map<String, SortOrder>)ImmutableMap.of((Object)"f", (Object)SortOrder.DESC_NULLS_FIRST))).addFunction("input_2_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_2_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("e", "f"))))))));
    }

    @Test
    public void testTwoCoPartitioningColumns() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d), (Object)p.values(e, f)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, true, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true), (Object)new TableFunctionNode.PassThroughColumn(d, true))), (List)ImmutableList.of((Object)c), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c, (Object)d), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", false, false, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, true), (Object)new TableFunctionNode.PassThroughColumn(f, true))), (List)ImmutableList.of((Object)e), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)e, (Object)f), Optional.empty())))), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"input_1", (Object)"input_2")));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)ImmutableList.of((Object)"e", (Object)"f"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"e"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_1", (Object)"e", (Object)"marker_2", (Object)"f", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"combined_partition_column_1", (Object)"combined_partition_column_2"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression("IF(input_1_row_number = combined_row_number, input_1_row_number, CAST(null AS bigint))"), (Object)"marker_2", (Object)PlanMatchPattern.expression("IF(input_2_row_number = combined_row_number, input_2_row_number, CAST(null AS bigint))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_row_number, BIGINT '-1') > COALESCE(input_2_row_number, BIGINT '-1'), input_1_row_number, input_2_row_number)"), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_partition_size, BIGINT '-1') > COALESCE(input_2_partition_size, BIGINT '-1'), input_1_partition_size, input_2_partition_size)"), (Object)"combined_partition_column_1", (Object)PlanMatchPattern.expression("COALESCE(c, e)"), (Object)"combined_partition_column_2", (Object)PlanMatchPattern.expression("COALESCE(d, f)")), PlanMatchPattern.join(JoinType.LEFT, joinBuilder -> joinBuilder.filter("NOT (c IS DISTINCT FROM e)\nAND NOT (d IS DISTINCT FROM f)\nAND (\n     input_1_row_number = input_2_row_number OR\n     input_1_row_number > input_2_partition_size AND input_2_row_number = BIGINT '1' OR\n     input_2_row_number > input_1_partition_size AND input_1_row_number = BIGINT '1')\n").left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c", (Object)"d"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_1_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("c", "d"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"e", (Object)"f"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_2_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("e", "f"))))))));
    }

    @Test
    public void testTwoSourcesWithRowAndSetSemantics() {
        this.tester().assertThat((Rule<?>)new ImplementTableFunctionSource(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            return p.tableFunction("test_function", (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<PlanNode>)ImmutableList.of((Object)p.values(c, d), (Object)p.values(e, f)), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("input_1", false, false, new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), (List)ImmutableList.of((Object)d), Optional.of(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.empty()))), (Object)new TableFunctionNode.TableArgumentProperties("input_2", true, false, new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, false), (Object)new TableFunctionNode.PassThroughColumn(f, false))), (List)ImmutableList.of((Object)e), Optional.empty())), (List<List<String>>)ImmutableList.of());
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"a", (Object)"b")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"e", (Object)"f"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"e"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"c", (Object)"marker_1", (Object)"d", (Object)"marker_1", (Object)"e", (Object)"marker_2", (Object)"f", (Object)"marker_2")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of((Object)"combined_row_number"), (Map<String, SortOrder>)ImmutableMap.of((Object)"combined_row_number", (Object)SortOrder.ASC_NULLS_LAST))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"marker_1", (Object)PlanMatchPattern.expression("IF(input_1_row_number = combined_row_number, input_1_row_number, CAST(null AS bigint))"), (Object)"marker_2", (Object)PlanMatchPattern.expression("IF(input_2_row_number = combined_row_number, input_2_row_number, CAST(null AS bigint))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"combined_row_number", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_row_number, BIGINT '-1') > COALESCE(input_2_row_number, BIGINT '-1'), input_1_row_number, input_2_row_number)"), (Object)"combined_partition_size", (Object)PlanMatchPattern.expression("IF(COALESCE(input_1_partition_size, BIGINT '-1') > COALESCE(input_2_partition_size, BIGINT '-1'), input_1_partition_size, input_2_partition_size)")), PlanMatchPattern.join(JoinType.FULL, joinBuilder -> joinBuilder.filter("input_1_row_number = input_2_row_number OR\ninput_1_row_number > input_2_partition_size AND input_2_row_number = BIGINT '1' OR\ninput_2_row_number > input_1_partition_size AND input_1_row_number = BIGINT '1'\n").left(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_1_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_1_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("c", "d"))).right(PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("input_2_row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).addFunction("input_2_partition_size", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.values("e", "f"))))))));
    }
}

