/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SetExpressionMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneApplySourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneApplySourceColumns
extends BaseRuleTest {
    public TestPruneApplySourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllSubquerySymbolsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneApplySourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol subquerySymbol1 = p.symbol("subquery_symbol_1");
            Symbol subquerySymbol2 = p.symbol("subquery_symbol_2");
            Symbol inResult = p.symbol("in_result");
            return p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)inResult, (Object)new ApplyNode.In(a, subquerySymbol1)), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(a), (PlanNode)p.values(subquerySymbol1, subquerySymbol2));
        }).matches(PlanMatchPattern.apply((List<String>)ImmutableList.of(), (Map<String, SetExpressionMatcher>)ImmutableMap.of((Object)"in_result", (Object)PlanMatchPattern.setExpression((ApplyNode.SetExpression)new ApplyNode.In(new Symbol("a"), new Symbol("subquery_symbol_1")))), PlanMatchPattern.values("a"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"subquery_symbol_1", (Object)PlanMatchPattern.expression("subquery_symbol_1")), PlanMatchPattern.values("subquery_symbol_1", "subquery_symbol_2"))));
    }

    @Test
    public void testAllSubquerySymbolsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneApplySourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol subquerySymbol1 = p.symbol("subquery_symbol_1");
            Symbol subquerySymbol2 = p.symbol("subquery_symbol_2");
            Symbol inResult1 = p.symbol("in_result_1");
            Symbol inResult2 = p.symbol("in_result_2");
            return p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)inResult1, (Object)new ApplyNode.In(a, subquerySymbol1), (Object)inResult2, (Object)new ApplyNode.In(a, subquerySymbol2)), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(a), (PlanNode)p.values(subquerySymbol1, subquerySymbol2));
        }).doesNotFire();
    }

    @Test
    public void testNoSubquerySymbolsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneApplySourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult = p.symbol("in_result");
            return p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)inResult, (Object)new ApplyNode.In(a, a)), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(a), (PlanNode)p.values(subquerySymbol));
        }).matches(PlanMatchPattern.apply((List<String>)ImmutableList.of(), (Map<String, SetExpressionMatcher>)ImmutableMap.of((Object)"in_result", (Object)PlanMatchPattern.setExpression((ApplyNode.SetExpression)new ApplyNode.In(new Symbol("a"), new Symbol("a")))), PlanMatchPattern.values("a"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values("subquery_symbol"))));
    }
}

