/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneCorrelatedJoinColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneCorrelatedJoinColumns
extends BaseRuleTest {
    public TestPruneCorrelatedJoinColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testRemoveUnusedCorrelatedJoinNode() {
        this.tester().assertThat((Rule<?>)new PruneCorrelatedJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol correlationSymbol = p.symbol("correlation_symbol");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)correlationSymbol), (PlanNode)p.values(a, correlationSymbol), (PlanNode)p.values(1, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.values("a", "correlationSymbol")));
        this.tester().assertThat((Rule<?>)new PruneCorrelatedJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol correlationSymbol = p.symbol("correlation_symbol");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)correlationSymbol), (PlanNode)p.values(a, correlationSymbol), JoinType.LEFT, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)correlationSymbol.toSymbolReference()), (PlanNode)p.values(1, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.values("a", "correlationSymbol")));
        this.tester().assertThat((Rule<?>)new PruneCorrelatedJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{b}), (PlanNode)p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(1, a), (PlanNode)p.values(b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("b")));
        this.tester().assertThat((Rule<?>)new PruneCorrelatedJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{b}), (PlanNode)p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(1, a), JoinType.RIGHT, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("b")));
    }

    @Test
    public void testPruneUnreferencedSubquerySymbol() {
        this.tester().assertThat((Rule<?>)new PruneCorrelatedJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol correlationSymbol = p.symbol("correlation_symbol");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)correlationSymbol), (PlanNode)p.values(a, correlationSymbol), JoinType.LEFT, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)correlationSymbol.toSymbolReference()), (PlanNode)p.values(5, b, c))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"correlation_symbol"), PlanMatchPattern.values("a", "correlation_symbol"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.values("b", "c"))))));
    }

    @Test
    public void testPruneUnreferencedInputSymbol() {
        this.tester().assertThat((Rule<?>)new PruneCorrelatedJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol correlationSymbol = p.symbol("correlation_symbol");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{b}), (PlanNode)p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)correlationSymbol), (PlanNode)p.values(a, correlationSymbol), JoinType.LEFT, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)correlationSymbol.toSymbolReference()), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)b.toSymbolReference(), (Expression)correlationSymbol.toSymbolReference()), (PlanNode)p.values(b))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"correlation_symbol"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"correlation_symbol", (Object)PlanMatchPattern.expression("correlation_symbol")), PlanMatchPattern.values("a", "correlation_symbol")), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.values("b")))));
    }

    @Test
    public void testDoNotPruneUnreferencedCorrelationSymbol() {
        this.tester().assertThat((Rule<?>)new PruneCorrelatedJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol correlationSymbol = p.symbol("correlation_symbol");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, b}), (PlanNode)p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)correlationSymbol), (PlanNode)p.values(a, correlationSymbol), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.values(b)));
        }).doesNotFire();
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneCorrelatedJoinColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol correlationSymbol = p.symbol("correlation_symbol");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{a, b}), (PlanNode)p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)correlationSymbol), (PlanNode)p.values(a, correlationSymbol), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)b.toSymbolReference(), (Expression)correlationSymbol.toSymbolReference()), (PlanNode)p.values(b))));
        }).doesNotFire();
    }
}

