/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.plugin.tpch.TpchTransactionHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneCountAggregationOverScalar;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.TestingHandles;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneCountAggregationOverScalar
extends BaseRuleTest {
    public TestPruneCountAggregationOverScalar() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnNonNestedAggregate() {
        this.tester().assertThat((Rule<?>)new PruneCountAggregationOverScalar(this.tester().getMetadata())).on(p -> p.aggregation(a -> a.globalGrouping().addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).source((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of())))).doesNotFire();
    }

    @Test
    public void testFiresOnNestedCountAggregate() {
        this.tester().assertThat((Rule<?>)new PruneCountAggregationOverScalar(this.tester().getMetadata())).on(p -> p.aggregation(a -> a.addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).globalGrouping().step(AggregationNode.Step.SINGLE).source((PlanNode)p.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of())).globalGrouping().step(AggregationNode.Step.SINGLE))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"count_1", (Object)0)));
    }

    @Test
    public void testFiresOnCountAggregateOverValues() {
        this.tester().assertThat((Rule<?>)new PruneCountAggregationOverScalar(this.tester().getMetadata())).on(p -> p.aggregation(a -> a.addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).step(AggregationNode.Step.SINGLE).globalGrouping().source((PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("orderkey")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("1")))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"count_1", (Object)0)));
    }

    @Test
    public void testFiresOnCountAggregateOverEnforceSingleRow() {
        this.tester().assertThat((Rule<?>)new PruneCountAggregationOverScalar(this.tester().getMetadata())).on(p -> p.aggregation(a -> a.addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).step(AggregationNode.Step.SINGLE).globalGrouping().source((PlanNode)p.enforceSingleRow((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"count_1", (Object)0)));
    }

    @Test
    public void testDoesNotFireOnNestedCountAggregateWithNonEmptyGroupBy() {
        this.tester().assertThat((Rule<?>)new PruneCountAggregationOverScalar(this.tester().getMetadata())).on(p -> p.aggregation(a -> a.addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).step(AggregationNode.Step.SINGLE).globalGrouping().source((PlanNode)p.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of())).groupingSets(AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)p.symbol("orderkey")))))))).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnNestedNonCountAggregate() {
        this.tester().assertThat((Rule<?>)new PruneCountAggregationOverScalar(this.tester().getMetadata())).on(p -> {
            Symbol totalPrice = p.symbol("total_price", (Type)DoubleType.DOUBLE);
            AggregationNode inner = p.aggregation(a -> a.addAggregation(totalPrice, PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("totalprice"))), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE)).globalGrouping().source((PlanNode)p.project(Assignments.of((Symbol)totalPrice, (Expression)totalPrice.toSymbolReference()), (PlanNode)p.tableScan(new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new TpchTableHandle("tiny", "orders", 0.01), (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE), (List<Symbol>)ImmutableList.of((Object)totalPrice), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)totalPrice, (Object)new TpchColumnHandle(totalPrice.getName(), (Type)DoubleType.DOUBLE))))));
            return p.aggregation(a -> a.addAggregation(p.symbol("sum_outer", (Type)DoubleType.DOUBLE), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("sum_inner"))), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE)).globalGrouping().source((PlanNode)inner));
        }).doesNotFire();
    }
}

