/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneTopNColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;

public class TestPruneTopNColumns
extends BaseRuleTest {
    private static final long COUNT = 10L;

    public TestPruneTopNColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTopNColumns()).on(p -> this.buildProjectedTopN((PlanBuilder)p, symbol -> symbol.getName().equals("b"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.topN(10L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("b", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTopNColumns()).on(p -> this.buildProjectedTopN((PlanBuilder)p, symbol -> symbol.getName().equals("a"))).doesNotFire();
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTopNColumns()).on(p -> this.buildProjectedTopN((PlanBuilder)p, (Predicate<Symbol>)Predicates.alwaysTrue())).doesNotFire();
    }

    private ProjectNode buildProjectedTopN(PlanBuilder planBuilder, Predicate<Symbol> projectionTopN) {
        Symbol a = planBuilder.symbol("a");
        Symbol b = planBuilder.symbol("b");
        return planBuilder.project(Assignments.identity((Iterable)((Iterable)ImmutableList.of((Object)a, (Object)b).stream().filter(projectionTopN).collect(ImmutableSet.toImmutableSet()))), (PlanNode)planBuilder.topN(10L, (List<Symbol>)ImmutableList.of((Object)b), (PlanNode)planBuilder.values(a, b)));
    }
}

