/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneUnnestColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.UnnestNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPruneUnnestColumns
extends BaseRuleTest {
    public TestPruneUnnestColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneOrdinalitySymbol() {
        this.tester().assertThat((Rule<?>)new PruneUnnestColumns()).on(p -> {
            Symbol replicateSymbol = p.symbol("replicate_symbol");
            Symbol unnestSymbol = p.symbol("unnest_symbol");
            Symbol unnestedSymbol = p.symbol("unnested_symbol");
            Symbol ordinalitySymbol = p.symbol("ordinality_symbol");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{replicateSymbol, unnestedSymbol}), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of((Object)replicateSymbol), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(unnestSymbol, (List)ImmutableList.of((Object)unnestedSymbol))), Optional.of(ordinalitySymbol), JoinType.INNER, (PlanNode)p.values(replicateSymbol, unnestSymbol)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"replicate_symbol", (Object)PlanMatchPattern.expression("replicate_symbol"), (Object)"unnested_symbol", (Object)PlanMatchPattern.expression("unnested_symbol")), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"replicate_symbol"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("unnest_symbol", (List<String>)ImmutableList.of((Object)"unnested_symbol"))), Optional.empty(), JoinType.INNER, PlanMatchPattern.values("replicate_symbol", "unnest_symbol"))));
    }

    @Test
    public void testPruneReplicateSymbol() {
        this.tester().assertThat((Rule<?>)new PruneUnnestColumns()).on(p -> {
            Symbol replicateSymbol = p.symbol("replicate_symbol");
            Symbol unnestSymbol = p.symbol("unnest_symbol");
            Symbol unnestedSymbol = p.symbol("unnested_symbol");
            Symbol ordinalitySymbol = p.symbol("ordinality_symbol");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{unnestedSymbol, ordinalitySymbol}), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of((Object)replicateSymbol), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(unnestSymbol, (List)ImmutableList.of((Object)unnestedSymbol))), Optional.of(ordinalitySymbol), JoinType.INNER, (PlanNode)p.values(replicateSymbol, unnestSymbol)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"unnested_symbol", (Object)PlanMatchPattern.expression("unnested_symbol"), (Object)"ordinality_symbol", (Object)PlanMatchPattern.expression("ordinality_symbol")), PlanMatchPattern.unnest((List<String>)ImmutableList.of(), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("unnest_symbol", (List<String>)ImmutableList.of((Object)"unnested_symbol"))), Optional.of("ordinality_symbol"), JoinType.INNER, PlanMatchPattern.values("replicate_symbol", "unnest_symbol"))));
    }

    @Test
    public void testDoNotPruneUnnestedSymbol() {
        this.tester().assertThat((Rule<?>)new PruneUnnestColumns()).on(p -> {
            Symbol replicateSymbol = p.symbol("replicate_symbol");
            Symbol unnestSymbol = p.symbol("unnest_symbol");
            Symbol unnestedSymbol = p.symbol("unnested_symbol");
            Symbol ordinalitySymbol = p.symbol("ordinality_symbol");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{replicateSymbol, ordinalitySymbol}), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of((Object)replicateSymbol), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(unnestSymbol, (List)ImmutableList.of((Object)unnestedSymbol))), Optional.of(ordinalitySymbol), JoinType.INNER, (PlanNode)p.values(replicateSymbol, unnestSymbol)));
        }).doesNotFire();
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneUnnestColumns()).on(p -> {
            Symbol replicateSymbol = p.symbol("replicate_symbol");
            Symbol unnestSymbol = p.symbol("unnest_symbol");
            Symbol unnestedSymbol = p.symbol("unnested_symbol");
            Symbol ordinalitySymbol = p.symbol("ordinality_symbol");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{replicateSymbol, unnestedSymbol, ordinalitySymbol}), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of((Object)replicateSymbol), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(unnestSymbol, (List)ImmutableList.of((Object)unnestedSymbol))), Optional.of(ordinalitySymbol), JoinType.INNER, (PlanNode)p.values(replicateSymbol, unnestSymbol)));
        }).doesNotFire();
    }
}

