/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushDownProjectionsFromPatternRecognition;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.rowpattern.AggregatedSetDescriptor;
import io.trino.sql.planner.rowpattern.AggregationValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestPushDownProjectionsFromPatternRecognition
extends BaseRuleTest {
    private static final QualifiedName MAX_BY = MetadataManager.createTestMetadataManager().resolveBuiltinFunction("max_by", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})).toQualifiedName();

    public TestPushDownProjectionsFromPatternRecognition() {
        super(new Plugin[0]);
    }

    @Test
    public void testNoAggregations() {
        this.tester().assertThat((Rule<?>)new PushDownProjectionsFromPatternRecognition()).on(p -> p.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), PlanBuilder.expression("true")).source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDoNotPushRuntimeEvaluatedArguments() {
        this.tester().assertThat((Rule<?>)new PushDownProjectionsFromPatternRecognition()).on(p -> p.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(MAX_BY, (List)ImmutableList.of((Object)PlanBuilder.expression("1 + MATCH_NUMBER()"), (Object)PlanBuilder.expression("'x' || CLASSIFIER()"))), PlanBuilder.expression("5"))).source((PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDoNotPushSymbolReferences() {
        this.tester().assertThat((Rule<?>)new PushDownProjectionsFromPatternRecognition()).on(p -> p.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(MAX_BY, (List)ImmutableList.of((Object)PlanBuilder.expression("a"), (Object)PlanBuilder.expression("b"))), PlanBuilder.expression("5"))).source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testPreProjectArguments() {
        ResolvedFunction maxBy = this.tester().getMetadata().resolveBuiltinFunction("max_by", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}));
        this.tester().assertThat((Rule<?>)new PushDownProjectionsFromPatternRecognition()).on(p -> p.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), PlanBuilder.expression("agg < 5"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"agg", (Object)new AggregationValuePointer(maxBy, new AggregatedSetDescriptor((Set)ImmutableSet.of(), true), (List)ImmutableList.of((Object)PlanBuilder.expression("a + 1"), (Object)PlanBuilder.expression("b * 2")), Optional.empty(), Optional.empty()))).source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).matches(PlanMatchPattern.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), PlanBuilder.expression("agg < 5"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"agg", (Object)new AggregationValuePointer(maxBy, new AggregatedSetDescriptor((Set)ImmutableSet.of(), true), (List)ImmutableList.of((Object)PlanBuilder.expression("expr_1"), (Object)PlanBuilder.expression("expr_2")), Optional.empty(), Optional.empty()))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_1", (Object)PlanMatchPattern.expression("a + 1"), (Object)"expr_2", (Object)PlanMatchPattern.expression("b * 2"), (Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("a", "b"))));
    }
}

