/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushFilterThroughCountAggregation;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPushFilterThroughCountAggregation
extends BaseRuleTest {
    public TestPushFilterThroughCountAggregation() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireWithNonGroupedAggregation() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            Symbol count = p.symbol("count");
            return p.filter(PlanBuilder.expression("count > 0"), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(count, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of(), mask).source((PlanNode)p.values(g, mask))));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireWithMultipleAggregations() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            Symbol count = p.symbol("count");
            Symbol avg = p.symbol("avg");
            return p.filter(PlanBuilder.expression("count > 0"), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(count, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of(), mask).addAggregation(avg, PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new SymbolReference("g"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), mask).source((PlanNode)p.values(g, mask))));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireWithNoAggregations() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            return p.filter(PlanBuilder.expression("true"), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).source((PlanNode)p.values(g, mask))));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireWithNoMask() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol count = p.symbol("count");
            return p.filter(PlanBuilder.expression("count > 0"), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(count, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).source((PlanNode)p.values(g))));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireWithNoCountAggregation() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            Symbol count = p.symbol("count");
            return p.filter(PlanBuilder.expression("count > 0"), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(count, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new SymbolReference("g"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), mask).source((PlanNode)p.values(g, mask))));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            Symbol avg = p.symbol("avg");
            return p.filter(PlanBuilder.expression("avg > 0"), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(avg, PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new SymbolReference("g"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), mask).source((PlanNode)p.values(g, mask))));
        }).doesNotFire();
    }

    @Test
    public void testFilterPredicateFalse() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            Symbol count = p.symbol("count");
            return p.filter(PlanBuilder.expression("count < BIGINT '0' AND count > BIGINT '0'"), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(count, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of(), mask).source((PlanNode)p.values(g, mask))));
        }).matches(PlanMatchPattern.values("g", "count"));
    }

    @Test
    public void testDoesNotFireWhenFilterPredicateTrue() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            Symbol count = p.symbol("count");
            return p.filter(PlanBuilder.expression("true"), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(count, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of(), mask).source((PlanNode)p.values(g, mask))));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenFilterPredicateSatisfiedByAllCountValues() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            Symbol count = p.symbol("count");
            return p.filter(PlanBuilder.expression("(count < BIGINT '0' OR count >= BIGINT '0') AND g = BIGINT '5'"), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(count, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of(), mask).source((PlanNode)p.values(g, mask))));
        }).doesNotFire();
    }

    @Test
    public void testPushDownMaskAndRemoveFilter() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            Symbol count = p.symbol("count");
            return p.filter(PlanBuilder.expression("count > BIGINT '0'"), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(count, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of(), mask).source((PlanNode)p.values(g, mask))));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), PlanMatchPattern.filter("mask", PlanMatchPattern.values("g", "mask"))));
    }

    @Test
    public void testPushDownMaskAndSimplifyFilter() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            Symbol count = p.symbol("count");
            return p.filter(PlanBuilder.expression("count > BIGINT '0' AND g > BIGINT '5'"), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(count, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of(), mask).source((PlanNode)p.values(g, mask))));
        }).matches(PlanMatchPattern.filter("g > BIGINT '5'", PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), PlanMatchPattern.filter("mask", PlanMatchPattern.values("g", "mask")))));
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            Symbol count = p.symbol("count");
            return p.filter(PlanBuilder.expression("count > BIGINT '0' AND count % 2 = BIGINT '0'"), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(count, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of(), mask).source((PlanNode)p.values(g, mask))));
        }).matches(PlanMatchPattern.filter("count % 2 = BIGINT '0'", PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), PlanMatchPattern.filter("mask", PlanMatchPattern.values("g", "mask")))));
    }

    @Test
    public void testPushDownMaskAndRetainFilter() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithoutProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            Symbol count = p.symbol("count");
            return p.filter(PlanBuilder.expression("count > BIGINT '5'"), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(count, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of(), mask).source((PlanNode)p.values(g, mask))));
        }).matches(PlanMatchPattern.filter("count > BIGINT '5'", PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), PlanMatchPattern.filter("mask", PlanMatchPattern.values("g", "mask")))));
    }

    @Test
    public void testWithProject() {
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            Symbol count = p.symbol("count");
            return p.filter(PlanBuilder.expression("count > BIGINT '0'"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{count}), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(count, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of(), mask).source((PlanNode)p.values(g, mask)))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"count", (Object)PlanMatchPattern.expression("count")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), PlanMatchPattern.filter("mask", PlanMatchPattern.values("g", "mask")))));
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            Symbol count = p.symbol("count");
            return p.filter(PlanBuilder.expression("count > BIGINT '0' AND g > BIGINT '5'"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{count, g}), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(count, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of(), mask).source((PlanNode)p.values(g, mask)))));
        }).matches(PlanMatchPattern.filter("g > BIGINT '5'", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"count", (Object)PlanMatchPattern.expression("count"), (Object)"g", (Object)PlanMatchPattern.expression("g")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), PlanMatchPattern.filter("mask", PlanMatchPattern.values("g", "mask"))))));
        this.tester().assertThat((Rule<?>)new PushFilterThroughCountAggregation.PushFilterThroughCountAggregationWithProject(this.tester().getPlannerContext())).on(p -> {
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask");
            Symbol count = p.symbol("count");
            return p.filter(PlanBuilder.expression("count > BIGINT '5'"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{count}), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(count, PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of(), mask).source((PlanNode)p.values(g, mask)))));
        }).matches(PlanMatchPattern.filter("count > BIGINT '5'", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"count", (Object)PlanMatchPattern.expression("count")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), PlanMatchPattern.filter("mask", PlanMatchPattern.values("g", "mask"))))));
    }
}

