/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.expression.Constant;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushMergeWriterUpdateIntoConnector;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableUpdateNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.StringLiteral;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushMergeWriterUpdateIntoConnector {
    private static final String TEST_SCHEMA = "test_schema";
    private static final String TEST_TABLE = "test_table";
    private static final SchemaTableName SCHEMA_TABLE_NAME = new SchemaTableName("test_schema", "test_table");

    @Test
    public void testPushUpdateIntoConnector() {
        ImmutableList columnNames = ImmutableList.of((Object)"column_1", (Object)"column_2");
        MockConnectorFactory factory = MockConnectorFactory.builder().build();
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(factory).build();){
            ruleTester.assertThat((Rule<?>)TestPushMergeWriterUpdateIntoConnector.createRule(ruleTester)).on(arg_0 -> TestPushMergeWriterUpdateIntoConnector.lambda$testPushUpdateIntoConnector$1(ruleTester, (List)columnNames, arg_0)).matches(PlanMatchPattern.node(TableUpdateNode.class, new PlanMatchPattern[0]));
        }
    }

    @Test
    public void testPushUpdateIntoConnectorArithmeticExpression() {
        ImmutableList columnNames = ImmutableList.of((Object)"column_1", (Object)"column_2");
        MockConnectorFactory factory = MockConnectorFactory.builder().build();
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(factory).build();){
            ruleTester.assertThat((Rule<?>)TestPushMergeWriterUpdateIntoConnector.createRule(ruleTester)).on(arg_0 -> TestPushMergeWriterUpdateIntoConnector.lambda$testPushUpdateIntoConnectorArithmeticExpression$3(ruleTester, (List)columnNames, arg_0)).doesNotFire();
        }
    }

    @Test
    public void testPushUpdateIntoConnectorUpdateAll() {
        ImmutableList columnNames = ImmutableList.of((Object)"column_1", (Object)"column_2");
        MockConnectorFactory factory = MockConnectorFactory.builder().build();
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(factory).build();){
            ruleTester.assertThat((Rule<?>)TestPushMergeWriterUpdateIntoConnector.createRule(ruleTester)).on(arg_0 -> TestPushMergeWriterUpdateIntoConnector.lambda$testPushUpdateIntoConnectorUpdateAll$5(ruleTester, (List)columnNames, arg_0)).doesNotFire();
        }
    }

    private static PushMergeWriterUpdateIntoConnector createRule(RuleTester tester) {
        PlannerContext plannerContext = tester.getPlannerContext();
        IrTypeAnalyzer typeAnalyzer = tester.getTypeAnalyzer();
        return new PushMergeWriterUpdateIntoConnector(plannerContext, typeAnalyzer, (Metadata)new AbstractMockMetadata(){

            @Override
            public Optional<TableHandle> applyUpdate(Session session, TableHandle tableHandle, Map<ColumnHandle, Constant> assignments) {
                return Optional.of(tableHandle);
            }

            @Override
            public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
                return Map.of("column_1", new TestingColumnHandle("column_1"), "column_2", new TestingColumnHandle("column_2"));
            }
        });
    }

    private static /* synthetic */ PlanNode lambda$testPushUpdateIntoConnectorUpdateAll$5(RuleTester ruleTester, List columnNames, PlanBuilder p) {
        Symbol mergeRow = p.symbol("merge_row");
        Symbol rowId = p.symbol("row_id");
        Symbol rowCount = p.symbol("row_count");
        Row updateMergeRowExpression = new Row((List)ImmutableList.of((Object)new FunctionCall(ruleTester.getMetadata().resolveBuiltinFunction("from_base64", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})).toQualifiedName(), (List)ImmutableList.of((Object)new StringLiteral("")))));
        return p.tableFinish((PlanNode)p.merge((PlanNode)p.mergeProcessor(SCHEMA_TABLE_NAME, (PlanNode)p.project(new Assignments(Map.of(mergeRow, updateMergeRowExpression)), (PlanNode)p.tableScan(tableScanBuilder -> tableScanBuilder.setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of()).setSymbols((List<Symbol>)ImmutableList.of()).setTableHandle(ruleTester.getCurrentCatalogTableHandle(TEST_SCHEMA, TEST_TABLE)).build())), mergeRow, rowId, (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of()), p.mergeTarget(SCHEMA_TABLE_NAME, new TableWriterNode.MergeParadigmAndTypes(Optional.of(RowChangeParadigm.DELETE_ROW_AND_INSERT_ROW), (List)ImmutableList.of(), columnNames, (Type)IntegerType.INTEGER)), mergeRow, rowId, (List<Symbol>)ImmutableList.of()), (TableWriterNode.WriterTarget)p.mergeTarget(SCHEMA_TABLE_NAME), rowCount);
    }

    private static /* synthetic */ PlanNode lambda$testPushUpdateIntoConnectorArithmeticExpression$3(RuleTester ruleTester, List columnNames, PlanBuilder p) {
        Symbol mergeRow = p.symbol("merge_row");
        Symbol rowId = p.symbol("row_id");
        Symbol rowCount = p.symbol("row_count");
        Row updateMergeRowExpression = new Row((List)ImmutableList.of((Object)p.symbol("column_1").toSymbolReference(), (Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)p.symbol("col1").toSymbolReference(), (Expression)new LongLiteral("5"))));
        return p.tableFinish((PlanNode)p.merge((PlanNode)p.mergeProcessor(SCHEMA_TABLE_NAME, (PlanNode)p.project(new Assignments(Map.of(mergeRow, updateMergeRowExpression)), (PlanNode)p.tableScan(tableScanBuilder -> tableScanBuilder.setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of()).setSymbols((List<Symbol>)ImmutableList.of()).setTableHandle(ruleTester.getCurrentCatalogTableHandle(TEST_SCHEMA, TEST_TABLE)).build())), mergeRow, rowId, (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of()), p.mergeTarget(SCHEMA_TABLE_NAME, new TableWriterNode.MergeParadigmAndTypes(Optional.of(RowChangeParadigm.DELETE_ROW_AND_INSERT_ROW), (List)ImmutableList.of(), columnNames, (Type)IntegerType.INTEGER)), mergeRow, rowId, (List<Symbol>)ImmutableList.of()), (TableWriterNode.WriterTarget)p.mergeTarget(SCHEMA_TABLE_NAME), rowCount);
    }

    private static /* synthetic */ PlanNode lambda$testPushUpdateIntoConnector$1(RuleTester ruleTester, List columnNames, PlanBuilder p) {
        Symbol mergeRow = p.symbol("merge_row");
        Symbol rowId = p.symbol("row_id");
        Symbol rowCount = p.symbol("row_count");
        Row updateMergeRowExpression = new Row((List)ImmutableList.of((Object)p.symbol("column_1").toSymbolReference(), (Object)new LongLiteral("1"), (Object)new BooleanLiteral("true"), (Object)new LongLiteral("1"), (Object)new LongLiteral("1")));
        return p.tableFinish((PlanNode)p.merge((PlanNode)p.mergeProcessor(SCHEMA_TABLE_NAME, (PlanNode)p.project(new Assignments(Map.of(mergeRow, updateMergeRowExpression)), (PlanNode)p.tableScan(tableScanBuilder -> tableScanBuilder.setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of()).setSymbols((List<Symbol>)ImmutableList.of()).setTableHandle(ruleTester.getCurrentCatalogTableHandle(TEST_SCHEMA, TEST_TABLE)).build())), mergeRow, rowId, (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of()), p.mergeTarget(SCHEMA_TABLE_NAME, new TableWriterNode.MergeParadigmAndTypes(Optional.of(RowChangeParadigm.DELETE_ROW_AND_INSERT_ROW), (List)ImmutableList.of(), columnNames, (Type)IntegerType.INTEGER)), mergeRow, rowId, (List<Symbol>)ImmutableList.of()), (TableWriterNode.WriterTarget)p.mergeTarget(SCHEMA_TABLE_NAME), rowCount);
    }
}

