/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.SimplifyFilterPredicate;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.LongLiteral;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestSimplifyFilterPredicate
extends BaseRuleTest {
    public TestSimplifyFilterPredicate() {
        super(new Plugin[0]);
    }

    @Test
    public void testSimplifyIfExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("IF(a, true, false)"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("a", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("IF(a, true)"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("a", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("IF(a, false, true)"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("a IS NULL OR NOT a", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("IF(a, null, true)"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("a IS NULL OR NOT a", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("IF(a, true, true)"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("true", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("IF(a, false, false)"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("false", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("IF(a, b > 0, b > 0)"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter("b > 0", PlanMatchPattern.values("a", "b")));
        FunctionCall randomFunction = new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("random", (List)ImmutableList.of()).toQualifiedName(), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression(PlanBuilder.expression("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)randomFunction, (Expression)new LongLiteral("0")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)randomFunction, (Expression)new LongLiteral("0"))), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("IF(a, null)"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("false", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("IF(true, a, NOT a)"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("a", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("IF(false, a, NOT a)"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("NOT a", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("IF(false, a)"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("false", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("IF(a, true, b)"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).doesNotFire();
    }

    @Test
    public void testSimplifyNullIfExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("NULLIF(a, b)"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter("a AND (b IS NULL OR NOT b)", PlanMatchPattern.values("a", "b")));
    }

    @Test
    public void testSimplifySearchedCaseExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE           WHEN a < 0 THEN true           WHEN a = 0 THEN false           WHEN a > 0 THEN true           ELSE false        END"), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE            WHEN a < 0 THEN true            WHEN a = 0 THEN true            WHEN a > 0 THEN true            ELSE true         END"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("true", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE            WHEN a < 0 THEN false            WHEN a = 0 THEN null            WHEN a > 0 THEN false            ELSE false         END"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("false", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE            WHEN a < 0 THEN false            WHEN a = 0 THEN null            WHEN a > 0 THEN false         END"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("false", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE            WHEN a < 0 THEN false            WHEN a = 0 THEN null            WHEN a > 0 THEN true            ELSE false         END"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("((a < 0) IS NULL OR NOT (a < 0)) AND ((a = 0) IS NULL OR NOT (a = 0)) AND (a > 0)", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE            WHEN a < 0 THEN true            WHEN a = 0 THEN null            WHEN a > 0 THEN false            ELSE false         END"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("a < 0", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE            WHEN a < 0 THEN false            WHEN a = 0 THEN null            WHEN a > 0 THEN false            ELSE true         END"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("((a < 0) IS NULL OR NOT (a < 0)) AND ((a = 0) IS NULL OR NOT (a = 0)) AND ((a > 0) IS NULL OR NOT (a > 0))", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE            WHEN false THEN a            WHEN false THEN a            WHEN null THEN a            ELSE b         END"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter("b", PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE            WHEN false THEN a            WHEN false THEN NOT a            WHEN null THEN a         END"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("false", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE            WHEN false THEN a            WHEN null THEN NOT a            WHEN true THEN b         END"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter("b", PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE            WHEN false THEN a            WHEN b THEN NOT a            WHEN true THEN b         END"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter("CASE WHEN b THEN NOT a ELSE b END", PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE            WHEN b < 0 THEN a            WHEN b > 0 THEN NOT a            WHEN true THEN b            WHEN true THEN NOT b         END"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter("CASE            WHEN b < 0 THEN a            WHEN b > 0 THEN NOT a            ELSE b         END", PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE            WHEN b < 0 THEN a            WHEN b > 0 THEN NOT a            ELSE b         END"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).doesNotFire();
    }

    @Test
    public void testSimplifySimpleCaseExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE a           WHEN b THEN true            WHEN b + 1 THEN false            ELSE true         END"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE null           WHEN null THEN true            WHEN a THEN false            ELSE b         END"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter("b", PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE null           WHEN null THEN true            WHEN a THEN false         END"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("false", PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE a           WHEN b + 1 THEN true            WHEN b + 2 THEN true            ELSE true         END"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter("true", PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE a           WHEN b + 1 THEN false            WHEN b + 2 THEN null            ELSE false         END"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter("false", PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("CASE a           WHEN b + 1 THEN false            WHEN b + 2 THEN null         END"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter("false", PlanMatchPattern.values("a", "b")));
    }

    @Test
    public void testCastNull() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("IF(a, CAST(CAST(CAST(null AS boolean) AS bigint) AS boolean), false)"), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter("false", PlanMatchPattern.values("a")));
    }
}

