/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.GatherAndMergeWindows;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestSwapAdjacentWindowsBySpecifications
extends BaseRuleTest {
    private final ResolvedFunction resolvedFunction = new TestingFunctionResolution().resolveFunction("avg", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));

    public TestSwapAdjacentWindowsBySpecifications() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnPlanWithoutWindowFunctions() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void doesNotFireOnPlanWithSingleWindowNode() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)p.symbol("a")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)new WindowNode.Function(this.resolvedFunction, (List)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME, false)), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void subsetComesFirst() {
        String columnAAlias = "ALIAS_A";
        String columnBAlias = "ALIAS_B";
        ExpectedValueProvider<DataOrganizationSpecification> specificationA = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)columnAAlias), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of());
        ExpectedValueProvider<DataOrganizationSpecification> specificationAB = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)columnAAlias, (Object)columnBAlias), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of());
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)p.symbol("a")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1", (Type)DoubleType.DOUBLE), (Object)new WindowNode.Function(this.resolvedFunction, (List)ImmutableList.of((Object)new SymbolReference("a")), WindowNode.Frame.DEFAULT_FRAME, false)), (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2", (Type)DoubleType.DOUBLE), (Object)new WindowNode.Function(this.resolvedFunction, (List)ImmutableList.of((Object)new SymbolReference("b")), WindowNode.Frame.DEFAULT_FRAME, false)), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).matches(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationAB).addFunction(PlanMatchPattern.functionCall("avg", Optional.empty(), (List<String>)ImmutableList.of((Object)columnBAlias))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationA).addFunction(PlanMatchPattern.functionCall("avg", Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)columnAAlias, (Object)0, (Object)columnBAlias, (Object)1)))));
    }

    @Test
    public void dependentWindowsAreNotReordered() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)p.symbol("a")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)new WindowNode.Function(this.resolvedFunction, (List)ImmutableList.of((Object)new SymbolReference("avg_2")), WindowNode.Frame.DEFAULT_FRAME, false)), (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2"), (Object)new WindowNode.Function(this.resolvedFunction, (List)ImmutableList.of((Object)new SymbolReference("a")), WindowNode.Frame.DEFAULT_FRAME, false)), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).doesNotFire();
    }
}

