/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedDistinctAggregationWithProjection;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestTransformCorrelatedDistinctAggregationWithProjection
extends BaseRuleTest {
    public TestTransformCorrelatedDistinctAggregationWithProjection() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedDistinctAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("b")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedWithNonDistinctAggregation() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedDistinctAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("b")}), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).singleGroupingSet(p.symbol("b")))))).doesNotFire();
    }

    @Test
    public void rewritesOnSubqueryWithDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedDistinctAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, PlanBuilder.expression("true"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)PlanBuilder.expression("a + 100")), (PlanNode)p.aggregation(innerBuilder -> innerBuilder.singleGroupingSet(p.symbol("a")).source((PlanNode)p.filter(PlanBuilder.expression("b > corr"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"x", (Object)PlanMatchPattern.expression("a + 100")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "a"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter("b > corr").left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.filter("true", PlanMatchPattern.values("a", "b")))))));
    }
}

