/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedGlobalAggregationWithProjection;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestTransformCorrelatedGlobalAggregationWithProjection
extends BaseRuleTest {
    public TestTransformCorrelatedGlobalAggregationWithProjection() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnPlanWithoutCorrelatedJoinNode() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedWithoutAggregation() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("b")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedWithNonScalarAggregation() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void doesNotFireOnMultipleProjections() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr_2"), (Expression)PlanBuilder.expression("expr - 1")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr"), (Expression)PlanBuilder.expression("sum + 1")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping()))))).doesNotFire();
    }

    @Test
    public void doesNotFireOnSubqueryWithoutProjection() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping()))).doesNotFire();
    }

    @Test
    public void rewritesOnSubqueryWithProjection() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr"), (Expression)PlanBuilder.expression("sum + 1")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping())))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"expr", (Object)PlanMatchPattern.expression("(\"sum_1\" + 1)")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"sum_1", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.join(JoinType.LEFT, builder -> builder.left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"corr", (Object)0)))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"b", (Object)1))))))));
    }

    @Test
    public void rewritesOnSubqueryWithDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr_sum"), (Expression)PlanBuilder.expression("sum + 1"), (Symbol)p.symbol("expr_count"), (Expression)PlanBuilder.expression("count - 1")), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("count"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).globalGrouping().source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.singleGroupingSet(p.symbol("a")).source((PlanNode)p.filter(PlanBuilder.expression("b > corr"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"expr_sum", (Object)PlanMatchPattern.expression("(sum_agg + 1)"), (Object)"expr_count", (Object)PlanMatchPattern.expression("count_agg - 1")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_agg"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("count_agg"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"non_null"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "non_null", "a"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter("b > corr").left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.filter("true", PlanMatchPattern.values("a", "b")))))))));
    }

    @Test
    public void rewritesOnSubqueryWithDecorrelatableDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr_sum"), (Expression)PlanBuilder.expression("sum + 1"), (Symbol)p.symbol("expr_count"), (Expression)PlanBuilder.expression("count - 1")), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("count"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).globalGrouping().source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.singleGroupingSet(p.symbol("a")).source((PlanNode)p.filter(PlanBuilder.expression("b = corr"), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"expr_sum", (Object)PlanMatchPattern.expression("(sum_agg + 1)"), (Object)"expr_count", (Object)PlanMatchPattern.expression("count_agg - 1")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_agg"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("count_agg"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"non_null"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter("b = corr").left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("a", "b"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter("true", PlanMatchPattern.values("a", "b")))))))));
    }

    @Test
    public void testWithPreexistingMask() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr"), (Expression)PlanBuilder.expression("sum + 1")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("mask"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), p.symbol("mask")).globalGrouping())))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"expr", (Object)PlanMatchPattern.expression("sum_1 + 1")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_1"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"new_mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"new_mask", (Object)PlanMatchPattern.expression("mask AND non_null")), PlanMatchPattern.join(JoinType.LEFT, builder -> builder.left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"corr", (Object)0)))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"mask", (Object)1)))))))));
    }
}

