/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedGroupedAggregationWithoutProjection;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestTransformCorrelatedGroupedAggregationWithoutProjection
extends BaseRuleTest {
    public TestTransformCorrelatedGroupedAggregationWithoutProjection() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGroupedAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("b")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedWithNonGroupedAggregation() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGroupedAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping()))).doesNotFire();
    }

    @Test
    public void rewritesOnSubqueryWithoutDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGroupedAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, PlanBuilder.expression("true"), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.singleGroupingSet(p.symbol("a")).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("count"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).source((PlanNode)p.filter(PlanBuilder.expression("b > corr"), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"sum_agg", (Object)PlanMatchPattern.expression("sum_agg"), (Object)"count_agg", (Object)PlanMatchPattern.expression("count_agg")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "a"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_agg"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("count_agg"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter("b > corr").left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.filter("true", PlanMatchPattern.values("a", "b")))))));
    }

    @Test
    public void rewritesOnSubqueryWithDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGroupedAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, PlanBuilder.expression("true"), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.singleGroupingSet(p.symbol("a")).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("count"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.singleGroupingSet(p.symbol("a")).source((PlanNode)p.filter(PlanBuilder.expression("b > corr"), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"sum_agg", (Object)PlanMatchPattern.expression("sum_agg"), (Object)"count_agg", (Object)PlanMatchPattern.expression("count_agg")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "a"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_agg"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("count_agg"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "a"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter("b > corr").left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.filter("true", PlanMatchPattern.values("a", "b"))))))));
    }

    @Test
    public void rewritesOnSubqueryWithDecorrelatableDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGroupedAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, PlanBuilder.expression("true"), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.singleGroupingSet(p.symbol("a")).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("count"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.singleGroupingSet(p.symbol("a")).source((PlanNode)p.filter(PlanBuilder.expression("b = corr"), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"sum_agg", (Object)PlanMatchPattern.expression("sum_agg"), (Object)"count_agg", (Object)PlanMatchPattern.expression("count_agg")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "a"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_agg"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("count_agg"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter("b = corr").left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("a", "b"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter("true", PlanMatchPattern.values("a", "b"))))))));
    }
}

