/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedJoinToJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestTransformCorrelatedJoinToJoin
extends BaseRuleTest {
    public TestTransformCorrelatedJoinToJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testRewriteInnerCorrelatedJoin() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b)));
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter("b > a").left(PlanMatchPattern.values("a")).right(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("b")))));
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a), JoinType.INNER, (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)b.toSymbolReference(), (Expression)new LongLiteral("3")), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b)));
        }).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter("b > a AND b < 3").left(PlanMatchPattern.values("a")).right(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("b")))));
    }

    @Test
    public void testRewriteLeftCorrelatedJoin() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b)));
        }).matches(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter("b > a").left(PlanMatchPattern.values("a")).right(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("b")))));
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a), JoinType.LEFT, (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)b.toSymbolReference(), (Expression)new LongLiteral("3")), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b)));
        }).matches(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter("b > a AND b < 3").left(PlanMatchPattern.values("a")).right(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("b")))));
    }

    @Test
    public void doesNotFireForEnforceSingleRow() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.enforceSingleRow((PlanNode)p.filter(PlanBuilder.expression("corr = a"), (PlanNode)p.values(p.symbol("a")))))).doesNotFire();
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("b")))).doesNotFire();
    }
}

