/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedSingleRowSubqueryToProject;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NullLiteral;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestTransformCorrelatedSingleRowSubqueryToProject
extends BaseRuleTest {
    public TestTransformCorrelatedSingleRowSubqueryToProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void testRewrite() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("l_nationkey")), (PlanNode)p.tableScan(this.tester().getCurrentCatalogTableHandle("tiny", "nation"), (List<Symbol>)ImmutableList.of((Object)p.symbol("l_nationkey")), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("l_nationkey"), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT))), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("l_expr2"), (Expression)PlanBuilder.expression("l_nationkey + 1")), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_expr2", (Object)PlanMatchPattern.expression("l_nationkey + 1"), (Object)"l_nationkey", (Object)PlanMatchPattern.expression("l_nationkey")), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"l_nationkey", (Object)"nationkey"))));
    }

    @Test
    public void testDoesNotFireWithEmptyValuesNode() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void testCorrelatedValues() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(3, a), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)a), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)PlanBuilder.expression("a")))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new NullLiteral()), (Object)ImmutableList.of((Object)new NullLiteral()), (Object)ImmutableList.of((Object)new NullLiteral())))));
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(3, a, b), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)a, (Object)c), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)PlanBuilder.expression("a"), (Object)PlanBuilder.expression("1")))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("b"), (Object)"c", (Object)PlanMatchPattern.expression("1")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral()), (Object)ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral()), (Object)ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral())))));
    }

    @Test
    public void testUncorrelatedValues() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(3, a), (PlanNode)p.values(1, b));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("null")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new NullLiteral()), (Object)ImmutableList.of((Object)new NullLiteral()), (Object)ImmutableList.of((Object)new NullLiteral())))));
    }

    @Test
    public void testMultipleRowValues() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(3, a), (PlanNode)p.values(2, b));
        }).doesNotFire();
    }

    @Test
    public void testNonRowValues() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(3, a), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)PlanBuilder.expression("CAST(ROW('true') AS ROW(col boolean))"))));
        }).doesNotFire();
    }
}

