/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.sql.planner.iterative.rule.UnwrapCastInComparison;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUnwrapCastInComparison {
    @Test
    public void testIsTimestampToTimestampWithTimeZoneInjectiveAt() {
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("UTC"), Instant.parse("2020-03-29T00:31:18Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneOffset.UTC, Instant.parse("2020-03-29T00:31:18Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-03-29T00:00:00.999999998Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-03-29T00:00:00.999999999Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-03-29T01:00:00Z"), false);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-03-29T01:00:00.000000001Z"), false);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-03-29T01:00:00.999999998Z"), false);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-03-29T01:00:00.999999999Z"), false);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-03-29T02:00:00Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-03-29T02:00:00.000000001Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-03-29T02:00:00.999999998Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-03-29T02:00:00.999999999Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-03-29T03:00:00Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-03-29T03:00:00.000000001Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-10-25T00:00:00.999999998Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-10-25T00:00:00.999999999Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-10-25T01:00:00Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-10-25T01:00:00.000000001Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-10-25T01:00:00.999999998Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-10-25T01:00:00.999999999Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-10-25T02:00:00Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-10-25T02:00:00.000000001Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-10-25T02:00:00.999999998Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-10-25T02:00:00.999999999Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-10-25T03:00:00Z"), true);
        this.testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId.of("Europe/Warsaw"), Instant.parse("2020-10-25T03:00:00.000000001Z"), true);
    }

    private void testIsTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId sessionZone, Instant instant, boolean expected) {
        boolean actual = UnwrapCastInComparison.isTimestampToTimestampWithTimeZoneInjectiveAt((ZoneId)sessionZone, (Instant)instant);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual).as(String.format("isTimestampToTimestampWithTimeZoneInjectiveAt(%s, %s)", sessionZone, instant), new Object[0])).isEqualTo(expected);
    }
}

