/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule.test;

import com.google.common.collect.ImmutableList;
import io.airlift.testing.Closeables;
import io.trino.spi.Plugin;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.testing.PlanTester;
import java.io.Closeable;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public abstract class BaseRuleTest {
    private RuleTester tester;
    private final List<Plugin> plugins;

    public BaseRuleTest(Plugin ... plugins) {
        this.plugins = ImmutableList.copyOf((Object[])plugins);
    }

    @BeforeAll
    public final void setUp() {
        Optional<PlanTester> planTester = this.createPlanTester();
        if (planTester.isPresent()) {
            this.plugins.forEach(plugin -> ((PlanTester)planTester.get()).installPlugin(plugin));
            this.tester = new RuleTester(planTester.get());
        } else {
            this.tester = RuleTester.builder().addPlugins(this.plugins).build();
        }
    }

    protected Optional<PlanTester> createPlanTester() {
        return Optional.empty();
    }

    @AfterAll
    public final void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.tester});
        this.tester = null;
    }

    protected RuleTester tester() {
        return this.tester;
    }
}

