/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.PlanTestSymbol;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.SortItem;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAddExchangesPlans
extends BasePlanTest {
    @Override
    protected PlanTester createPlanTester() {
        Session session = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build();
        PlanTester planTester = PlanTester.create((Session)session);
        planTester.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        return planTester;
    }

    @Test
    public void testRepartitionForUnionWithAnyTableScans() {
        this.assertDistributedPlan("SELECT nationkey FROM nation UNION select regionkey from region", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation")))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region"))))))));
        this.assertDistributedPlan("SELECT nationkey FROM nation UNION select 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation")))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new GenericLiteral("BIGINT", "1")))))))))));
    }

    @Test
    public void testRepartitionForUnionAllBeforeHashJoin() {
        Session session = Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("join_distribution_type", JoinNode.DistributionType.PARTITIONED.name()).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.name()).build();
        this.assertDistributedPlan("SELECT * FROM (SELECT nationkey FROM nation UNION ALL select nationkey from nation) n join region r on n.nationkey = r.regionkey", session, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("nationkey", "regionkey").left(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation"))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
        this.assertDistributedPlan("SELECT * FROM (SELECT nationkey FROM nation UNION ALL select 1) n join region r on n.nationkey = r.regionkey", session, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("nationkey", "regionkey").left(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new GenericLiteral("BIGINT", "1"))))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
    }

    @Test
    public void testSingleGatheringExchangeForUnionAllWithLimit() {
        this.assertDistributedPlan("SELECT * FROM (\n    SELECT nationkey FROM nation\n    UNION ALL\n    SELECT nationkey FROM nation\n    UNION ALL\n    SELECT nationkey FROM nation\n)\nLIMIT 2\n", PlanMatchPattern.output(PlanMatchPattern.limit(2L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), false, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.limit(2L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.limit(2L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, PlanMatchPattern.tableScan("nation")), PlanMatchPattern.limit(2L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, PlanMatchPattern.tableScan("nation")), PlanMatchPattern.limit(2L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, PlanMatchPattern.tableScan("nation")))))))));
    }

    @Test
    public void testNonSpillableBroadcastJoinAboveTableScan() {
        this.assertDistributedPlan("SELECT * FROM nation n join region r on n.nationkey = r.regionkey", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("nationkey", "regionkey").distributionType(JoinNode.DistributionType.REPLICATED).spillable(false).left(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
        this.assertDistributedPlan("SELECT * FROM nation n join region r on n.nationkey = r.regionkey", this.spillEnabledWithJoinDistributionType(OptimizerConfig.JoinDistributionType.PARTITIONED), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("nationkey", "regionkey").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
    }

    @Test
    public void testForcePartitioningMarkDistinctInput() {
        String query = "SELECT count(orderkey), count(distinct orderkey), custkey , count(1) FROM ( SELECT * FROM (VALUES (1, 2)) as t(custkey, orderkey) UNION ALL SELECT 3, 4) GROUP BY 3";
        this.assertDistributedPlan(query, Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("ignore_downstream_preferences", "true").setSystemProperty("mark_distinct_strategy", "always").build(), PlanMatchPattern.anyTree(PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"partition1", (Object)"partition2"), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"field", (Object)"partition2", (Object)"partition1"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("2"), (Object)new LongLiteral("1"))))), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"partition3"), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"partition3", (Object)"partition4", (Object)"field_0"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("3"), (Object)new LongLiteral("4"), (Object)new LongLiteral("1")))))))));
        this.assertDistributedPlan(query, Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("ignore_downstream_preferences", "false").setSystemProperty("mark_distinct_strategy", "always").build(), PlanMatchPattern.anyTree(PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"partition1"), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"field", (Object)"partition2", (Object)"partition1"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("2"), (Object)new LongLiteral("1"))))), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"partition3"), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"partition3", (Object)"partition4", (Object)"field_0"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("3"), (Object)new LongLiteral("4"), (Object)new LongLiteral("1")))))))));
    }

    @Test
    public void testImplementOffsetWithOrderedSource() {
        this.assertPlan("SELECT name FROM nation ORDER BY regionkey, name OFFSET 5 LIMIT 2", PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression("name")), PlanMatchPattern.filter("row_num > BIGINT '5'", PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression("name")), PlanMatchPattern.topN(7L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("regionkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST), (Object)PlanMatchPattern.sort("name", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"regionkey", (Object)"regionkey")))))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher())))));
    }

    @Test
    public void testImplementOffsetWithUnorderedSource() {
        this.assertPlan("SELECT name FROM nation OFFSET 5 LIMIT 2", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression("name")), PlanMatchPattern.filter("row_num > BIGINT '5'", PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.limit(7L, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name"))))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher()))))));
    }

    @Test
    public void testExchangesAroundTrivialProjection() {
        this.assertPlan("SELECT name, row_number() OVER () FROM (SELECT * FROM nation ORDER BY nationkey LIMIT 5)", PlanMatchPattern.any(PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression("name")), PlanMatchPattern.topN(5L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("nationkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"nationkey", (Object)"nationkey"))))))));
        this.assertPlan("SELECT b, row_number() OVER () FROM (VALUES (1, 2)) t(a, b) WHERE a < 10", PlanMatchPattern.any(PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.filter("a < 10", PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.values("a", "b"))))))));
        this.assertPlan("SELECT row_number() OVER (PARTITION BY regionkey) FROM (SELECT * FROM nation ORDER BY nationkey LIMIT 5)", PlanMatchPattern.anyTree(PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of((Object)"regionkey")), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"regionkey"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"regionkey", (Object)PlanMatchPattern.expression("regionkey")), PlanMatchPattern.topN(5L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("nationkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey", (Object)"nationkey", (Object)"nationkey")))))))));
        this.assertPlan("SELECT row_number() OVER (PARTITION BY b) FROM (VALUES (1, 2)) t(a,b) WHERE a < 10", PlanMatchPattern.anyTree(PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of((Object)"b")), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"b"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.filter("a < 10", PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.values("a", "b"))))))));
        this.assertPlan("SELECT count(name) FROM (SELECT * FROM nation ORDER BY nationkey LIMIT 5)", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of((Object)"name"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression("name")), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.topN(5L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("nationkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"nationkey", (Object)"nationkey")))))))));
        this.assertPlan("SELECT count(b) FROM (VALUES (1, 2)) t(a,b) WHERE a < 10", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of((Object)"b"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.filter("a < 10", PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.values("a", "b")))))));
        this.assertPlan("SELECT 10, a FROM (VALUES 1) t(a)", PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("10"))))));
        this.assertPlan("SELECT 1 UNION ALL SELECT 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1")))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"expr_0"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1")))))));
    }

    @Test
    public void testJoinBuildSideLocalExchange() {
        this.assertDistributedPlan("SELECT * FROM nation n join region r on n.nationkey = r.regionkey", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("nationkey", "regionkey").left(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
        this.assertDistributedPlan("SELECT * FROM nation n join region r on n.nationkey = r.regionkey", Session.builder((Session)this.noJoinReordering()).setSystemProperty("join_partitioned_build_min_row_count", "1").build(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("nationkey", "regionkey").left(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
        this.assertDistributedPlan("SELECT * FROM nation n join (select r.regionkey from region r join region r2 on r.regionkey = r2.regionkey) j on n.nationkey = j.regionkey ", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("nationkey", "regionkey2").left(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.join(JoinType.INNER, rightJoinBuilder -> rightJoinBuilder.equiCriteria("regionkey2", "regionkey1").left(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey2", (Object)"regionkey")))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey1", (Object)"regionkey"))))))))))));
        this.assertDistributedPlan("SELECT * FROM nation n join region r on n.nationkey = r.regionkey", Session.builder((Session)this.noJoinReordering()).setSystemProperty("enable_stats_calculator", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("nationkey", "regionkey").left(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
    }

    @Test
    public void testAggregateIsExactlyPartitioned() {
        this.assertDistributedPlan("SELECT\n    AVG(1)\nFROM (\n    SELECT\n        orderkey,\n        orderstatus,\n        COUNT(*)\n    FROM orders\n    WHERE\n        orderdate > CAST('2042-01-01' AS DATE)\n    GROUP BY\n        orderkey,\n        orderstatus\n)\nGROUP BY\n    orderkey", this.useExactPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ordertatus", (Object)"orderstatus", (Object)"orderkey", (Object)"orderkey", (Object)"orderdate", (Object)"orderdate"))))))));
    }

    @Test
    public void testAggregationPrefersParentPartitioning() {
        String singleColumnParentGroupBy = "SELECT (partkey, sum(count))\nFROM (\n    SELECT suppkey, partkey, count(*) as count\n    FROM lineitem\n    GROUP BY suppkey, partkey)\nGROUP BY partkey";
        this.assertDistributedPlan(singleColumnParentGroupBy, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("count")))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("count_partial")))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"partkey"), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey", "suppkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("count_partial"), PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of())), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey", (Object)"suppkey", (Object)"suppkey"))))))))));
        PlanMatchPattern exactPartitioningPlan = PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("sum_partial")))), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"partkey"), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_partial"), PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("count")))), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("count_partial")))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"partkey", (Object)"suppkey"), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey", "suppkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("count_partial"), PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of())), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey", (Object)"suppkey", (Object)"suppkey"))))))))))));
        this.assertDistributedPlan(singleColumnParentGroupBy, this.doNotUseCostBasedPartitioning(), exactPartitioningPlan);
        this.assertDistributedPlan(singleColumnParentGroupBy, this.useExactPartitioning(), exactPartitioningPlan);
        this.assertDistributedPlan(singleColumnParentGroupBy, this.disableStats(), exactPartitioningPlan);
        this.assertDistributedPlan("SELECT (partkey_expr, sum(count))\nFROM (\n    SELECT suppkey, partkey % 10 as partkey_expr, count(*) as count\n    FROM lineitem\n    GROUP BY suppkey, partkey % 10)\nGROUP BY partkey_expr", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey_expr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("sum_partial")))), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"partkey_expr"), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey_expr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_partial"), PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("count")))), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("count_partial")))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"partkey_expr", (Object)"suppkey"), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("partkey_expr", "suppkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("count_partial"), PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of())), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"partkey_expr", (Object)PlanMatchPattern.expression("partkey % BIGINT '10'")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey", (Object)"suppkey", (Object)"suppkey"))))))))))))));
        this.assertDistributedPlan("SELECT (orderkey % 10000, partkey, sum(count))\nFROM (\n    SELECT orderkey % 10000 as orderkey, partkey, suppkey, count(*) as count\n    FROM lineitem\n    GROUP BY orderkey % 10000, partkey, suppkey)\nGROUP BY orderkey, partkey", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("orderkey_expr", "partkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("count")))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("count_partial")))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"orderkey_expr", (Object)"partkey"), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("orderkey_expr", "partkey", "suppkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("count_partial"), PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of())), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey_expr", (Object)PlanMatchPattern.expression("orderkey % BIGINT '10000'")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey", (Object)"orderkey", (Object)"orderkey", (Object)"suppkey", (Object)"suppkey")))))))))));
    }

    @Test
    public void testWindowIsExactlyPartitioned() {
        this.assertDistributedPlan("SELECT\n    AVG(otherwindow) OVER (\n        PARTITION BY\n            orderkey\n    )\nFROM (\n    SELECT\n        orderkey,\n        orderstatus,\n        COUNT(*) OVER (\n            PARTITION BY\n                orderkey,\n                orderstatus\n        ) AS otherwindow\n    FROM orders\n    WHERE\n        orderdate > CAST('2042-01-01' AS DATE)\n)", this.useExactPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"orderdate", (Object)"orderdate"))))))));
    }

    @Test
    public void testRowNumberIsExactlyPartitioned() {
        this.assertDistributedPlan("SELECT\n    *\nFROM (\n    SELECT\n        a,\n        ROW_NUMBER() OVER (\n            PARTITION BY\n                a\n        ) rn\n    FROM (\n        VALUES\n            (1)\n    ) t (a)\n) t", this.useExactPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.values("a"))));
    }

    @Test
    public void testTopNRowNumberIsExactlyPartitioned() {
        this.assertDistributedPlan("SELECT\n    a,\n    ROW_NUMBER() OVER (\n        PARTITION BY\n            a\n        ORDER BY\n            a\n    ) rn\nFROM (\n    SELECT\n        a,\n        b,\n        COUNT(*)\n    FROM (\n        VALUES\n            (1, 2)\n    ) t (a, b)\n    GROUP BY\n        a,\n        b\n)\nLIMIT\n    2", this.useExactPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testJoinIsExactlyPartitioned() {
        this.assertDistributedPlan("SELECT\n    orders.orderkey,\n    orders.orderstatus\nFROM (\n    SELECT\n        orderkey,\n        ARBITRARY(orderstatus) AS orderstatus,\n        COUNT(*)\n    FROM orders\n    GROUP BY\n        orderkey\n) t,\norders\nWHERE\n    orders.orderkey = t.orderkey\n    AND orders.orderstatus = t.orderstatus", this.useExactPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("orderkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("any_value"), PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol()))), (List<String>)ImmutableList.of((Object)"orderkey"), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"orderstatus", (Object)"orderstatus"))))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey1", (Object)"orderkey", (Object)"orderstatus3", (Object)"orderstatus"))))));
    }

    @Test
    public void testMarkDistinctIsExactlyPartitioned() {
        this.assertDistributedPlan("    SELECT\n        orderkey,\n        orderstatus,\n        COUNT(DISTINCT orderdate),\n        COUNT(DISTINCT clerk)\n    FROM orders\n    WHERE\n        orderdate > CAST('2042-01-01' AS DATE)\n    GROUP BY\n        orderkey,\n        orderstatus\n", this.useExactPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus", (Object)"orderkey", (Object)"orderkey", (Object)"clerk", (Object)"clerk", (Object)"orderdate", (Object)"orderdate"))))))))));
    }

    @Test
    public void testJoinNotExactlyPartitionedWhenColocatedJoinDisabled() {
        this.assertDistributedPlan("        SELECT\n            orders.orderkey,\n            orders.orderstatus\n        FROM (\n            SELECT\n                orderkey,\n                ARBITRARY(orderstatus) AS orderstatus,\n                COUNT(*)\n            FROM orders\n        GROUP BY\n            orderkey\n        ) t,\n        orders\n        WHERE\n            orders.orderkey = t.orderkey\n            AND orders.orderstatus = t.orderstatus\n", this.noJoinReorderingColocatedJoinDisabled(), PlanMatchPattern.anyTree(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("orders")))));
    }

    @Test
    public void testJoinNotExactlyPartitioned() {
        Assertions.assertThat((boolean)SystemSessionProperties.isColocatedJoinEnabled((Session)this.getPlanTester().getDefaultSession())).isTrue();
        this.assertDistributedPlan("    SELECT\n        orders.orderkey,\n        orders.orderstatus\n    FROM (\n        SELECT\n            orderkey,\n            ARBITRARY(orderstatus) AS orderstatus,\n            COUNT(*)\n        FROM orders\n        GROUP BY\n            orderkey\n    ) t,\n    orders\n    WHERE\n        orders.orderkey = t.orderkey\n        AND orders.orderstatus = t.orderstatus\n", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.tableScan("orders"))));
    }

    @Test
    public void testBroadcastJoinAboveUnionAll() {
        this.assertDistributedPlan("    SELECT * FROM region r JOIN (SELECT nationkey FROM nation UNION ALL SELECT nationkey as key FROM nation) n ON r.regionkey = n.nationkey\n", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, join -> join.equiCriteria("regionkey", "nationkey").left(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey")))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")), PlanMatchPattern.tableScan("nation"))))))));
        this.assertDistributedPlan("    SELECT * FROM (SELECT nationkey FROM nation UNION ALL SELECT nationkey as key FROM nation) n JOIN region r ON r.regionkey = n.nationkey\n", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, join -> join.equiCriteria("nationkey", "regionkey").left(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("nation")))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
    }

    @Test
    public void testUnionAllAboveBroadcastJoin() {
        this.assertDistributedPlan("    SELECT regionkey FROM nation UNION ALL (SELECT nationkey FROM nation n JOIN region r on r.regionkey = n.nationkey)\n", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.tableScan("nation"), PlanMatchPattern.join(JoinType.INNER, join -> join.equiCriteria("nationkey", "regionkey").left(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey")))))))));
    }

    @Test
    public void testGroupedAggregationAboveUnionAllCrossJoined() {
        this.assertDistributedPlan("    SELECT sum(nationkey) FROM (SELECT nationkey FROM nation UNION ALL SELECT nationkey FROM nation), region group by nationkey\n", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, join -> join.left(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")), PlanMatchPattern.tableScan("nation"))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION, PlanMatchPattern.tableScan("region")))))));
    }

    @Test
    public void testGroupedAggregationAboveUnionAll() {
        this.assertDistributedPlan("    SELECT sum(nationkey) FROM (SELECT nationkey FROM nation UNION ALL SELECT nationkey FROM nation) GROUP BY nationkey\n", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.project(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"nationkey"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))))), PlanMatchPattern.project(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"nationkey"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))))))));
    }

    @Test
    public void testUnionAllOnPartitionedAndUnpartitionedSources() {
        this.assertDistributedPlan("     SELECT * FROM (SELECT nationkey FROM nation UNION ALL VALUES (1))\n", this.noJoinReordering(), PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, PlanMatchPattern.values("1"), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.tableScan("nation")))));
    }

    @Test
    public void testNestedUnionAll() {
        this.assertDistributedPlan("     SELECT * FROM ((SELECT nationkey FROM nation) UNION ALL (SELECT nationkey FROM nation)) UNION ALL (SELECT nationkey FROM nation)\n", this.noJoinReordering(), PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"))));
    }

    @Test
    public void testUnionAllOnSourceAndHashDistributedChildren() {
        this.assertDistributedPlan("     SELECT * FROM ((SELECT nationkey FROM nation) UNION ALL (SELECT nationkey FROM nation)) UNION ALL (SELECT sum(nationkey) FROM nation GROUP BY nationkey)\n", this.noJoinReordering(), PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.project(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"nationkey"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))))))));
    }

    @Test
    public void testUnionAllOnDifferentCatalogs() {
        MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withGetColumns(schemaTableName -> ImmutableList.of((Object)new ColumnMetadata("nationkey", (Type)BigintType.BIGINT))).withGetTableHandle((session, schemaTableName) -> new MockConnectorTableHandle(SchemaTableName.schemaTableName((String)"default", (String)"nation"), (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.of(ImmutableList.of((Object)new MockConnectorColumnHandle("nationkey", (Type)BigintType.BIGINT))))).withName("mock").build();
        this.getPlanTester().createCatalog("mock", (ConnectorFactory)connectorFactory, (Map)ImmutableMap.of());
        this.assertDistributedPlan("         SELECT * FROM (SELECT nationkey FROM nation UNION ALL SELECT nationkey FROM mock.default.nation), region\n", this.noJoinReordering(), PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, join -> join.left(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, PlanMatchPattern.tableScan("nation"), PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION, PlanMatchPattern.tableScan("region")))))));
    }

    @Test
    public void testUnionAllOnInternalCatalog() {
        this.assertDistributedPlan("         SELECT * FROM (SELECT table_catalog FROM system.information_schema.tables UNION ALL SELECT table_catalog FROM system.information_schema.tables), region\n", this.noJoinReordering(), PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, join -> join.left(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, PlanMatchPattern.tableScan("tables"), PlanMatchPattern.tableScan("tables"))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION, PlanMatchPattern.tableScan("region")))))));
    }

    @Test
    public void testUnionAllOnTableScanAndValues() {
        this.assertDistributedPlan("         SELECT * FROM (SELECT nationkey FROM nation UNION ALL VALUES(1))\n", this.noJoinReordering(), PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.tableScan("nation")))));
    }

    private Session spillEnabledWithJoinDistributionType(OptimizerConfig.JoinDistributionType joinDistributionType) {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("join_distribution_type", joinDistributionType.toString()).setSystemProperty("spill_enabled", "true").setSystemProperty("task_concurrency", "16").build();
    }

    private Session noJoinReordering() {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("spill_enabled", "true").setSystemProperty("task_concurrency", "16").build();
    }

    private Session noJoinReorderingColocatedJoinDisabled() {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("task_concurrency", "16").setSystemProperty("colocated_join", "false").build();
    }

    private Session useExactPartitioning() {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.name()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.PARTITIONED.name()).setSystemProperty("enable_dynamic_filtering", "false").setSystemProperty("use_exact_partitioning", "true").build();
    }

    private Session doNotUseCostBasedPartitioning() {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("use_cost_based_partitioning", "false").build();
    }

    private Session disableStats() {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("enable_stats_calculator", "false").build();
    }
}

