/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.SessionTestUtils;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.ExpressionTestUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.ExpressionEquivalence;
import io.trino.sql.tree.Expression;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

public class TestExpressionEquivalence {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final TestingTransactionManager TRANSACTION_MANAGER = new TestingTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final ExpressionEquivalence EQUIVALENCE = new ExpressionEquivalence(PLANNER_CONTEXT.getMetadata(), PLANNER_CONTEXT.getFunctionManager(), PLANNER_CONTEXT.getTypeManager(), new IrTypeAnalyzer(PLANNER_CONTEXT));
    private static final TypeProvider TYPE_PROVIDER = TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("a_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("b_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("c_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("d_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("e_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("f_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("g_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("h_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("a_bigint"), (Object)BigintType.BIGINT).put((Object)new Symbol("b_bigint"), (Object)BigintType.BIGINT).put((Object)new Symbol("c_bigint"), (Object)BigintType.BIGINT).put((Object)new Symbol("d_bigint"), (Object)BigintType.BIGINT).put((Object)new Symbol("b_double"), (Object)DoubleType.DOUBLE).buildOrThrow());

    @Test
    public void testEquivalent() {
        TestExpressionEquivalence.assertEquivalent("CAST(null AS BIGINT)", "CAST(null as BIGINT)");
        TestExpressionEquivalence.assertEquivalent("a_bigint < b_double", "b_double > a_bigint");
        TestExpressionEquivalence.assertEquivalent("true", "true");
        TestExpressionEquivalence.assertEquivalent("4", "4");
        TestExpressionEquivalence.assertEquivalent("4.4", "4.4");
        TestExpressionEquivalence.assertEquivalent("'foo'", "'foo'");
        TestExpressionEquivalence.assertEquivalent("4 = 5", "5 = 4");
        TestExpressionEquivalence.assertEquivalent("4.4 = 5.5", "5.5 = 4.4");
        TestExpressionEquivalence.assertEquivalent("'foo' = 'bar'", "'bar' = 'foo'");
        TestExpressionEquivalence.assertEquivalent("4 <> 5", "5 <> 4");
        TestExpressionEquivalence.assertEquivalent("4 is distinct from 5", "5 is distinct from 4");
        TestExpressionEquivalence.assertEquivalent("4 < 5", "5 > 4");
        TestExpressionEquivalence.assertEquivalent("4 <= 5", "5 >= 4");
        TestExpressionEquivalence.assertEquivalent("TIMESTAMP '2020-05-10 12:34:56.123456789' = TIMESTAMP '2021-05-10 12:34:56.123456789'", "TIMESTAMP '2021-05-10 12:34:56.123456789' = TIMESTAMP '2020-05-10 12:34:56.123456789'");
        TestExpressionEquivalence.assertEquivalent("TIMESTAMP '2020-05-10 12:34:56.123456789 +8' = TIMESTAMP '2021-05-10 12:34:56.123456789 +8'", "TIMESTAMP '2021-05-10 12:34:56.123456789 +8' = TIMESTAMP '2020-05-10 12:34:56.123456789 +8'");
        TestExpressionEquivalence.assertEquivalent("mod(4, 5)", "mod(4, 5)");
        TestExpressionEquivalence.assertEquivalent("a_bigint", "a_bigint");
        TestExpressionEquivalence.assertEquivalent("a_bigint = b_bigint", "b_bigint = a_bigint");
        TestExpressionEquivalence.assertEquivalent("a_bigint < b_bigint", "b_bigint > a_bigint");
        TestExpressionEquivalence.assertEquivalent("a_bigint < b_double", "b_double > a_bigint");
        TestExpressionEquivalence.assertEquivalent("true and false", "false and true");
        TestExpressionEquivalence.assertEquivalent("4 <= 5 and 6 < 7", "7 > 6 and 5 >= 4");
        TestExpressionEquivalence.assertEquivalent("4 <= 5 or 6 < 7", "7 > 6 or 5 >= 4");
        TestExpressionEquivalence.assertEquivalent("a_bigint <= b_bigint and c_bigint < d_bigint", "d_bigint > c_bigint and b_bigint >= a_bigint");
        TestExpressionEquivalence.assertEquivalent("a_bigint <= b_bigint or c_bigint < d_bigint", "d_bigint > c_bigint or b_bigint >= a_bigint");
        TestExpressionEquivalence.assertEquivalent("4 <= 5 and 4 <= 5", "4 <= 5");
        TestExpressionEquivalence.assertEquivalent("4 <= 5 and 6 < 7", "7 > 6 and 5 >= 4 and 5 >= 4");
        TestExpressionEquivalence.assertEquivalent("2 <= 3 and 4 <= 5 and 6 < 7", "7 > 6 and 5 >= 4 and 3 >= 2");
        TestExpressionEquivalence.assertEquivalent("4 <= 5 or 4 <= 5", "4 <= 5");
        TestExpressionEquivalence.assertEquivalent("4 <= 5 or 6 < 7", "7 > 6 or 5 >= 4 or 5 >= 4");
        TestExpressionEquivalence.assertEquivalent("2 <= 3 or 4 <= 5 or 6 < 7", "7 > 6 or 5 >= 4 or 3 >= 2");
        TestExpressionEquivalence.assertEquivalent("a_boolean and b_boolean and c_boolean", "c_boolean and b_boolean and a_boolean");
        TestExpressionEquivalence.assertEquivalent("(a_boolean and b_boolean) and c_boolean", "(c_boolean and b_boolean) and a_boolean");
        TestExpressionEquivalence.assertEquivalent("a_boolean and (b_boolean or c_boolean)", "a_boolean and (c_boolean or b_boolean) and a_boolean");
        TestExpressionEquivalence.assertEquivalent("(a_boolean or b_boolean or c_boolean) and (d_boolean or e_boolean) and (f_boolean or g_boolean or h_boolean)", "(h_boolean or g_boolean or f_boolean) and (b_boolean or a_boolean or c_boolean) and (e_boolean or d_boolean)");
        TestExpressionEquivalence.assertEquivalent("(a_boolean and b_boolean and c_boolean) or (d_boolean and e_boolean) or (f_boolean and g_boolean and h_boolean)", "(h_boolean and g_boolean and f_boolean) or (b_boolean and a_boolean and c_boolean) or (e_boolean and d_boolean)");
    }

    private static void assertEquivalent(@Language(value="SQL") String left, @Language(value="SQL") String right) {
        Expression leftExpression = ExpressionTestUtils.planExpression(TRANSACTION_MANAGER, PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION, TYPE_PROVIDER, SQL_PARSER.createExpression(left));
        Expression rightExpression = ExpressionTestUtils.planExpression(TRANSACTION_MANAGER, PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION, TYPE_PROVIDER, SQL_PARSER.createExpression(right));
        Set symbols = SymbolsExtractor.extractUnique((Iterable)ImmutableList.of((Object)leftExpression, (Object)rightExpression));
        TypeProvider types = TypeProvider.copyOf(symbols.stream().collect(Collectors.toMap(Function.identity(), TestExpressionEquivalence::generateType)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestExpressionEquivalence.areExpressionEquivalent(leftExpression, rightExpression, types)).describedAs(String.format("Expected (%s) and (%s) to be equivalent", left, right), new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestExpressionEquivalence.areExpressionEquivalent(rightExpression, leftExpression, types)).describedAs(String.format("Expected (%s) and (%s) to be equivalent", right, left), new Object[0])).isTrue();
    }

    @Test
    public void testNotEquivalent() {
        TestExpressionEquivalence.assertNotEquivalent("CAST(null AS BOOLEAN)", "false");
        TestExpressionEquivalence.assertNotEquivalent("false", "CAST(null AS BOOLEAN)");
        TestExpressionEquivalence.assertNotEquivalent("true", "false");
        TestExpressionEquivalence.assertNotEquivalent("4", "5");
        TestExpressionEquivalence.assertNotEquivalent("4.4", "5.5");
        TestExpressionEquivalence.assertNotEquivalent("'foo'", "'bar'");
        TestExpressionEquivalence.assertNotEquivalent("4 = 5", "5 = 6");
        TestExpressionEquivalence.assertNotEquivalent("4 <> 5", "5 <> 6");
        TestExpressionEquivalence.assertNotEquivalent("4 is distinct from 5", "5 is distinct from 6");
        TestExpressionEquivalence.assertNotEquivalent("4 < 5", "5 > 6");
        TestExpressionEquivalence.assertNotEquivalent("4 <= 5", "5 >= 6");
        TestExpressionEquivalence.assertNotEquivalent("mod(4, 5)", "mod(5, 4)");
        TestExpressionEquivalence.assertNotEquivalent("a_bigint", "b_bigint");
        TestExpressionEquivalence.assertNotEquivalent("a_bigint = b_bigint", "b_bigint = c_bigint");
        TestExpressionEquivalence.assertNotEquivalent("a_bigint < b_bigint", "b_bigint > c_bigint");
        TestExpressionEquivalence.assertNotEquivalent("a_bigint < b_double", "b_double > c_bigint");
        TestExpressionEquivalence.assertNotEquivalent("4 <= 5 and 6 < 7", "7 > 6 and 5 >= 6");
        TestExpressionEquivalence.assertNotEquivalent("4 <= 5 or 6 < 7", "7 > 6 or 5 >= 6");
        TestExpressionEquivalence.assertNotEquivalent("a_bigint <= b_bigint and c_bigint < d_bigint", "d_bigint > c_bigint and b_bigint >= c_bigint");
        TestExpressionEquivalence.assertNotEquivalent("a_bigint <= b_bigint or c_bigint < d_bigint", "d_bigint > c_bigint or b_bigint >= c_bigint");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIME '12:34:56.123 +00:00' AS varchar)", "CAST(TIME '14:34:56.123 +02:00' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIME '12:34:56.123456 +00:00' AS varchar)", "CAST(TIME '14:34:56.123456 +02:00' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIME '12:34:56.123456789 +00:00' AS varchar)", "CAST(TIME '14:34:56.123456789 +02:00' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIME '12:34:56.123456789012 +00:00' AS varchar)", "CAST(TIME '14:34:56.123456789012 +02:00' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIMESTAMP '2020-05-10 12:34:56.123 Europe/Warsaw' AS varchar)", "CAST(TIMESTAMP '2020-05-10 12:34:56.123 Europe/Paris' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIMESTAMP '2020-05-10 12:34:56.123456 Europe/Warsaw' AS varchar)", "CAST(TIMESTAMP '2020-05-10 12:34:56.123456 Europe/Paris' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIMESTAMP '2020-05-10 12:34:56.123456789 Europe/Warsaw' AS varchar)", "CAST(TIMESTAMP '2020-05-10 12:34:56.123456789 Europe/Paris' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIMESTAMP '2020-05-10 12:34:56.123456789012 Europe/Warsaw' AS varchar)", "CAST(TIMESTAMP '2020-05-10 12:34:56.123456789012 Europe/Paris' AS varchar)");
    }

    private static void assertNotEquivalent(@Language(value="SQL") String left, @Language(value="SQL") String right) {
        Expression leftExpression = ExpressionTestUtils.planExpression(TRANSACTION_MANAGER, PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION, TYPE_PROVIDER, SQL_PARSER.createExpression(left));
        Expression rightExpression = ExpressionTestUtils.planExpression(TRANSACTION_MANAGER, PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION, TYPE_PROVIDER, SQL_PARSER.createExpression(right));
        Set symbols = SymbolsExtractor.extractUnique((Iterable)ImmutableList.of((Object)leftExpression, (Object)rightExpression));
        TypeProvider types = TypeProvider.copyOf(symbols.stream().collect(Collectors.toMap(Function.identity(), TestExpressionEquivalence::generateType)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestExpressionEquivalence.areExpressionEquivalent(leftExpression, rightExpression, types)).describedAs(String.format("Expected (%s) and (%s) to not be equivalent", left, right), new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestExpressionEquivalence.areExpressionEquivalent(rightExpression, leftExpression, types)).describedAs(String.format("Expected (%s) and (%s) to not be equivalent", right, left), new Object[0])).isFalse();
    }

    private static boolean areExpressionEquivalent(Expression leftExpression, Expression rightExpression, TypeProvider types) {
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager((TransactionManager)transactionManager).build();
        return (Boolean)TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(SessionTestUtils.TEST_SESSION, transactionSession -> EQUIVALENCE.areExpressionsEquivalent(transactionSession, leftExpression, rightExpression, types));
    }

    private static Type generateType(Symbol symbol) {
        String typeName = (String)Splitter.on((char)'_').limit(2).splitToList((CharSequence)symbol.getName()).get(1);
        return PLANNER_CONTEXT.getTypeManager().getType(new TypeSignature(typeName, (List)ImmutableList.of()));
    }
}

