/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.planprinter.CounterBasedAnonymizer;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCounterBasedAnonymizer {
    @Test
    public void testTimestampWithTimeZoneValueAnonymization() {
        CounterBasedAnonymizer anonymizer = new CounterBasedAnonymizer();
        Assertions.assertThat((String)anonymizer.anonymize((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "2012-10-30 18:00:00.000 America/Los_Angeles")).isEqualTo("timestamp_3_with_time_zone_value_1");
    }

    @Test
    public void testSymbolReferenceAnonymization() {
        LogicalExpression expression = new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral("1")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral("2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("c"), (Expression)new LongLiteral("3"))));
        CounterBasedAnonymizer anonymizer = new CounterBasedAnonymizer();
        Assertions.assertThat((String)anonymizer.anonymize((Expression)expression)).isEqualTo("((\"symbol_1\" > 'long_literal_1') AND (\"symbol_2\" < 'long_literal_2') AND (\"symbol_3\" = 'long_literal_3'))");
    }

    @Test
    public void testLiteralAnonymization() {
        CounterBasedAnonymizer anonymizer = new CounterBasedAnonymizer();
        Assertions.assertThat((String)anonymizer.anonymize((Expression)new BinaryLiteral("DEF321"))).isEqualTo("'binary_literal_1'");
        Assertions.assertThat((String)anonymizer.anonymize((Expression)new StringLiteral("abc"))).isEqualTo("'string_literal_2'");
        Assertions.assertThat((String)anonymizer.anonymize((Expression)new GenericLiteral("bigint", "1"))).isEqualTo("'bigint_literal_3'");
        Assertions.assertThat((String)anonymizer.anonymize((Expression)new DecimalLiteral("123"))).isEqualTo("'decimal_literal_4'");
        Assertions.assertThat((String)anonymizer.anonymize((Expression)new DoubleLiteral(String.valueOf(6554)))).isEqualTo("'double_literal_5'");
        Assertions.assertThat((String)anonymizer.anonymize((Expression)new DoubleLiteral(String.valueOf(Double.MAX_VALUE)))).isEqualTo("'double_literal_6'");
        Assertions.assertThat((String)anonymizer.anonymize((Expression)new LongLiteral(String.valueOf(6554)))).isEqualTo("'long_literal_7'");
        Assertions.assertThat((String)anonymizer.anonymize((Expression)new LongLiteral(String.valueOf(Long.MAX_VALUE)))).isEqualTo("'long_literal_8'");
        Assertions.assertThat((String)anonymizer.anonymize((Expression)new BooleanLiteral("true"))).isEqualTo("true");
        Assertions.assertThat((String)anonymizer.anonymize((Expression)new NullLiteral())).isEqualTo("null");
        Assertions.assertThat((String)anonymizer.anonymize((Expression)new IntervalLiteral("33", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.DAY, Optional.empty()))).isEqualTo("'interval_literal_9'");
    }
}

