/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.cost.PlanNodeStatsAndCostSummary;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.TableInfo;
import io.trino.metadata.QualifiedObjectName;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.planprinter.Anonymizer;
import io.trino.sql.planner.planprinter.JsonRenderer;
import io.trino.sql.planner.planprinter.NoOpAnonymizer;
import io.trino.sql.planner.planprinter.NodeRepresentation;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.planner.planprinter.ValuePrinter;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestJsonRepresentation {
    private static final JsonCodec<Map<String, JsonRenderer.JsonRenderedNode>> DISTRIBUTED_PLAN_JSON_CODEC = JsonCodec.mapJsonCodec(String.class, JsonRenderer.JsonRenderedNode.class);
    private static final JsonCodec<JsonRenderer.JsonRenderedNode> JSON_RENDERED_NODE_CODEC = JsonCodec.jsonCodec(JsonRenderer.JsonRenderedNode.class);
    private static final TableInfo TABLE_INFO = new TableInfo(Optional.of("tpch"), new QualifiedObjectName("tpch", "tiny", "orders"), TupleDomain.all());
    private QueryRunner queryRunner;

    @BeforeAll
    public void setUp() {
        this.queryRunner = new StandaloneQueryRunner(SessionTestUtils.TEST_SESSION);
        this.queryRunner.installPlugin((Plugin)new TpchPlugin());
        this.queryRunner.createCatalog((String)SessionTestUtils.TEST_SESSION.getCatalog().get(), "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
    }

    @AfterAll
    public void tearDown() {
        this.queryRunner.close();
        this.queryRunner = null;
    }

    @Test
    public void testJsonPlan() {
        String query = "SELECT * FROM (VALUES 1, 2) limit 1";
        JsonRenderer.JsonRenderedNode expectedPlan = new JsonRenderer.JsonRenderedNode("8", "Output", (Map)ImmutableMap.of((Object)"columnNames", (Object)"[_col0]"), (List)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"field", (Type)IntegerType.INTEGER)), (List)ImmutableList.of((Object)"_col0 := field"), (List)ImmutableList.of((Object)new PlanNodeStatsAndCostSummary(1.0, 5.0, 0.0, 0.0, 0.0)), (List)ImmutableList.of((Object)new JsonRenderer.JsonRenderedNode("90", "Limit", (Map)ImmutableMap.of((Object)"count", (Object)"1", (Object)"withTies", (Object)"", (Object)"inputPreSortedBy", (Object)"[]"), (List)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"field", (Type)IntegerType.INTEGER)), (List)ImmutableList.of(), (List)ImmutableList.of((Object)new PlanNodeStatsAndCostSummary(1.0, 5.0, 5.0, 0.0, 0.0)), (List)ImmutableList.of((Object)new JsonRenderer.JsonRenderedNode("0", "Values", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"field", (Type)IntegerType.INTEGER)), (List)ImmutableList.of((Object)"(1)", (Object)"(2)"), (List)ImmutableList.of((Object)new PlanNodeStatsAndCostSummary(2.0, 10.0, 0.0, 0.0, 0.0)), (List)ImmutableList.of())))));
        Assertions.assertThat((Object)this.queryRunner.execute("EXPLAIN (TYPE DISTRIBUTED, FORMAT JSON) " + query).getOnlyValue()).isEqualTo((Object)DISTRIBUTED_PLAN_JSON_CODEC.toJson((Object)ImmutableMap.of((Object)"0", (Object)expectedPlan)));
        Assertions.assertThat((Object)this.queryRunner.execute("EXPLAIN (TYPE LOGICAL, FORMAT JSON) " + query).getOnlyValue()).isEqualTo((Object)JSON_RENDERED_NODE_CODEC.toJson((Object)expectedPlan));
    }

    @Test
    public void testAggregationPlan() {
        this.assertJsonRepresentation(pb -> pb.aggregation(ab -> ab.step(AggregationNode.Step.FINAL).addAggregation(pb.symbol("sum", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("x"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(pb.symbol("y", (Type)BigintType.BIGINT), pb.symbol("z", (Type)BigintType.BIGINT)).source((PlanNode)pb.values(pb.symbol("x", (Type)BigintType.BIGINT), pb.symbol("y", (Type)BigintType.BIGINT), pb.symbol("z", (Type)BigintType.BIGINT)))), new JsonRenderer.JsonRenderedNode("1", "Aggregate", (Map)ImmutableMap.of((Object)"type", (Object)"FINAL", (Object)"keys", (Object)"[y, z]", (Object)"hash", (Object)"[]"), (List)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"y", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"z", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"sum", (Type)BigintType.BIGINT)), (List)ImmutableList.of((Object)"sum := sum(\"x\")"), (List)ImmutableList.of(), (List)ImmutableList.of((Object)TestJsonRepresentation.valuesRepresentation("0", (List<NodeRepresentation.TypedSymbol>)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"x", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"y", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"z", (Type)BigintType.BIGINT))))));
    }

    @Test
    public void testJoinPlan() {
        this.assertJsonRepresentation(pb -> pb.join(JoinType.INNER, (PlanNode)pb.values(pb.symbol("a", (Type)BigintType.BIGINT), pb.symbol("b", (Type)BigintType.BIGINT)), (PlanNode)pb.values(pb.symbol("c", (Type)BigintType.BIGINT), pb.symbol("d", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(pb.symbol("a", (Type)BigintType.BIGINT), pb.symbol("d", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)pb.symbol("b", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of(), Optional.of(PlanBuilder.expression("a < c")), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)pb.symbol("d", (Type)BigintType.BIGINT))), new JsonRenderer.JsonRenderedNode("2", "InnerJoin", (Map)ImmutableMap.of((Object)"criteria", (Object)"(\"a\" = \"d\")", (Object)"filter", (Object)"(\"a\" < \"c\")", (Object)"hash", (Object)"[]"), (List)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"b", (Type)BigintType.BIGINT)), (List)ImmutableList.of((Object)"dynamicFilterAssignments = {d -> #DF}"), (List)ImmutableList.of(), (List)ImmutableList.of((Object)TestJsonRepresentation.valuesRepresentation("0", (List<NodeRepresentation.TypedSymbol>)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"a", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"b", (Type)BigintType.BIGINT))), (Object)TestJsonRepresentation.valuesRepresentation("1", (List<NodeRepresentation.TypedSymbol>)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"c", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"d", (Type)BigintType.BIGINT))))));
    }

    @Test
    public void testSourceFragmentIdsInRemoteSource() {
        this.assertJsonRepresentation(pb -> pb.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("1"), (Object)new PlanFragmentId("2")), (List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT), (Object)pb.symbol("b", (Type)BigintType.BIGINT)), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.NONE), new JsonRenderer.JsonRenderedNode("0", "RemoteSource", (Map)ImmutableMap.of((Object)"sourceFragmentIds", (Object)"[1, 2]"), (List)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"a", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"b", (Type)BigintType.BIGINT)), (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of()));
    }

    private static JsonRenderer.JsonRenderedNode valuesRepresentation(String id, List<NodeRepresentation.TypedSymbol> outputs) {
        return new JsonRenderer.JsonRenderedNode(id, "Values", (Map)ImmutableMap.of(), outputs, (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of());
    }

    private void assertJsonRepresentation(Function<PlanBuilder, PlanNode> sourceNodeSupplier, JsonRenderer.JsonRenderedNode expectedRepresentation) {
        this.queryRunner.inTransaction(transactionSession -> {
            PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), this.queryRunner.getPlannerContext(), (Session)transactionSession);
            ValuePrinter valuePrinter = new ValuePrinter(this.queryRunner.getPlannerContext().getMetadata(), this.queryRunner.getPlannerContext().getFunctionManager(), transactionSession);
            String jsonRenderedNode = new PlanPrinter((PlanNode)sourceNodeSupplier.apply(planBuilder), planBuilder.getTypes(), scanNode -> TABLE_INFO, (Map)ImmutableMap.of(), valuePrinter, StatsAndCosts.empty(), Optional.empty(), (Anonymizer)new NoOpAnonymizer()).toJson();
            Assertions.assertThat((String)jsonRenderedNode).isEqualTo(JSON_RENDERED_NODE_CODEC.toJson((Object)expectedRepresentation));
            return null;
        });
    }
}

