/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestAggregation {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testQuantifiedComparison() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT v > ALL (VALUES 1) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k"))).failure().hasMessageContaining("must be an aggregate expression or appear in GROUP BY clause");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT v > ANY (VALUES 1) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k"))).failure().hasMessageContaining("must be an aggregate expression or appear in GROUP BY clause");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT v > SOME (VALUES 1) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k"))).failure().hasMessageContaining("must be an aggregate expression or appear in GROUP BY clause");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count_if(v > ALL (VALUES 0, 1)) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k"))).matches("VALUES BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count_if(v > ANY (VALUES 0, 1)) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k"))).matches("VALUES BIGINT '2'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 > ALL (VALUES k) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k"))).failure().hasMessageContaining("line 1:17: Given correlated subquery is not supported");
    }
}

