/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorEntities;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Identity;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestCheckConstraint {
    private static final String LOCAL_CATALOG = "local";
    private static final String MOCK_CATALOG = "mock";
    private static final String USER = "user";
    private static final Session SESSION = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setIdentity(Identity.forUser((String)"user").build()).build();
    private final QueryAssertions assertions;

    public TestCheckConstraint() {
        StandaloneQueryRunner runner = new StandaloneQueryRunner(SESSION);
        runner.installPlugin((Plugin)new TpchPlugin());
        runner.createCatalog(LOCAL_CATALOG, "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        runner.installPlugin((Plugin)new MockConnectorPlugin(MockConnectorFactory.builder().withGetColumns(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_null_check"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_multiple_column_constraint"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_invalid_function"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_not_boolean_expression"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_subquery"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_current_date"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_current_time"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_current_timestamp"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_localtime"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_localtimestamp"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_not_deterministic"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            throw new UnsupportedOperationException();
        }).withCheckConstraints(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation"))) {
                return ImmutableList.of((Object)"regionkey < 10");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_null_check"))) {
                return ImmutableList.of((Object)"null");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_multiple_column_constraint"))) {
                return ImmutableList.of((Object)"nationkey < 100 AND regionkey < 50");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_invalid_function"))) {
                return ImmutableList.of((Object)"invalid_function(nationkey) > 100");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_not_boolean_expression"))) {
                return ImmutableList.of((Object)"1 + 1");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_subquery"))) {
                return ImmutableList.of((Object)"nationkey > (SELECT count(*) FROM nation)");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_current_date"))) {
                return ImmutableList.of((Object)"CURRENT_DATE > DATE '2022-12-31'");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_current_time"))) {
                return ImmutableList.of((Object)"CURRENT_TIME > TIME '12:34:56.123+00:00'");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_current_timestamp"))) {
                return ImmutableList.of((Object)"CURRENT_TIMESTAMP > TIMESTAMP '2022-12-31 23:59:59'");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_localtime"))) {
                return ImmutableList.of((Object)"LOCALTIME > TIME '12:34:56.123'");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_localtimestamp"))) {
                return ImmutableList.of((Object)"LOCALTIMESTAMP > TIMESTAMP '2022-12-31 23:59:59'");
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_not_deterministic"))) {
                return ImmutableList.of((Object)"nationkey > random()");
            }
            throw new UnsupportedOperationException();
        }).withData(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation"))) {
                return MockConnectorEntities.TPCH_NATION_DATA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_null_check"))) {
                return MockConnectorEntities.TPCH_NATION_DATA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_multiple_column_constraint"))) {
                return MockConnectorEntities.TPCH_NATION_DATA;
            }
            throw new UnsupportedOperationException();
        }).build()));
        runner.createCatalog(MOCK_CATALOG, MOCK_CATALOG, (Map)ImmutableMap.of());
        this.assertions = new QueryAssertions((QueryRunner)runner);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testInsert() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation VALUES (101, 'POLAND', 0, 'No comment')"))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation VALUES (26, 'POLAND', 11, 'No comment')"))).failure().hasMessage("Check constraint violation: (regionkey < 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation VALUES\n(26, 'POLAND', 11, 'No comment'),\n(27, 'HOLLAND', 11, 'A comment')\n"))).failure().hasMessage("Check constraint violation: (regionkey < 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation VALUES\n(26, 'POLAND', 11, 'No comment'),\n(27, 'HOLLAND', 11, 'A comment')\n"))).failure().hasMessage("Check constraint violation: (regionkey < 10)");
    }

    @Test
    public void testMergeInsert() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')\n"))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT (nationkey) VALUES (NULL)\n"))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT (nationkey) VALUES (0)\n"))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 10, 'No comment')\n"))).failure().hasMessage("Check constraint violation: (regionkey < 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES (26, 'POLAND', 10, 'No comment'), (27, 'HOLLAND', 10, 'A comment')) t(a,b,c,d) ON nationkey = a\nWHEN NOT MATCHED THEN INSERT VALUES (a,b,c,d)\n"))).failure().hasMessage("Check constraint violation: (regionkey < 10)");
    }

    @Test
    public void testInsertAllowUnknown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation(nationkey) VALUES (null)"))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation(regionkey) VALUES (0)"))).matches("SELECT BIGINT '1'");
    }

    @Test
    void testNullConstraint() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_with_null_check USING (VALUES 1,2) t(x) ON nationkey = x\nWHEN MATCHED THEN DELETE\n"))).matches("SELECT BIGINT '2'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_with_null_check USING (VALUES 5) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2\n"))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_with_null_check USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')\n"))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_with_null_check VALUES (99, 'POLAND', 49, 'No comment')"))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("DELETE FROM mock.tiny.nation_with_null_check WHERE nationkey < 3"))).matches("SELECT BIGINT '3'");
    }

    @Test
    public void testInsertCheckMultipleColumns() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_multiple_column_constraint VALUES (99, 'POLAND', 49, 'No comment')"))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_multiple_column_constraint VALUES (99, 'POLAND', 50, 'No comment')"))).failure().hasMessage("Check constraint violation: ((nationkey < 100) AND (regionkey < 50))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_multiple_column_constraint VALUES (100, 'POLAND', 49, 'No comment')"))).failure().hasMessage("Check constraint violation: ((nationkey < 100) AND (regionkey < 50))");
    }

    @Test
    public void testInsertSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_subquery VALUES (26, 'POLAND', 51, 'No comment')"))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_subquery VALUES (10, 'POLAND', 0, 'No comment')"))).failure().hasMessage("Check constraint violation: (nationkey > (SELECT count(*)\nFROM\n  nation\n))");
    }

    @Test
    public void testInsertUnsupportedCurrentDate() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_current_date VALUES (101, 'POLAND', 0, 'No comment')"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testInsertUnsupportedCurrentTime() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_current_time VALUES (101, 'POLAND', 0, 'No comment')"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testInsertUnsupportedCurrentTimestamp() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_current_timestamp VALUES (101, 'POLAND', 0, 'No comment')"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testInsertUnsupportedLocaltime() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_localtime VALUES (101, 'POLAND', 0, 'No comment')"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testInsertUnsupportedLocaltimestamp() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_localtimestamp VALUES (101, 'POLAND', 0, 'No comment')"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testInsertUnsupportedConstraint() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_invalid_function VALUES (101, 'POLAND', 0, 'No comment')"))).failure().hasMessageContaining("Function 'invalid_function' not registered");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_not_boolean_expression VALUES (101, 'POLAND', 0, 'No comment')"))).failure().hasMessageContaining("to be of type BOOLEAN, but was integer");
    }

    @Test
    public void testInsertNotDeterministic() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_not_deterministic VALUES (100, 'POLAND', 0, 'No comment')"))).failure().hasMessageContaining("Check constraint expression should be deterministic");
    }

    @Test
    public void testDelete() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("DELETE FROM mock.tiny.nation WHERE nationkey < 3"))).matches("SELECT BIGINT '3'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("DELETE FROM mock.tiny.nation WHERE nationkey IN (1, 2, 3)"))).matches("SELECT BIGINT '3'");
    }

    @Test
    public void testMergeDelete() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2) t(x) ON nationkey = x\nWHEN MATCHED THEN DELETE\n"))).matches("SELECT BIGINT '2'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3,4,11) t(x) ON regionkey = x\nWHEN MATCHED THEN DELETE\n"))).matches("SELECT BIGINT '20'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,11) t(x) ON nationkey = x\nWHEN MATCHED THEN DELETE\n"))).matches("SELECT BIGINT '2'");
    }

    @Test
    public void testUpdate() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey + 1"))).matches("SELECT BIGINT '25'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 2 WHERE nationkey IN (1, 2, 3)"))).matches("SELECT BIGINT '3'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 10"))).failure().hasMessage("Check constraint violation: (regionkey < 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 10 WHERE nationkey IN (1, 11)"))).failure().hasMessage("Check constraint violation: (regionkey < 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 10 WHERE nationkey = 11"))).failure().hasMessage("Check constraint violation: (regionkey < 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET nationkey = 10 WHERE nationkey < 3"))).matches("SELECT BIGINT '3'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET nationkey = null WHERE nationkey < 3"))).matches("SELECT BIGINT '3'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET nationkey = 10 WHERE nationkey = 10"))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET nationkey = 10 WHERE nationkey = null"))).matches("SELECT BIGINT '0'");
    }

    @Test
    public void testUpdateAllowUnknown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET regionkey = NULL"))).matches("SELECT BIGINT '25'");
    }

    @Test
    public void testUpdateCheckMultipleColumns() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_multiple_column_constraint SET regionkey = 49, nationkey = 99"))).matches("SELECT BIGINT '25'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_multiple_column_constraint SET regionkey = 49"))).matches("SELECT BIGINT '25'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_multiple_column_constraint SET nationkey = 99"))).matches("SELECT BIGINT '25'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_multiple_column_constraint SET regionkey = 50, nationkey = 100"))).failure().hasMessage("Check constraint violation: ((nationkey < 100) AND (regionkey < 50))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_multiple_column_constraint SET regionkey = 50, nationkey = 99"))).failure().hasMessage("Check constraint violation: ((nationkey < 100) AND (regionkey < 50))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_multiple_column_constraint SET regionkey = 49, nationkey = 100"))).failure().hasMessage("Check constraint violation: ((nationkey < 100) AND (regionkey < 50))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_multiple_column_constraint SET regionkey = 50"))).failure().hasMessage("Check constraint violation: ((nationkey < 100) AND (regionkey < 50))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_multiple_column_constraint SET nationkey = 100"))).failure().hasMessage("Check constraint violation: ((nationkey < 100) AND (regionkey < 50))");
    }

    @Test
    public void testUpdateSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_subquery SET nationkey = 100"))).nonTrinoExceptionFailure().hasMessageContaining("Unexpected subquery expression in logical plan");
    }

    @Test
    public void testUpdateUnsupportedCurrentDate() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_current_date SET nationkey = 10"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testUpdateUnsupportedCurrentTime() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_current_time SET nationkey = 10"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testUpdateUnsupportedCurrentTimestamp() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_current_timestamp SET nationkey = 10"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testUpdateUnsupportedLocaltime() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_localtime SET nationkey = 10"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testUpdateUnsupportedLocaltimestamp() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_localtimestamp SET nationkey = 10"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testUpdateUnsupportedConstraint() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_invalid_function SET nationkey = 10"))).failure().hasMessageContaining("Function 'invalid_function' not registered");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_not_boolean_expression SET nationkey = 10"))).failure().hasMessageContaining("to be of type BOOLEAN, but was integer");
    }

    @Test
    public void testUpdateNotDeterministic() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_not_deterministic VALUES (100, 'POLAND', 0, 'No comment')"))).failure().hasMessageContaining("Check constraint expression should be deterministic");
    }

    @Test
    public void testMergeUpdate() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 5) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2\n"))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 5\n"))).failure().hasMessage("Check constraint violation: (regionkey < 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1, 11) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 5\n"))).failure().hasMessage("Check constraint violation: (regionkey < 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation t USING mock.tiny.nation s ON t.nationkey = s.nationkey\nWHEN MATCHED THEN UPDATE SET regionkey = 10\n"))).failure().hasMessage("Check constraint violation: (regionkey < 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1, 11) t(x) ON regionkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2\n"))).matches("SELECT BIGINT '5'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 11) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 5\n"))).failure().hasMessage("Check constraint violation: (regionkey < 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = NULL\n"))).matches("SELECT BIGINT '3'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 10) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = 13\n"))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 10) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = NULL\n"))).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 10) t(x) ON nationkey IS NULL\nWHEN MATCHED THEN UPDATE SET nationkey = 13\n"))).matches("SELECT BIGINT '0'");
    }

    @Test
    public void testComplexMerge() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 9\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')\n"))).matches("SELECT BIGINT '22'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 10\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 9, 'No comment')\n"))).failure().hasMessage("Check constraint violation: (regionkey < 10)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 9\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 10, 'No comment')\n"))).failure().hasMessage("Check constraint violation: (regionkey < 10)");
    }

    @Test
    public void testMergeCheckMultipleColumns() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_multiple_column_constraint USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 49\nWHEN NOT MATCHED THEN INSERT VALUES (99, 'POLAND', 49, 'No comment')\n"))).matches("SELECT BIGINT '22'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_multiple_column_constraint USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 50\nWHEN NOT MATCHED THEN INSERT VALUES (99, 'POLAND', 49, 'No comment')\n"))).failure().hasMessage("Check constraint violation: ((nationkey < 100) AND (regionkey < 50))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_multiple_column_constraint USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 49\nWHEN NOT MATCHED THEN INSERT VALUES (99, 'POLAND', 50, 'No comment')\n"))).failure().hasMessage("Check constraint violation: ((nationkey < 100) AND (regionkey < 50))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_multiple_column_constraint USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET nationkey = 100\nWHEN NOT MATCHED THEN INSERT VALUES (99, 'POLAND', 49, 'No comment')\n"))).failure().hasMessage("Check constraint violation: ((nationkey < 100) AND (regionkey < 50))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_multiple_column_constraint USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET nationkey = 99\nWHEN NOT MATCHED THEN INSERT VALUES (100, 'POLAND', 50, 'No comment')\n"))).failure().hasMessage("Check constraint violation: ((nationkey < 100) AND (regionkey < 50))");
    }

    @Test
    public void testMergeSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_subquery USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 9\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')\n"))).nonTrinoExceptionFailure().hasMessageContaining("Unexpected subquery expression in logical plan");
    }

    @Test
    public void testMergeUnsupportedCurrentDate() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_current_date USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 9\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')\n"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testMergeUnsupportedCurrentTime() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_current_time USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 9\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')\n"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testMergeUnsupportedCurrentTimestamp() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_current_timestamp USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 9\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')\n"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testMergeUnsupportedLocaltime() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_localtime USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 9\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')\n"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testMergeUnsupportedLocaltimestamp() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_localtimestamp USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 9\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')\n"))).failure().hasMessageContaining("Check constraint expression should not contain temporal expression");
    }

    @Test
    public void testMergeUnsupportedConstraint() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_invalid_function USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 9\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')\n"))).failure().hasMessageContaining("Function 'invalid_function' not registered");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_not_boolean_expression USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 9\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')\n"))).failure().hasMessageContaining("to be of type BOOLEAN, but was integer");
    }

    @Test
    public void testMergeNotDeterministic() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation_not_deterministic USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED AND t.x = 1 THEN DELETE\nWHEN MATCHED THEN UPDATE SET regionkey = 9\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')\n"))).failure().hasMessageContaining("Check constraint expression should be deterministic");
    }
}

