/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestFullJoin {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testFullJoinWithLimit() {
        ((ListAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2) AS l(v) FULL OUTER JOIN (VALUES 2, 1) AS r(v) ON l.v = r.v LIMIT 1"))).result().rows().hasSize(1)).containsAnyElementsOf((Iterable)this.assertions.execute("VALUES (1,1), (2,2)").getMaterializedRows());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2) AS l(v) FULL OUTER JOIN (VALUES 2) AS r(v) ON l.v = r.v ORDER BY l.v NULLS FIRST LIMIT 1"))).matches("VALUES (1, CAST(NULL AS INTEGER))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 2) AS l(v) FULL OUTER JOIN (VALUES 1, 2) AS r(v) ON l.v = r.v ORDER BY r.v NULLS FIRST LIMIT 1"))).matches("VALUES (CAST(NULL AS INTEGER), 1)");
    }
}

