/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.block.BlockAssertions;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBooleanType
extends AbstractTestType {
    public TestBooleanType() {
        super((Type)BooleanType.BOOLEAN, Boolean.class, TestBooleanType.createTestBlock());
    }

    @Test
    public void testBooleanBlockWithoutNullsFromByteArray() {
        byte[] booleanBytes = new byte[4];
        BlockBuilder builder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(booleanBytes.length);
        for (int i = 0; i < booleanBytes.length; ++i) {
            boolean value = i % 2 == 0;
            booleanBytes[i] = value ? (byte)1 : 0;
            BooleanType.BOOLEAN.writeBoolean(builder, value);
        }
        Block wrappedBlock = BooleanType.wrapByteArrayAsBooleanBlockWithoutNulls((byte[])booleanBytes);
        Block builderBlock = builder.build();
        Assertions.assertThat((boolean)wrappedBlock.mayHaveNull()).isFalse();
        Assertions.assertThat((boolean)(wrappedBlock instanceof ByteArrayBlock)).isTrue();
        Assertions.assertThat((boolean)(builderBlock instanceof ByteArrayBlock)).isTrue();
        BlockAssertions.assertBlockEquals((Type)BooleanType.BOOLEAN, wrappedBlock, builderBlock);
        Assertions.assertThat((boolean)BooleanType.BOOLEAN.getBoolean(wrappedBlock, 0)).isTrue();
        booleanBytes[0] = 0;
        Assertions.assertThat((boolean)BooleanType.BOOLEAN.getBoolean(wrappedBlock, 0)).isFalse();
    }

    @Test
    public void testBooleanBlockWithSingleNonNullValue() {
        Assertions.assertThat((boolean)(BooleanType.createBlockForSingleNonNullValue((boolean)true) instanceof ByteArrayBlock)).isTrue();
        Assertions.assertThat((boolean)BooleanType.BOOLEAN.getBoolean(BooleanType.createBlockForSingleNonNullValue((boolean)true), 0)).isTrue();
        Assertions.assertThat((boolean)BooleanType.BOOLEAN.getBoolean(BooleanType.createBlockForSingleNonNullValue((boolean)false), 0)).isFalse();
        Assertions.assertThat((boolean)BooleanType.createBlockForSingleNonNullValue((boolean)false).mayHaveNull()).isFalse();
    }

    public static ValueBlock createTestBlock() {
        BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(null, 15);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, true);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, true);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, true);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, true);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, true);
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return true;
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }
}

