/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestShortDecimalType
extends AbstractTestType {
    private static final DecimalType SHORT_DECIMAL_TYPE = DecimalType.createDecimalType((int)4, (int)2);

    public TestShortDecimalType() {
        super((Type)SHORT_DECIMAL_TYPE, SqlDecimal.class, TestShortDecimalType.createTestBlock());
    }

    public static ValueBlock createTestBlock() {
        BlockBuilder blockBuilder = SHORT_DECIMAL_TYPE.createBlockBuilder(null, 15);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, -1234L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, -1234L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, -1234L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 2321L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 2321L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 2321L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 2321L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 2321L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 3321L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 3321L);
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, 4321L);
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return (Long)value + 1L;
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }
}

