/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.type.AbstractTestType;
import io.trino.type.InternalTypeManager;
import io.trino.util.StructuralTestUtil;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTinyintArrayType
extends AbstractTestType {
    public TestTinyintArrayType() {
        super(InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.arrayType((TypeSignature)TinyintType.TINYINT.getTypeSignature())), List.class, TestTinyintArrayType.createTestBlock(InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.arrayType((TypeSignature)TinyintType.TINYINT.getTypeSignature()))));
    }

    public static ValueBlock createTestBlock(Type arrayType) {
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 4);
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)TinyintType.TINYINT, 1, 2));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)TinyintType.TINYINT, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)TinyintType.TINYINT, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)TinyintType.TINYINT, 100, 110, 127));
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        Block block = (Block)value;
        BlockBuilder blockBuilder = TinyintType.TINYINT.createBlockBuilder(null, block.getPositionCount() + 1);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            TinyintType.TINYINT.appendTo(block, i, blockBuilder);
        }
        TinyintType.TINYINT.writeLong(blockBuilder, 1L);
        return blockBuilder.buildValueBlock();
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }
}

