/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTinyintOperators {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testLiteral() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TINYINT '37'")))).isEqualTo((byte)37);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TINYINT '17'")))).isEqualTo((byte)17);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("TINYINT '128'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
    }

    @Test
    public void testUnaryPlus() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("+TINYINT '37'")))).isEqualTo((byte)37);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("+TINYINT '17'")))).isEqualTo((byte)17);
    }

    @Test
    public void testUnaryMinus() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TINYINT '-37'")))).isEqualTo((byte)-37);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("TINYINT '-17'")))).isEqualTo((byte)-17);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("TINYINT '--128'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
    }

    @Test
    public void testAdd() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "TINYINT '37'", "TINYINT '37'")))).isEqualTo((byte)74);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "TINYINT '37'", "TINYINT '17'")))).isEqualTo((byte)54);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "TINYINT '17'", "TINYINT '37'")))).isEqualTo((byte)54);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "TINYINT '17'", "TINYINT '17'")))).isEqualTo((byte)34);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.ADD, "TINYINT '%s'".formatted((byte)127), "TINYINT '1'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("tinyint addition overflow: 127 + 1");
    }

    @Test
    public void testSubtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "TINYINT '37'", "TINYINT '37'")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "TINYINT '37'", "TINYINT '17'")))).isEqualTo((byte)20);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "TINYINT '17'", "TINYINT '37'")))).isEqualTo((byte)-20);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "TINYINT '17'", "TINYINT '17'")))).isEqualTo((byte)0);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.SUBTRACT, "TINYINT '%s'".formatted((byte)-128), "TINYINT '1'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("tinyint subtraction overflow: -128 - 1");
    }

    @Test
    public void testMultiply() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "TINYINT '11'", "TINYINT '11'")))).isEqualTo((byte)121);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "TINYINT '11'", "TINYINT '9'")))).isEqualTo((byte)99);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "TINYINT '9'", "TINYINT '11'")))).isEqualTo((byte)99);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "TINYINT '9'", "TINYINT '9'")))).isEqualTo((byte)81);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MULTIPLY, "TINYINT '%s'".formatted((byte)127), "TINYINT '2'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("tinyint multiplication overflow: 127 * 2");
    }

    @Test
    public void testDivide() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "TINYINT '37'", "TINYINT '37'")))).isEqualTo((byte)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "TINYINT '37'", "TINYINT '17'")))).isEqualTo((byte)2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "TINYINT '17'", "TINYINT '37'")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "TINYINT '17'", "TINYINT '17'")))).isEqualTo((byte)1);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, "TINYINT '17'", "TINYINT '0'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testModulus() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "TINYINT '37'", "TINYINT '37'")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "TINYINT '37'", "TINYINT '17'")))).isEqualTo((byte)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "TINYINT '17'", "TINYINT '37'")))).isEqualTo((byte)17);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "TINYINT '17'", "TINYINT '17'")))).isEqualTo((byte)0);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MODULUS, "TINYINT '17'", "TINYINT '0'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testNegation() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "(TINYINT '37')")))).isEqualTo((byte)-37);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "(TINYINT '17')")))).isEqualTo((byte)-17);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "TINYINT '127'")))).isEqualTo((byte)-127);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.NEGATION, "TINYINT '-128'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("tinyint negation overflow: -128");
    }

    @Test
    public void testEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "TINYINT '37'", "TINYINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "TINYINT '37'", "TINYINT '17'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "TINYINT '17'", "TINYINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "TINYINT '17'", "TINYINT '17'")))).isEqualTo(true);
    }

    @Test
    public void testNotEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "TINYINT '37'").binding("b", "TINYINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "TINYINT '37'").binding("b", "TINYINT '17'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "TINYINT '17'").binding("b", "TINYINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "TINYINT '17'").binding("b", "TINYINT '17'")))).isEqualTo(false);
    }

    @Test
    public void testLessThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "TINYINT '37'", "TINYINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "TINYINT '37'", "TINYINT '17'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "TINYINT '17'", "TINYINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "TINYINT '17'", "TINYINT '17'")))).isEqualTo(false);
    }

    @Test
    public void testLessThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "TINYINT '37'", "TINYINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "TINYINT '37'", "TINYINT '17'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "TINYINT '17'", "TINYINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "TINYINT '17'", "TINYINT '17'")))).isEqualTo(true);
    }

    @Test
    public void testGreaterThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "TINYINT '37'").binding("b", "TINYINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "TINYINT '37'").binding("b", "TINYINT '17'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "TINYINT '17'").binding("b", "TINYINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "TINYINT '17'").binding("b", "TINYINT '17'")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "TINYINT '37'").binding("b", "TINYINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "TINYINT '37'").binding("b", "TINYINT '17'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "TINYINT '17'").binding("b", "TINYINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "TINYINT '17'").binding("b", "TINYINT '17'")))).isEqualTo(true);
    }

    @Test
    public void testBetween() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "TINYINT '37'").binding("low", "TINYINT '37'").binding("high", "TINYINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "TINYINT '37'").binding("low", "TINYINT '37'").binding("high", "TINYINT '17'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "TINYINT '37'").binding("low", "TINYINT '17'").binding("high", "TINYINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "TINYINT '37'").binding("low", "TINYINT '17'").binding("high", "TINYINT '17'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "TINYINT '17'").binding("low", "TINYINT '37'").binding("high", "TINYINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "TINYINT '17'").binding("low", "TINYINT '37'").binding("high", "TINYINT '17'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "TINYINT '17'").binding("low", "TINYINT '17'").binding("high", "TINYINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "TINYINT '17'").binding("low", "TINYINT '17'").binding("high", "TINYINT '17'")))).isEqualTo(true);
    }

    @Test
    public void testCastToBigint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "TINYINT '37'")))).isEqualTo(37L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "TINYINT '17'")))).isEqualTo(17L);
    }

    @Test
    public void testCastToInteger() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as integer)").binding("a", "TINYINT '37'")))).isEqualTo(37);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as integer)").binding("a", "TINYINT '17'")))).isEqualTo(17);
    }

    @Test
    public void testCastToSmallint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as smallint)").binding("a", "TINYINT '37'")))).isEqualTo((short)37);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as smallint)").binding("a", "TINYINT '17'")))).isEqualTo((short)17);
    }

    @Test
    public void testCastToVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar)").binding("a", "TINYINT '37'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("37");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar)").binding("a", "TINYINT '17'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("17");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(3))").binding("a", "TINYINT '123'")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(50))").binding("a", "TINYINT '123'")))).hasType((Type)VarcharType.createVarcharType((int)50)).isEqualTo("123");
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as varchar(2))").binding("a", "TINYINT '123'").evaluate()).hasMessage("Value 123 cannot be represented as varchar(2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastToDouble() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as double)").binding("a", "TINYINT '37'")))).isEqualTo(37.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as double)").binding("a", "TINYINT '17'")))).isEqualTo(17.0);
    }

    @Test
    public void testCastToFloat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as real)").binding("a", "TINYINT '37'")))).isEqualTo(Float.valueOf(37.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as real)").binding("a", "TINYINT '-128'")))).isEqualTo(Float.valueOf(-128.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as real)").binding("a", "TINYINT '0'")))).isEqualTo(Float.valueOf(0.0f));
    }

    @Test
    public void testCastToBoolean() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as boolean)").binding("a", "TINYINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as boolean)").binding("a", "TINYINT '17'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as boolean)").binding("a", "TINYINT '0'")))).isEqualTo(false);
    }

    @Test
    public void testCastFromVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as tinyint)").binding("a", "'37'")))).isEqualTo((byte)37);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as tinyint)").binding("a", "'17'")))).isEqualTo((byte)17);
    }

    @Test
    public void testIsDistinctFrom() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "CAST(NULL AS TINYINT)", "CAST(NULL AS TINYINT)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "TINYINT '37'", "TINYINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "TINYINT '37'", "TINYINT '38'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "NULL", "TINYINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "TINYINT '37'", "NULL")))).isEqualTo(true);
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(null as tinyint)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(12 as tinyint)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(0 as tinyint)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(-23 as tinyint)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(1.4 as tinyint)")))).isEqualTo(false);
    }
}

