/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTinyintType
extends AbstractTestType {
    public TestTinyintType() {
        super((Type)TinyintType.TINYINT, Byte.class, TestTinyintType.createTestBlock());
    }

    public static ValueBlock createTestBlock() {
        BlockBuilder blockBuilder = TinyintType.TINYINT.createBlockBuilder(null, 15);
        TinyintType.TINYINT.writeLong(blockBuilder, 111L);
        TinyintType.TINYINT.writeLong(blockBuilder, 111L);
        TinyintType.TINYINT.writeLong(blockBuilder, 111L);
        TinyintType.TINYINT.writeLong(blockBuilder, 22L);
        TinyintType.TINYINT.writeLong(blockBuilder, 22L);
        TinyintType.TINYINT.writeLong(blockBuilder, 22L);
        TinyintType.TINYINT.writeLong(blockBuilder, 22L);
        TinyintType.TINYINT.writeLong(blockBuilder, 22L);
        TinyintType.TINYINT.writeLong(blockBuilder, 33L);
        TinyintType.TINYINT.writeLong(blockBuilder, 33L);
        TinyintType.TINYINT.writeLong(blockBuilder, 44L);
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return (Long)value + 1L;
    }

    @Test
    public void testRange() {
        Type.Range range = (Type.Range)this.type.getRange().orElseThrow();
        Assertions.assertThat((Object)range.getMin()).isEqualTo((Object)-128L);
        Assertions.assertThat((Object)range.getMax()).isEqualTo((Object)127L);
    }

    @Test
    public void testPreviousValue() {
        long minValue = -128L;
        long maxValue = 127L;
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)minValue)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)(minValue + 1L))).isEqualTo(Optional.of(minValue));
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEqualTo(Optional.of(110L));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)(maxValue - 1L))).isEqualTo(Optional.of(maxValue - 2L));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)maxValue)).isEqualTo(Optional.of(maxValue - 1L));
    }

    @Test
    public void testNextValue() {
        long minValue = -128L;
        long maxValue = 127L;
        Assertions.assertThat((Optional)this.type.getNextValue((Object)minValue)).isEqualTo(Optional.of(minValue + 1L));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)(minValue + 1L))).isEqualTo(Optional.of(minValue + 2L));
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEqualTo(Optional.of(112L));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)(maxValue - 1L))).isEqualTo(Optional.of(maxValue));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)maxValue)).isEqualTo(Optional.empty());
    }
}

