/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableMap;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.AbstractTestType;
import io.trino.util.StructuralTestUtil;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTinyintVarcharMapType
extends AbstractTestType {
    public TestTinyintVarcharMapType() {
        super((Type)StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)VarcharType.VARCHAR), Map.class, TestTinyintVarcharMapType.createTestBlock((Type)StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)VarcharType.VARCHAR)));
    }

    public static ValueBlock createTestBlock(Type mapType) {
        BlockBuilder blockBuilder = mapType.createBlockBuilder(null, 2);
        mapType.writeObject(blockBuilder, (Object)StructuralTestUtil.sqlMapOf((Type)TinyintType.TINYINT, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)1, (Object)"hi")));
        mapType.writeObject(blockBuilder, (Object)StructuralTestUtil.sqlMapOf((Type)TinyintType.TINYINT, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)1, (Object)"2", (Object)2, (Object)"hello")));
        mapType.writeObject(blockBuilder, (Object)StructuralTestUtil.sqlMapOf((Type)TinyintType.TINYINT, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)1, (Object)"123456789012345", (Object)2, (Object)"hello-world-hello-world-hello-world")));
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getPreviousValue(this.getSampleValue())).isInstanceOf(IllegalStateException.class)).hasMessage("Type is not orderable: " + String.valueOf(this.type));
    }

    @Test
    public void testNextValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getNextValue(this.getSampleValue())).isInstanceOf(IllegalStateException.class)).hasMessage("Type is not orderable: " + String.valueOf(this.type));
    }
}

