/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.SqlVarbinaryTestingUtil;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestUuidOperators {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testRandomUuid() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("uuid()")))).hasType((Type)UuidType.UUID);
    }

    @Test
    public void testVarcharToUUIDCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as UUID)").binding("a", "'00000000-0000-0000-0000-000000000000'")))).hasType((Type)UuidType.UUID).isEqualTo("00000000-0000-0000-0000-000000000000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as UUID)").binding("a", "'12151fd2-7586-11e9-8f9e-2a86e4085a59'")))).hasType((Type)UuidType.UUID).isEqualTo("12151fd2-7586-11e9-8f9e-2a86e4085a59");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as UUID)").binding("a", "'300433ad-b0a1-3b53-a977-91cab582458e'")))).hasType((Type)UuidType.UUID).isEqualTo("300433ad-b0a1-3b53-a977-91cab582458e");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as UUID)").binding("a", "'d3074e99-de12-4b8c-a2a1-b7faf79faba6'")))).hasType((Type)UuidType.UUID).isEqualTo("d3074e99-de12-4b8c-a2a1-b7faf79faba6");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as UUID)").binding("a", "'dfa7eaf8-6a26-5749-8d36-336025df74e8'")))).hasType((Type)UuidType.UUID).isEqualTo("dfa7eaf8-6a26-5749-8d36-336025df74e8");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as UUID)").binding("a", "'12151FD2-7586-11E9-8F9E-2A86E4085A59'")))).hasType((Type)UuidType.UUID).isEqualTo("12151fd2-7586-11e9-8f9e-2a86e4085a59");
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as UUID)").binding("a", "'1-2-3-4-1'").evaluate()).hasMessage("Invalid UUID string length: 9")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as UUID)").binding("a", "'12151fd217586211e938f9e42a86e4085a59'").evaluate()).hasMessage("Cannot cast value to UUID: 12151fd217586211e938f9e42a86e4085a59")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testUUIDToVarcharCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "UUID 'd3074e99-de12-4b8c-a2a1-b7faf79faba6'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("d3074e99-de12-4b8c-a2a1-b7faf79faba6");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS VARCHAR)").binding("a", "UUID 'd3074e99-de12-4b8c-a2a1-b7faf79faba6'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("d3074e99-de12-4b8c-a2a1-b7faf79faba6");
    }

    @Test
    public void testVarbinaryToUUIDCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as UUID)").binding("a", "x'00000000000000000000000000000000'")))).hasType((Type)UuidType.UUID).isEqualTo("00000000-0000-0000-0000-000000000000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as UUID)").binding("a", "x'12151fd2758611e98f9e2a86e4085a59'")))).hasType((Type)UuidType.UUID).isEqualTo("12151fd2-7586-11e9-8f9e-2a86e4085a59");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as UUID)").binding("a", "x'300433adb0a13b53a97791cab582458e'")))).hasType((Type)UuidType.UUID).isEqualTo("300433ad-b0a1-3b53-a977-91cab582458e");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as UUID)").binding("a", "x'd3074e99de124b8ca2a1b7faf79faba6'")))).hasType((Type)UuidType.UUID).isEqualTo("d3074e99-de12-4b8c-a2a1-b7faf79faba6");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as UUID)").binding("a", "x'dfa7eaf86a2657498d36336025df74e8'")))).hasType((Type)UuidType.UUID).isEqualTo("dfa7eaf8-6a26-5749-8d36-336025df74e8");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as UUID)").binding("a", "x'12151fd2758611e98f9e2a86e4085a59'")))).hasType((Type)UuidType.UUID).isEqualTo("12151fd2-7586-11e9-8f9e-2a86e4085a59");
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as UUID)").binding("a", "x'f000001100'").evaluate()).hasMessage("Invalid UUID binary length: 5")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testUUIDToVarbinaryCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARBINARY)").binding("a", "UUID '00000000-0000-0000-0000-000000000000'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"00000000000000000000000000000000"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARBINARY)").binding("a", "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"6B5F5B6567E443B08EE3586CD49F58A0"));
    }

    @Test
    public void testEquals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'", "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'", "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'")))).isEqualTo(true);
    }

    @Test
    public void testDistinctFrom() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'", "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "CAST(NULL AS UUID)", "CAST(NULL AS UUID)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'", "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'", "CAST(NULL AS UUID)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "CAST(NULL AS UUID)", "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'")))).isEqualTo(true);
    }

    @Test
    public void testNotEquals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'").binding("b", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'").binding("b", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'")))).isEqualTo(false);
    }

    @Test
    public void testOrderOperators() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a58'", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a58'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a58'", "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a58'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "UUID 'dfa7eaf8-6a26-5749-8d36-336025df74e8'").binding("b", "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'").binding("b", "UUID 'dfa7eaf8-6a26-5749-8d36-336025df74e8'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a52'").binding("low", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a50'").binding("high", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a52'").binding("low", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a54'").binding("high", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'").binding("low", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a50'").binding("high", "UUID 'dfa7eaf8-6a26-5749-8d36-336025df74e8'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a52'").binding("low", "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'").binding("high", "UUID 'dfa7eaf8-6a26-5749-8d36-336025df74e8'")))).isEqualTo(false);
    }

    @Test
    public void testCompare() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.COMPARISON_UNORDERED_LAST, "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a58'", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'")))).isEqualTo(-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.COMPARISON_UNORDERED_LAST, "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a58'", "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a58'")))).isEqualTo(0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.COMPARISON_UNORDERED_LAST, "UUID 'dfa7eaf8-6a26-5749-8d36-336025df74e8'", "UUID '6b5f5b65-67e4-43b0-8ee3-586cd49f58a0'")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.COMPARISON_UNORDERED_LAST, "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a58'", "UUID 'dfa7eaf8-6a26-5749-8d36-336025df74e8'")))).isEqualTo(-1);
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "CAST(null AS UUID)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'")))).isEqualTo(false);
    }

    @Test
    public void testHash() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.HASH_CODE, "CAST(null AS UUID)")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.HASH_CODE, "UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59'")))).isEqualTo(-6664838859954528709L);
    }
}

