/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.trino.util.Long2LongOpenBigHashMap;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLong2LongOpenBigHashMap {
    @Test
    public void testBasicOps() {
        int expected = 100000;
        Long2LongOpenBigHashMap map = new Long2LongOpenBigHashMap((long)expected);
        map.defaultReturnValue(-1L);
        Assertions.assertThat((boolean)map.isEmpty()).isTrue();
        Assertions.assertThat((int)map.size()).isEqualTo(0);
        Assertions.assertThat((long)map.get(0L)).isEqualTo(-1L);
        Assertions.assertThat((long)map.get(1L)).isEqualTo(-1L);
        List<Long> values = Arrays.asList(Long.MIN_VALUE, -10L, 0L, 10L, Long.MAX_VALUE);
        int count = 0;
        for (long key : values) {
            Assertions.assertThat((long)map.put(key, (long)(++count - 1))).isEqualTo(-1L);
            Assertions.assertThat((boolean)map.isEmpty()).isFalse();
            Assertions.assertThat((int)map.size()).isEqualTo(count);
        }
        count = 0;
        for (long key : values) {
            Assertions.assertThat((boolean)map.replace(key, (long)(++count - 1), (long)count)).isTrue();
            Assertions.assertThat((boolean)map.isEmpty()).isFalse();
            Assertions.assertThat((int)map.size()).isEqualTo(values.size());
        }
        count = 0;
        for (long key : values) {
            Assertions.assertThat((boolean)map.containsKey(key)).isTrue();
            Assertions.assertThat((boolean)map.containsValue((long)(++count))).isTrue();
            Assertions.assertThat((long)map.get(key)).isEqualTo((long)count);
        }
        count = 0;
        for (long key : values) {
            Assertions.assertThat((long)map.remove(key)).isEqualTo((long)(++count));
        }
    }

    @Test
    public void testRehash() {
        long key;
        int initialCapacity = 1;
        Long2LongOpenBigHashMap map = new Long2LongOpenBigHashMap((long)initialCapacity);
        map.defaultReturnValue(-1L);
        for (key = 0L; key < 1000000L; ++key) {
            Assertions.assertThat((long)map.put(key, key + 1L)).isEqualTo(-1L);
        }
        for (key = 0L; key < 1000000L; ++key) {
            Assertions.assertThat((long)map.get(key)).isEqualTo(key + 1L);
        }
        for (key = 1L; key < 1000000L; ++key) {
            map.remove(key);
        }
        map.trim();
        Assertions.assertThat((long)map.get(0L)).isEqualTo(1L);
    }
}

