/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ContainerDef;
import org.testcontainers.containers.ContainerFetchException;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.FailureDetectingExternalResource;
import org.testcontainers.containers.InternetProtocol;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PortForwardingContainer;
import org.testcontainers.containers.SelinuxContext;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.startupcheck.IsRunningStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.MinimumDurationRunningStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.core.CreateContainerCmdModifier;
import org.testcontainers.images.ImagePullPolicy;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.lifecycle.Startables;
import org.testcontainers.lifecycle.TestDescription;
import org.testcontainers.lifecycle.TestLifecycleAware;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.MapperFeature;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.testcontainers.shaded.com.github.dockerjava.core.DefaultDockerClientConfig;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.com.google.common.base.Strings;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;
import org.testcontainers.shaded.com.google.common.collect.Lists;
import org.testcontainers.shaded.com.google.common.hash.Hashing;
import org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;
import org.testcontainers.shaded.org.apache.commons.lang3.SystemUtils;
import org.testcontainers.shaded.org.awaitility.Awaitility;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.CommandLine;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.DockerLoggerFactory;
import org.testcontainers.utility.DockerMachineClient;
import org.testcontainers.utility.DynamicPollInterval;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.PathUtils;
import org.testcontainers.utility.ResourceReaper;
import org.testcontainers.utility.TestcontainersConfiguration;

public class GenericContainer<SELF extends GenericContainer<SELF>>
extends FailureDetectingExternalResource
implements Container<SELF>,
AutoCloseable,
WaitStrategyTarget,
Startable {
    public static final int CONTAINER_RUNNING_TIMEOUT_SEC = 30;
    public static final String INTERNAL_HOST_HOSTNAME = "host.testcontainers.internal";
    static final String HASH_LABEL = "org.testcontainers.hash";
    static final String COPIED_FILES_HASH_LABEL = "org.testcontainers.copied_files.hash";
    @NonNull
    private List<String> extraHosts = new ArrayList<String>();
    @NonNull
    private RemoteDockerImage image;
    @NonNull
    private List<VolumesFrom> volumesFroms = new ArrayList<VolumesFrom>();
    @Deprecated
    @NonNull
    private Map<String, LinkableContainer> linkedContainers = new HashMap<String, LinkableContainer>();
    private StartupCheckStrategy startupCheckStrategy = new IsRunningStartupCheckStrategy();
    private int startupAttempts = 1;
    @Nullable
    private String workingDirectory = null;
    @Nullable
    private Long shmSize;
    @Deprecated
    private Map<MountableFile, String> copyToFileContainerPathMap = new LinkedHashMap<MountableFile, String>();
    @VisibleForTesting
    private Map<Transferable, String> copyToTransferableContainerPathMap = new LinkedHashMap<Transferable, String>();
    protected final Set<Startable> dependencies = new HashSet<Startable>();
    protected DockerClient dockerClient = DockerClientFactory.lazyClient();
    @VisibleForTesting
    String containerId;
    private InspectContainerResponse containerInfo;
    static WaitStrategy DEFAULT_WAIT_STRATEGY = Wait.defaultWaitStrategy();
    @NonNull
    protected WaitStrategy waitStrategy = DEFAULT_WAIT_STRATEGY;
    private List<Consumer<OutputFrame>> logConsumers = new ArrayList<Consumer<OutputFrame>>();
    private static final Set<String> AVAILABLE_IMAGE_NAME_CACHE = new HashSet<String>();
    private static final RateLimiter DOCKER_CLIENT_RATE_LIMITER = RateLimiterBuilder.newBuilder().withRate(1, TimeUnit.SECONDS).withConstantThroughput().build();
    @Nullable
    private Map<String, String> tmpFsMapping;
    private boolean shouldBeReused = false;
    private boolean hostAccessible = false;
    private final Set<CreateContainerCmdModifier> createContainerCmdModifiers = this.loadCreateContainerCmdCustomizers();
    private ContainerDef containerDef;

    ContainerDef createContainerDef() {
        return new ContainerDef();
    }

    ContainerDef getContainerDef() {
        return this.containerDef;
    }

    private Set<CreateContainerCmdModifier> loadCreateContainerCmdCustomizers() {
        ServiceLoader<CreateContainerCmdModifier> containerCmdCustomizers = ServiceLoader.load(CreateContainerCmdModifier.class);
        LinkedHashSet<CreateContainerCmdModifier> loadedCustomizers = new LinkedHashSet<CreateContainerCmdModifier>();
        for (CreateContainerCmdModifier customizer : containerCmdCustomizers) {
            loadedCustomizers.add(customizer);
        }
        return loadedCustomizers;
    }

    public GenericContainer(@NonNull DockerImageName dockerImageName) {
        this(new RemoteDockerImage(dockerImageName));
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName is marked non-null but is null");
        }
    }

    public GenericContainer(@NonNull RemoteDockerImage image) {
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        this.image = image;
        this.containerDef = this.createContainerDef();
        this.containerDef.addNetworkAlias("tc-" + Base58.randomString(8));
        this.containerDef.setImage(image);
    }

    @Deprecated
    public GenericContainer() {
        this(TestcontainersConfiguration.getInstance().getTinyImage());
    }

    public GenericContainer(@NonNull String dockerImageName) {
        this(new RemoteDockerImage(DockerImageName.parse(dockerImageName)));
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName is marked non-null but is null");
        }
    }

    public GenericContainer(@NonNull Future<String> image) {
        this(new RemoteDockerImage(image));
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
    }

    GenericContainer(@NonNull ContainerDef containerDef) {
        if (containerDef == null) {
            throw new NullPointerException("containerDef is marked non-null but is null");
        }
        this.image = containerDef.getImage();
        this.containerDef = containerDef;
    }

    @Override
    public void setImage(Future<String> image) {
        this.image = new RemoteDockerImage(image);
        this.containerDef.setImage(new RemoteDockerImage(image));
    }

    @Override
    public List<Integer> getExposedPorts() {
        ArrayList<Integer> exposedPorts = new ArrayList<Integer>();
        for (ExposedPort exposedPort : this.containerDef.getExposedPorts()) {
            exposedPorts.add(exposedPort.getPort());
        }
        return exposedPorts;
    }

    @Override
    public void setExposedPorts(List<Integer> exposedPorts) {
        this.containerDef.exposedPorts.clear();
        for (Integer exposedPort : exposedPorts) {
            this.containerDef.addExposedTcpPort(exposedPort);
        }
    }

    public SELF dependsOn(Startable ... startables) {
        Collections.addAll(this.dependencies, startables);
        return (SELF)((GenericContainer)this.self());
    }

    public SELF dependsOn(List<? extends Startable> startables) {
        return this.dependsOn((Iterable<? extends Startable>)startables);
    }

    public SELF dependsOn(Iterable<? extends Startable> startables) {
        startables.forEach(this.dependencies::add);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public void start() {
        if (this.containerId != null) {
            return;
        }
        Startables.deepStart(this.dependencies).get();
        this.dockerClient.authConfig();
        this.doStart();
    }

    protected void doStart() {
        try {
            if (this.waitStrategy != DEFAULT_WAIT_STRATEGY) {
                this.containerDef.setWaitStrategy(this.waitStrategy);
            }
            this.configure();
            this.logger().debug("Starting container: {}", (Object)this.getDockerImageName());
            AtomicInteger attempt = new AtomicInteger(0);
            Unreliables.retryUntilSuccess((int)this.startupAttempts, () -> {
                this.logger().debug("Trying to start container: {} (attempt {}/{})", new Object[]{this.getDockerImageName(), attempt.incrementAndGet(), this.startupAttempts});
                this.tryStart();
                return true;
            });
        }
        catch (Exception e) {
            throw new ContainerLaunchException("Container startup failed for image " + this.getDockerImageName(), e);
        }
    }

    protected boolean canBeReused() {
        for (Class<?> type = this.getClass(); type != GenericContainer.class; type = type.getSuperclass()) {
            try {
                Method method = type.getDeclaredMethod("containerIsCreated", String.class);
                if (method.getDeclaringClass() == GenericContainer.class) continue;
                this.logger().warn("{} can't be reused because it overrides {}", this.getClass(), (Object)method.getName());
                return false;
            }
            catch (NoClassDefFoundError | NoSuchMethodException throwable) {
                // empty catch block
            }
        }
        return true;
    }

    private void tryStart() {
        try {
            boolean reusable;
            String dockerImageName = this.getDockerImageName();
            this.logger().debug("Starting container: {}", (Object)dockerImageName);
            Instant startedAt = Instant.now();
            this.logger().info("Creating container for image: {}", (Object)dockerImageName);
            CreateContainerCmd createCommand = this.dockerClient.createContainerCmd(dockerImageName);
            this.applyConfiguration(createCommand);
            createCommand.getLabels().putAll(DockerClientFactory.DEFAULT_LABELS);
            boolean reused = false;
            if (this.shouldBeReused) {
                if (!this.canBeReused()) {
                    throw new IllegalStateException("This container does not support reuse");
                }
                if (TestcontainersConfiguration.getInstance().environmentSupportsReuse()) {
                    createCommand.getLabels().put(COPIED_FILES_HASH_LABEL, Long.toHexString(this.hashCopiedFiles().getValue()));
                    String hash = this.hash(createCommand);
                    this.containerId = this.findContainerForReuse(hash).orElse(null);
                    if (this.containerId != null) {
                        this.logger().info("Reusing container with ID: {} and hash: {}", (Object)this.containerId, (Object)hash);
                        reused = true;
                    } else {
                        this.logger().debug("Can't find a reusable running container with hash: {}", (Object)hash);
                        createCommand.getLabels().put(HASH_LABEL, hash);
                    }
                    reusable = true;
                } else {
                    this.logger().warn("Reuse was requested but the environment does not support the reuse of containers\nTo enable reuse of containers, you must set 'testcontainers.reuse.enable=true' in a file located at {}", (Object)Paths.get(System.getProperty("user.home"), ".testcontainers.properties"));
                    reusable = false;
                }
            } else {
                reusable = false;
            }
            if (!reusable) {
                createCommand = ResourceReaper.instance().register(this, createCommand);
            }
            if (!reused) {
                this.containerId = createCommand.exec().getId();
                this.copyToFileContainerPathMap.forEach(this::copyFileToContainer);
                this.copyToTransferableContainerPathMap.forEach(this::copyFileToContainer);
            }
            this.connectToPortForwardingNetwork(createCommand.getNetworkMode());
            if (!reused) {
                this.containerIsCreated(this.containerId);
                this.logger().info("Container {} is starting: {}", (Object)dockerImageName, (Object)this.containerId);
                this.dockerClient.startContainerCmd(this.containerId).exec();
            } else {
                this.logger().info("Reusing existing container ({}) and not creating a new one", (Object)this.containerId);
            }
            this.logConsumers.forEach(this::followOutput);
            this.containerInfo = Awaitility.await().atMost(5L, TimeUnit.SECONDS).pollInterval(DynamicPollInterval.ofMillis(50L)).pollInSameThread().until(() -> this.dockerClient.inspectContainerCmd(this.containerId).exec(), inspectContainerResponse -> {
                Set exposedAndMappedPorts = inspectContainerResponse.getNetworkSettings().getPorts().getBindings().entrySet().stream().filter(it -> Objects.nonNull(it.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
                return exposedAndMappedPorts.containsAll(this.containerDef.getExposedPorts());
            });
            String emulationWarning = this.checkForEmulation();
            if (emulationWarning != null) {
                this.logger().warn(emulationWarning);
            }
            this.containerIsStarting(this.containerInfo, reused);
            if (!this.startupCheckStrategy.waitUntilStartupSuccessful(this)) {
                throw new IllegalStateException("Container did not start correctly.");
            }
            try {
                this.waitUntilContainerStarted();
            }
            catch (Exception e) {
                this.logger().debug("Wait strategy threw an exception", (Throwable)e);
                InspectContainerResponse inspectContainerResponse2 = null;
                try {
                    inspectContainerResponse2 = this.dockerClient.inspectContainerCmd(this.containerId).exec();
                }
                catch (NotFoundException notFoundException) {
                    this.logger().debug("Container {} not found", (Object)this.containerId, (Object)notFoundException);
                }
                if (inspectContainerResponse2 == null) {
                    throw new IllegalStateException("Wait strategy failed. Container is removed", e);
                }
                InspectContainerResponse.ContainerState state = inspectContainerResponse2.getState();
                if (Boolean.TRUE.equals(state.getDead())) {
                    throw new IllegalStateException("Wait strategy failed. Container is dead", e);
                }
                if (Boolean.TRUE.equals(state.getOOMKilled())) {
                    throw new IllegalStateException("Wait strategy failed. Container crashed with out-of-memory (OOMKilled)", e);
                }
                String error = state.getError();
                if (!StringUtils.isBlank(error)) {
                    throw new IllegalStateException("Wait strategy failed. Container crashed: " + error, e);
                }
                if (!Boolean.TRUE.equals(state.getRunning())) {
                    throw new IllegalStateException("Wait strategy failed. Container exited with code " + state.getExitCode(), e);
                }
                throw e;
            }
            this.logger().info("Container {} started in {}", (Object)dockerImageName, (Object)Duration.between(startedAt, Instant.now()));
            this.containerIsStarted(this.containerInfo, reused);
        }
        catch (Exception e) {
            if (e instanceof UndeclaredThrowableException && e.getCause() instanceof Exception) {
                e = (Exception)e.getCause();
            }
            if (e instanceof InvocationTargetException && e.getCause() instanceof Exception) {
                e = (Exception)e.getCause();
            }
            this.logger().error("Could not start container", (Throwable)e);
            if (this.containerId != null) {
                String containerLogs = this.getLogs();
                if (containerLogs.length() > 0) {
                    this.logger().error("Log output from the failed container:\n{}", (Object)this.getLogs());
                } else {
                    this.logger().error("There are no stdout/stderr logs available for the failed container");
                }
            }
            throw new ContainerLaunchException("Could not create/start container", e);
        }
    }

    @VisibleForTesting
    Checksum hashCopiedFiles() {
        Adler32 checksum = new Adler32();
        Stream.of(this.copyToFileContainerPathMap, this.copyToTransferableContainerPathMap).flatMap(it -> it.entrySet().stream()).sorted(Map.Entry.comparingByValue()).forEach(entry -> {
            byte[] pathBytes = ((String)entry.getValue()).getBytes();
            checksum.update(pathBytes, 0, pathBytes.length);
            ((Transferable)entry.getKey()).updateChecksum(checksum);
        });
        return checksum;
    }

    final String hash(CreateContainerCmd createCommand) {
        DefaultDockerClientConfig dockerClientConfig = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
        byte[] commandJson = dockerClientConfig.getObjectMapper().copy().enable(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY).enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS).writeValueAsBytes(createCommand);
        return Hashing.sha1().hashBytes(commandJson).toString();
    }

    @VisibleForTesting
    Optional<String> findContainerForReuse(String hash) {
        return ((List)this.dockerClient.listContainersCmd().withLabelFilter(ImmutableMap.of(HASH_LABEL, hash)).withLimit(Integer.valueOf(1)).withStatusFilter(Arrays.asList("running")).exec()).stream().findAny().map(it -> it.getId());
    }

    private HostConfig buildHostConfig(HostConfig config) {
        if (this.shmSize != null) {
            config.withShmSize(this.shmSize);
        }
        if (this.tmpFsMapping != null) {
            config.withTmpFs(this.tmpFsMapping);
        }
        return config;
    }

    private void connectToPortForwardingNetwork(String networkMode) {
        PortForwardingContainer.INSTANCE.getNetwork().map(ContainerNetwork::getNetworkID).ifPresent(networkId -> {
            if (!Arrays.asList(networkId, "none", "host").contains(networkMode)) {
                this.dockerClient.connectToNetworkCmd().withContainerId(this.containerId).withNetworkId(networkId).exec();
            }
        });
    }

    @Override
    public void stop() {
        if (this.containerId == null) {
            return;
        }
        try {
            String imageName;
            try {
                imageName = this.getDockerImageName();
            }
            catch (Exception e) {
                imageName = "<unknown>";
            }
            this.containerIsStopping(this.containerInfo);
            ResourceReaper.instance().stopAndRemoveContainer(this.containerId, imageName);
            this.containerIsStopped(this.containerInfo);
        }
        finally {
            this.containerId = null;
            this.containerInfo = null;
        }
    }

    protected Logger logger() {
        return DockerLoggerFactory.getLogger(this.getDockerImageName());
    }

    @Deprecated
    protected Path createVolumeDirectory(boolean temporary) {
        Path directory = new File(".tmp-volume-" + UUID.randomUUID()).toPath();
        PathUtils.mkdirp(directory);
        if (temporary) {
            Runtime.getRuntime().addShutdownHook(new Thread(DockerClientFactory.TESTCONTAINERS_THREAD_GROUP, () -> PathUtils.recursiveDeleteDir(directory)));
        }
        return directory;
    }

    protected void configure() {
    }

    protected void containerIsCreated(String containerId) {
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        this.containerIsStarting(containerInfo);
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo, boolean reused) {
        this.containerIsStarted(containerInfo);
    }

    protected void containerIsStopping(InspectContainerResponse containerInfo) {
    }

    protected void containerIsStopped(InspectContainerResponse containerInfo) {
    }

    @Deprecated
    protected Integer getLivenessCheckPort() {
        Iterator<ExposedPort> exposedPortsIterator = this.containerDef.getExposedPorts().iterator();
        if (exposedPortsIterator.hasNext()) {
            return this.getMappedPort(exposedPortsIterator.next().getPort());
        }
        if (!this.containerDef.getPortBindings().isEmpty()) {
            return Integer.valueOf(this.containerDef.getPortBindings().iterator().next().getBinding().getHostPortSpec());
        }
        return null;
    }

    @Deprecated
    @NotNull
    @NonNull
    protected Set<Integer> getLivenessCheckPorts() {
        Set<Integer> result = WaitStrategyTarget.super.getLivenessCheckPortNumbers();
        if (this.getLivenessCheckPort() != null) {
            result.add(this.getLivenessCheckPort());
        }
        return result;
    }

    @Override
    public Set<Integer> getLivenessCheckPortNumbers() {
        return this.getLivenessCheckPorts();
    }

    private void applyConfiguration(CreateContainerCmd createCommand) {
        Optional networkForLinks;
        this.containerDef.applyTo(createCommand);
        this.buildHostConfig(createCommand.getHostConfig());
        VolumesFrom[] volumesFromsArray = (VolumesFrom[])this.volumesFroms.stream().toArray(VolumesFrom[]::new);
        createCommand.withVolumesFrom(volumesFromsArray);
        HashSet<Link> allLinks = new HashSet<Link>();
        HashSet<String> allLinkedContainerNetworks = new HashSet<String>();
        for (Map.Entry<String, LinkableContainer> linkEntries : this.linkedContainers.entrySet()) {
            String alias = linkEntries.getKey();
            LinkableContainer linkableContainer = linkEntries.getValue();
            Set<Link> links = this.findLinksFromThisContainer(alias, linkableContainer);
            allLinks.addAll(links);
            if (allLinks.size() == 0) {
                throw new ContainerLaunchException("Aborting attempt to link to container " + linkableContainer.getContainerName() + " as it is not running");
            }
            Set<String> linkedContainerNetworks = this.findAllNetworksForLinkedContainers(linkableContainer);
            allLinkedContainerNetworks.addAll(linkedContainerNetworks);
        }
        createCommand.withLinks(allLinks.toArray(new Link[allLinks.size()]));
        allLinkedContainerNetworks.remove("bridge");
        if (allLinkedContainerNetworks.size() > 1) {
            this.logger().warn("Container needs to be on more than one custom network to link to other containers - this is not currently supported. Required networks are: {}", allLinkedContainerNetworks);
        }
        if ((networkForLinks = allLinkedContainerNetworks.stream().findFirst()).isPresent()) {
            this.logger().debug("Associating container with network: {}", networkForLinks.get());
            createCommand.withNetworkMode((String)networkForLinks.get());
        }
        if (this.hostAccessible) {
            PortForwardingContainer.INSTANCE.start();
        }
        PortForwardingContainer.INSTANCE.getNetwork().ifPresent(it -> this.withExtraHost(INTERNAL_HOST_HOSTNAME, it.getIpAddress()));
        String[] extraHostsArray = (String[])this.extraHosts.stream().toArray(String[]::new);
        createCommand.withExtraHosts(extraHostsArray);
        if (this.workingDirectory != null) {
            createCommand.withWorkingDir(this.workingDirectory);
        }
        for (CreateContainerCmdModifier createContainerCmdModifier : this.createContainerCmdModifiers) {
            createCommand = createContainerCmdModifier.modify(createCommand);
        }
    }

    private Set<Link> findLinksFromThisContainer(String alias, LinkableContainer linkableContainer) {
        return ((List)this.dockerClient.listContainersCmd().withStatusFilter(Arrays.asList("running")).exec()).stream().flatMap(container -> Stream.of(container.getNames())).filter(name -> name.endsWith(linkableContainer.getContainerName())).map(name -> new Link(name, alias)).collect(Collectors.toSet());
    }

    private Set<String> findAllNetworksForLinkedContainers(LinkableContainer linkableContainer) {
        return ((List)this.dockerClient.listContainersCmd().exec()).stream().filter(container -> container.getNames()[0].endsWith(linkableContainer.getContainerName())).filter(container -> container.getNetworkSettings() != null && container.getNetworkSettings().getNetworks() != null).flatMap(container -> container.getNetworkSettings().getNetworks().keySet().stream()).distinct().collect(Collectors.toSet());
    }

    @Override
    public SELF waitingFor(@NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy is marked non-null but is null");
        }
        this.waitStrategy = waitStrategy;
        return (SELF)((GenericContainer)this.self());
    }

    protected WaitStrategy getWaitStrategy() {
        return this.waitStrategy == DEFAULT_WAIT_STRATEGY ? this.containerDef.getWaitStrategy() : this.waitStrategy;
    }

    @Override
    public void setWaitStrategy(WaitStrategy waitStrategy) {
        this.containerDef.setWaitStrategy(waitStrategy);
    }

    protected void waitUntilContainerStarted() {
        WaitStrategy waitStrategy = this.getWaitStrategy();
        if (waitStrategy != null) {
            waitStrategy.waitUntilReady(this);
        }
    }

    private String checkForEmulation() {
        try {
            DockerClient dockerClient = DockerClientFactory.instance().client();
            String imageId = this.getContainerInfo().getImageId();
            String imageArch = dockerClient.inspectImageCmd(imageId).exec().getArch();
            String serverArch = ((Version)dockerClient.versionCmd().exec()).getArch();
            if (!serverArch.equals(imageArch)) {
                return "The architecture '" + imageArch + "' for image '" + this.getDockerImageName() + "' (ID " + imageId + ") does not match the Docker server architecture '" + serverArch + "'. This will cause the container to execute much more slowly due to emulation and may lead to timeout failures.";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setCommand(@NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.containerDef.setCommand(command.split(" "));
    }

    @Override
    public void setCommand(String ... commandParts) {
        if (commandParts == null) {
            throw new NullPointerException("commandParts is marked non-null but is null");
        }
        this.containerDef.setCommand(commandParts);
    }

    @Override
    public Map<String, String> getEnvMap() {
        return this.containerDef.envVars;
    }

    @Override
    public List<String> getEnv() {
        return this.containerDef.getEnvVars().entrySet().stream().map(it -> (String)it.getKey() + "=" + (String)it.getValue()).collect(Collectors.toList());
    }

    @Override
    public void setEnv(List<String> env) {
        this.containerDef.setEnvVars(env.stream().map(it -> it.split("=")).collect(Collectors.toMap(it -> it[0], it -> it[1])));
    }

    @Override
    public void addEnv(String key, String value) {
        this.containerDef.addEnvVar(key, value);
    }

    @Override
    public void addFileSystemBind(String hostPath, String containerPath, BindMode mode, SelinuxContext selinuxContext) {
        if (SystemUtils.IS_OS_WINDOWS && hostPath.startsWith("/")) {
            this.containerDef.addBinds(new Bind(hostPath, new Volume(containerPath), mode.accessMode, selinuxContext.selContext));
        } else {
            MountableFile mountableFile = MountableFile.forHostPath(hostPath);
            this.containerDef.addBinds(new Bind(mountableFile.getResolvedPath(), new Volume(containerPath), mode.accessMode, selinuxContext.selContext));
        }
    }

    @Override
    public SELF withFileSystemBind(String hostPath, String containerPath, BindMode mode) {
        this.addFileSystemBind(hostPath, containerPath, mode);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withVolumesFrom(Container container, BindMode mode) {
        this.addVolumesFrom(container, mode);
        return (SELF)((GenericContainer)this.self());
    }

    private void addVolumesFrom(Container container, BindMode mode) {
        this.volumesFroms.add(new VolumesFrom(container.getContainerName(), mode.accessMode));
    }

    @Override
    @Deprecated
    public void addLink(LinkableContainer otherContainer, String alias) {
        this.linkedContainers.put(alias, otherContainer);
    }

    @Override
    public void addExposedPort(Integer port) {
        this.containerDef.addExposedTcpPort(port);
    }

    @Override
    public void addExposedPorts(int ... ports) {
        this.containerDef.addExposedTcpPorts(ports);
    }

    private TestDescription toDescription(final Description description) {
        return new TestDescription(){

            @Override
            public String getTestId() {
                return description.getDisplayName();
            }

            @Override
            public String getFilesystemFriendlyName() {
                return description.getClassName() + "-" + description.getMethodName();
            }
        };
    }

    @Override
    @Deprecated
    public Statement apply(Statement base, Description description) {
        return super.apply(base, description);
    }

    @Override
    @Deprecated
    protected void starting(Description description) {
        if (this instanceof TestLifecycleAware) {
            ((TestLifecycleAware)((Object)this)).beforeTest(this.toDescription(description));
        }
        this.start();
    }

    @Override
    @Deprecated
    protected void succeeded(Description description) {
        if (this instanceof TestLifecycleAware) {
            ((TestLifecycleAware)((Object)this)).afterTest(this.toDescription(description), Optional.empty());
        }
    }

    @Override
    @Deprecated
    protected void failed(Throwable e, Description description) {
        if (this instanceof TestLifecycleAware) {
            ((TestLifecycleAware)((Object)this)).afterTest(this.toDescription(description), Optional.of(e));
        }
    }

    @Override
    @Deprecated
    protected void finished(Description description) {
        this.stop();
    }

    @Override
    public SELF withExposedPorts(Integer ... ports) {
        this.setExposedPorts(Lists.newArrayList(ports));
        return (SELF)((GenericContainer)this.self());
    }

    protected void addFixedExposedPort(int hostPort, int containerPort) {
        this.addFixedExposedPort(hostPort, containerPort, InternetProtocol.TCP);
    }

    protected void addFixedExposedPort(int hostPort, int containerPort, InternetProtocol protocol) {
        ExposedPort exposedPort = new ExposedPort(containerPort, com.github.dockerjava.api.model.InternetProtocol.parse((String)protocol.name()));
        PortBinding portBinding = new PortBinding(Ports.Binding.bindPort((int)hostPort), exposedPort);
        this.containerDef.addPortBindings(portBinding);
    }

    @Override
    public SELF withEnv(String key, String value) {
        this.addEnv(key, value);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withEnv(Map<String, String> env) {
        env.forEach(this.containerDef::addEnvVar);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withLabel(String key, String value) {
        if (key.startsWith("org.testcontainers")) {
            throw new IllegalArgumentException("The org.testcontainers namespace is reserved for interal use");
        }
        this.containerDef.addLabel(key, value);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withLabels(Map<String, String> labels) {
        labels.forEach((string, string2) -> this.withLabel((String)string, (String)string2));
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withCommand(String cmd) {
        this.setCommand(cmd);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withCommand(String ... commandParts) {
        this.setCommand(commandParts);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withExtraHost(String hostname, String ipAddress) {
        this.extraHosts.add(String.format("%s:%s", hostname, ipAddress));
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withNetworkMode(String networkMode) {
        this.containerDef.setNetworkMode(networkMode);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withNetwork(Network network) {
        this.containerDef.setNetwork(network);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withNetworkAliases(String ... aliases) {
        this.containerDef.addNetworkAliases(aliases);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        this.image = this.image.withImagePullPolicy(imagePullPolicy);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withClasspathResourceMapping(String resourcePath, String containerPath, BindMode mode) {
        return (SELF)this.withClasspathResourceMapping(resourcePath, containerPath, mode, SelinuxContext.SHARED);
    }

    @Override
    public SELF withClasspathResourceMapping(String resourcePath, String containerPath, BindMode mode, SelinuxContext selinuxContext) {
        MountableFile mountableFile = MountableFile.forClasspathResource(resourcePath);
        if (mode == BindMode.READ_WRITE) {
            this.addFileSystemBind(mountableFile.getResolvedPath(), containerPath, mode, selinuxContext);
        } else {
            this.withCopyFileToContainer(mountableFile, containerPath);
        }
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withStartupTimeout(Duration startupTimeout) {
        this.getWaitStrategy().withStartupTimeout(startupTimeout);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withPrivilegedMode(boolean mode) {
        this.containerDef.setPrivilegedMode(mode);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withMinimumRunningDuration(Duration minimumRunningDuration) {
        this.startupCheckStrategy = new MinimumDurationRunningStartupCheckStrategy(minimumRunningDuration);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withStartupCheckStrategy(StartupCheckStrategy strategy) {
        this.startupCheckStrategy = strategy;
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withWorkingDirectory(String workDir) {
        this.setWorkingDirectory(workDir);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withCopyFileToContainer(MountableFile mountableFile, String containerPath) {
        if (this.copyToFileContainerPathMap.containsKey(mountableFile)) {
            throw new IllegalStateException("Path already configured for copy: " + mountableFile);
        }
        this.copyToFileContainerPathMap.put(mountableFile, containerPath);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withCopyToContainer(Transferable transferable, String containerPath) {
        this.copyToTransferableContainerPathMap.put(transferable, containerPath);
        return (SELF)((GenericContainer)this.self());
    }

    @Deprecated
    public String getIpAddress() {
        return this.getHost();
    }

    @Override
    public void setDockerImageName(@NonNull String dockerImageName) {
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName is marked non-null but is null");
        }
        this.image = new RemoteDockerImage(dockerImageName);
    }

    @Override
    @NonNull
    public String getDockerImageName() {
        try {
            return (String)this.image.get();
        }
        catch (Exception e) {
            throw new ContainerFetchException("Can't get Docker image: " + this.image, e);
        }
    }

    @Override
    @Deprecated
    public String getTestHostIpAddress() {
        if (DockerMachineClient.instance().isInstalled()) {
            try {
                Optional<String> defaultMachine = DockerMachineClient.instance().getDefaultMachine();
                if (!defaultMachine.isPresent()) {
                    throw new IllegalStateException("Could not find a default docker-machine instance");
                }
                String sshConnectionString = CommandLine.runShellCommand("docker-machine", "ssh", defaultMachine.get(), "echo $SSH_CONNECTION").trim();
                if (Strings.isNullOrEmpty(sshConnectionString)) {
                    throw new IllegalStateException("Could not obtain SSH_CONNECTION environment variable for docker machine " + defaultMachine.get());
                }
                String[] sshConnectionParts = sshConnectionString.split("\\s");
                if (sshConnectionParts.length != 4) {
                    throw new IllegalStateException("Unexpected pattern for SSH_CONNECTION for docker machine - expected 'IP PORT IP PORT' pattern but found '" + sshConnectionString + "'");
                }
                return sshConnectionParts[0];
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new UnsupportedOperationException("getTestHostIpAddress() is only implemented for docker-machine right now");
    }

    @Override
    public SELF withLogConsumer(Consumer<OutputFrame> consumer) {
        this.logConsumers.add(consumer);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public void copyFileFromContainer(String containerPath, String destinationPath) {
        Container.super.copyFileFromContainer(containerPath, destinationPath);
    }

    public SELF withStartupAttempts(int attempts) {
        this.startupAttempts = attempts;
        return (SELF)((GenericContainer)this.self());
    }

    public SELF withCreateContainerCmdModifier(Consumer<CreateContainerCmd> modifier) {
        this.createContainerCmdModifiers.add(cmd -> {
            modifier.accept(cmd);
            return cmd;
        });
        return (SELF)((GenericContainer)this.self());
    }

    public SELF withSharedMemorySize(Long bytes) {
        this.shmSize = bytes;
        return (SELF)((GenericContainer)this.self());
    }

    public SELF withTmpFs(Map<String, String> mapping) {
        this.tmpFsMapping = mapping;
        return (SELF)((GenericContainer)this.self());
    }

    public SELF withReuse(boolean reusable) {
        this.shouldBeReused = reusable;
        return (SELF)((GenericContainer)this.self());
    }

    public SELF withAccessToHost(boolean value) {
        this.hostAccessible = value;
        return (SELF)((GenericContainer)this.self());
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String getContainerName() {
        return this.getContainerInfo().getName();
    }

    public Network getNetwork() {
        return this.containerDef.getNetwork();
    }

    @Override
    public List<Bind> getBinds() {
        return this.containerDef.binds;
    }

    @Override
    public void setBinds(List<Bind> binds) {
        this.containerDef.setBinds(binds);
    }

    @Override
    public String[] getCommandParts() {
        return this.containerDef.getCommand();
    }

    @Override
    public void setCommandParts(String[] commandParts) {
        this.containerDef.setCommand(commandParts);
    }

    public List<String> getNetworkAliases() {
        return new ArrayList<String>(this.containerDef.getNetworkAliases());
    }

    public void setNetworkAliases(List<String> aliases) {
        this.containerDef.setNetworkAliases(new HashSet<String>(aliases));
    }

    @Override
    public List<String> getPortBindings() {
        return this.containerDef.portBindings.stream().map(it -> String.format("%s:%s", it.getBinding(), it.getExposedPort())).collect(Collectors.toList());
    }

    @Override
    public void setPortBindings(List<String> portBindings) {
        this.containerDef.setPortBindings(portBindings.stream().map(PortBinding::parse).collect(Collectors.toSet()));
    }

    public void setPrivilegedMode(boolean mode) {
        this.containerDef.setPrivilegedMode(mode);
    }

    public boolean isPrivilegedMode() {
        return this.containerDef.isPrivilegedMode();
    }

    public Map<String, String> getLabels() {
        return this.containerDef.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.containerDef.setLabels(labels);
    }

    public String getNetworkMode() {
        return this.containerDef.getNetworkMode();
    }

    public void setNetworkMode(String networkMode) {
        this.containerDef.setNetworkMode(networkMode);
    }

    public void setNetwork(Network network) {
        this.containerDef.setNetwork(network);
    }

    @Override
    @NonNull
    public List<String> getExtraHosts() {
        return this.extraHosts;
    }

    @NonNull
    public RemoteDockerImage getImage() {
        return this.image;
    }

    @NonNull
    public List<VolumesFrom> getVolumesFroms() {
        return this.volumesFroms;
    }

    @Override
    @Deprecated
    @NonNull
    public Map<String, LinkableContainer> getLinkedContainers() {
        return this.linkedContainers;
    }

    public StartupCheckStrategy getStartupCheckStrategy() {
        return this.startupCheckStrategy;
    }

    public int getStartupAttempts() {
        return this.startupAttempts;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Nullable
    public Long getShmSize() {
        return this.shmSize;
    }

    @Deprecated
    public Map<MountableFile, String> getCopyToFileContainerPathMap() {
        return this.copyToFileContainerPathMap;
    }

    @Override
    public Set<Startable> getDependencies() {
        return this.dependencies;
    }

    @Override
    public DockerClient getDockerClient() {
        return this.dockerClient;
    }

    @Override
    public InspectContainerResponse getContainerInfo() {
        return this.containerInfo;
    }

    public List<Consumer<OutputFrame>> getLogConsumers() {
        return this.logConsumers;
    }

    @Nullable
    public Map<String, String> getTmpFsMapping() {
        return this.tmpFsMapping;
    }

    public boolean isShouldBeReused() {
        return this.shouldBeReused;
    }

    public boolean isHostAccessible() {
        return this.hostAccessible;
    }

    public Set<CreateContainerCmdModifier> getCreateContainerCmdModifiers() {
        return this.createContainerCmdModifiers;
    }

    @Override
    public void setExtraHosts(@NonNull List<String> extraHosts) {
        if (extraHosts == null) {
            throw new NullPointerException("extraHosts is marked non-null but is null");
        }
        this.extraHosts = extraHosts;
    }

    public void setVolumesFroms(@NonNull List<VolumesFrom> volumesFroms) {
        if (volumesFroms == null) {
            throw new NullPointerException("volumesFroms is marked non-null but is null");
        }
        this.volumesFroms = volumesFroms;
    }

    @Override
    @Deprecated
    public void setLinkedContainers(@NonNull Map<String, LinkableContainer> linkedContainers) {
        if (linkedContainers == null) {
            throw new NullPointerException("linkedContainers is marked non-null but is null");
        }
        this.linkedContainers = linkedContainers;
    }

    public void setStartupCheckStrategy(StartupCheckStrategy startupCheckStrategy) {
        this.startupCheckStrategy = startupCheckStrategy;
    }

    public void setStartupAttempts(int startupAttempts) {
        this.startupAttempts = startupAttempts;
    }

    public void setWorkingDirectory(@Nullable String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setShmSize(@Nullable Long shmSize) {
        this.shmSize = shmSize;
    }

    @Deprecated
    public void setCopyToFileContainerPathMap(Map<MountableFile, String> copyToFileContainerPathMap) {
        this.copyToFileContainerPathMap = copyToFileContainerPathMap;
    }

    public void setLogConsumers(List<Consumer<OutputFrame>> logConsumers) {
        this.logConsumers = logConsumers;
    }

    public void setTmpFsMapping(@Nullable Map<String, String> tmpFsMapping) {
        this.tmpFsMapping = tmpFsMapping;
    }

    public void setHostAccessible(boolean hostAccessible) {
        this.hostAccessible = hostAccessible;
    }

    public void setContainerDef(ContainerDef containerDef) {
        this.containerDef = containerDef;
    }

    public String toString() {
        return "GenericContainer(extraHosts=" + this.getExtraHosts() + ", image=" + this.getImage() + ", volumesFroms=" + this.getVolumesFroms() + ", linkedContainers=" + this.getLinkedContainers() + ", startupCheckStrategy=" + this.getStartupCheckStrategy() + ", startupAttempts=" + this.getStartupAttempts() + ", workingDirectory=" + this.getWorkingDirectory() + ", shmSize=" + this.getShmSize() + ", copyToFileContainerPathMap=" + this.getCopyToFileContainerPathMap() + ", copyToTransferableContainerPathMap=" + this.getCopyToTransferableContainerPathMap() + ", dependencies=" + this.getDependencies() + ", dockerClient=" + this.getDockerClient() + ", containerId=" + this.getContainerId() + ", containerInfo=" + this.getContainerInfo() + ", waitStrategy=" + this.getWaitStrategy() + ", logConsumers=" + this.getLogConsumers() + ", tmpFsMapping=" + this.getTmpFsMapping() + ", shouldBeReused=" + this.isShouldBeReused() + ", hostAccessible=" + this.isHostAccessible() + ", createContainerCmdModifiers=" + this.getCreateContainerCmdModifiers() + ", containerDef=" + this.getContainerDef() + ")";
    }

    Map<Transferable, String> getCopyToTransferableContainerPathMap() {
        return this.copyToTransferableContainerPathMap;
    }
}

