/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images;

import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.images.AgeBasedPullPolicy;
import org.testcontainers.images.AlwaysPullPolicy;
import org.testcontainers.images.DefaultPullPolicy;
import org.testcontainers.images.ImagePullPolicy;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.utility.TestcontainersConfiguration;

public final class PullPolicy {
    private static final Logger log = LoggerFactory.getLogger(PullPolicy.class);
    @VisibleForTesting
    static ImagePullPolicy instance;
    @VisibleForTesting
    static ImagePullPolicy defaultImplementation;

    public static synchronized ImagePullPolicy defaultPolicy() {
        if (instance != null) {
            return instance;
        }
        String imagePullPolicyClassName = TestcontainersConfiguration.getInstance().getImagePullPolicy();
        if (imagePullPolicyClassName != null) {
            ImagePullPolicy configuredInstance;
            log.debug("Attempting to instantiate an ImagePullPolicy with class: {}", (Object)imagePullPolicyClassName);
            try {
                configuredInstance = (ImagePullPolicy)Thread.currentThread().getContextClassLoader().loadClass(imagePullPolicyClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Configured ImagePullPolicy could not be loaded: " + imagePullPolicyClassName, e);
            }
            log.info("Found configured Image Pull Policy: {}", configuredInstance.getClass());
            instance = configuredInstance;
        } else {
            instance = defaultImplementation;
        }
        log.info("Image pull policy will be performed by: {}", (Object)instance);
        return instance;
    }

    public static ImagePullPolicy alwaysPull() {
        return new AlwaysPullPolicy();
    }

    public static ImagePullPolicy ageBased(Duration maxAge) {
        return new AgeBasedPullPolicy(maxAge);
    }

    private PullPolicy() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        defaultImplementation = new DefaultPullPolicy();
    }
}

