/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.exec;

import com.github.dockerjava.api.command.ListSecretsCmd;
import com.github.dockerjava.api.model.Secret;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.MediaType;
import org.testcontainers.shaded.com.github.dockerjava.core.WebTarget;
import org.testcontainers.shaded.com.github.dockerjava.core.exec.AbstrSyncDockerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.core.util.FiltersEncoder;

public class ListSecretsCmdExec
extends AbstrSyncDockerCmdExec<ListSecretsCmd, List<Secret>>
implements ListSecretsCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListSecretsCmdExec.class);

    public ListSecretsCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<Secret> execute(ListSecretsCmd command) {
        WebTarget webTarget = this.getBaseResource().path("/secrets");
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", FiltersEncoder.jsonEncode(command.getFilters()));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List<Secret> secrets = webTarget.request().accept(MediaType.APPLICATION_JSON).get(new TypeReference<List<Secret>>(){});
        LOGGER.trace("Response: {}", secrets);
        return secrets;
    }
}

