/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.crypto.digests;

import org.testcontainers.shaded.org.bouncycastle.crypto.CryptoServicePurpose;
import org.testcontainers.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.testcontainers.shaded.org.bouncycastle.crypto.ExtendedDigest;
import org.testcontainers.shaded.org.bouncycastle.crypto.OutputLengthException;
import org.testcontainers.shaded.org.bouncycastle.crypto.digests.Utils;
import org.testcontainers.shaded.org.bouncycastle.util.Arrays;
import org.testcontainers.shaded.org.bouncycastle.util.Longs;
import org.testcontainers.shaded.org.bouncycastle.util.Pack;

public class Blake2bDigest
implements ExtendedDigest {
    private static final long[] blake2b_IV = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};
    private static final byte[][] blake2b_sigma = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}, {11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4}, {7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8}, {9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13}, {2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9}, {12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11}, {13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10}, {6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5}, {10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}};
    private static int ROUNDS = 12;
    private static final int BLOCK_LENGTH_BYTES = 128;
    private int digestLength = 64;
    private int keyLength = 0;
    private byte[] salt = null;
    private byte[] personalization = null;
    private byte[] key = null;
    private int fanout = 1;
    private int depth = 1;
    private int leafLength = 0;
    private long nodeOffset = 0L;
    private int nodeDepth = 0;
    private int innerHashLength = 0;
    private boolean isLastNode = false;
    private byte[] buffer = null;
    private int bufferPos = 0;
    private long[] internalState = new long[16];
    private long[] chainValue = null;
    private long t0 = 0L;
    private long t1 = 0L;
    private long f0 = 0L;
    private long f1 = 0L;
    private final CryptoServicePurpose purpose;

    public Blake2bDigest() {
        this(512, CryptoServicePurpose.ANY);
    }

    public Blake2bDigest(int n) {
        this(n, CryptoServicePurpose.ANY);
    }

    public Blake2bDigest(Blake2bDigest blake2bDigest) {
        this.bufferPos = blake2bDigest.bufferPos;
        this.buffer = Arrays.clone(blake2bDigest.buffer);
        this.keyLength = blake2bDigest.keyLength;
        this.key = Arrays.clone(blake2bDigest.key);
        this.digestLength = blake2bDigest.digestLength;
        this.chainValue = Arrays.clone(blake2bDigest.chainValue);
        this.personalization = Arrays.clone(blake2bDigest.personalization);
        this.salt = Arrays.clone(blake2bDigest.salt);
        this.t0 = blake2bDigest.t0;
        this.t1 = blake2bDigest.t1;
        this.f0 = blake2bDigest.f0;
        this.purpose = blake2bDigest.purpose;
    }

    public Blake2bDigest(int n, CryptoServicePurpose cryptoServicePurpose) {
        this.purpose = cryptoServicePurpose;
        if (n < 8 || n > 512 || n % 8 != 0) {
            throw new IllegalArgumentException("BLAKE2b digest bit length must be a multiple of 8 and not greater than 512");
        }
        this.buffer = new byte[128];
        this.keyLength = 0;
        this.digestLength = n / 8;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties(this, n, cryptoServicePurpose));
        this.init();
    }

    public Blake2bDigest(byte[] byArray) {
        this(byArray, CryptoServicePurpose.ANY);
    }

    public Blake2bDigest(byte[] byArray, CryptoServicePurpose cryptoServicePurpose) {
        this.buffer = new byte[128];
        if (byArray != null) {
            this.key = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.key, 0, byArray.length);
            if (byArray.length > 64) {
                throw new IllegalArgumentException("Keys > 64 are not supported");
            }
            this.keyLength = byArray.length;
            System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
            this.bufferPos = 128;
        }
        this.purpose = cryptoServicePurpose;
        this.digestLength = 64;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties(this, this.digestLength * 8, cryptoServicePurpose));
        this.init();
    }

    public Blake2bDigest(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) {
        this(byArray, n, byArray2, byArray3, CryptoServicePurpose.ANY);
    }

    public Blake2bDigest(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, CryptoServicePurpose cryptoServicePurpose) {
        this.purpose = cryptoServicePurpose;
        this.buffer = new byte[128];
        if (n < 1 || n > 64) {
            throw new IllegalArgumentException("Invalid digest length (required: 1 - 64)");
        }
        this.digestLength = n;
        if (byArray2 != null) {
            if (byArray2.length != 16) {
                throw new IllegalArgumentException("salt length must be exactly 16 bytes");
            }
            this.salt = new byte[16];
            System.arraycopy(byArray2, 0, this.salt, 0, byArray2.length);
        }
        if (byArray3 != null) {
            if (byArray3.length != 16) {
                throw new IllegalArgumentException("personalization length must be exactly 16 bytes");
            }
            this.personalization = new byte[16];
            System.arraycopy(byArray3, 0, this.personalization, 0, byArray3.length);
        }
        if (byArray != null) {
            this.key = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.key, 0, byArray.length);
            if (byArray.length > 64) {
                throw new IllegalArgumentException("Keys > 64 are not supported");
            }
            this.keyLength = byArray.length;
            System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
            this.bufferPos = 128;
        }
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties(this, n * 8, cryptoServicePurpose));
        this.init();
    }

    public Blake2bDigest(byte[] byArray, byte[] byArray2) {
        this.buffer = new byte[128];
        this.purpose = CryptoServicePurpose.ANY;
        this.digestLength = byArray2[0];
        this.keyLength = byArray2[1];
        this.fanout = byArray2[2];
        this.depth = byArray2[3];
        this.leafLength = Pack.littleEndianToInt(byArray2, 4);
        this.nodeOffset |= (long)Pack.littleEndianToInt(byArray2, 8);
        this.nodeDepth = byArray2[16];
        this.innerHashLength = byArray2[17];
        this.init();
    }

    private void init() {
        if (this.chainValue == null) {
            this.chainValue = new long[8];
            this.chainValue[0] = blake2b_IV[0] ^ (long)(this.digestLength | this.keyLength << 8 | (this.fanout << 16 | this.depth << 24 | this.leafLength << 32));
            this.chainValue[1] = blake2b_IV[1] ^ this.nodeOffset;
            this.chainValue[2] = blake2b_IV[2] ^ (long)(this.nodeDepth | this.innerHashLength << 8);
            this.chainValue[3] = blake2b_IV[3];
            this.chainValue[4] = blake2b_IV[4];
            this.chainValue[5] = blake2b_IV[5];
            if (this.salt != null) {
                this.chainValue[4] = this.chainValue[4] ^ Pack.littleEndianToLong(this.salt, 0);
                this.chainValue[5] = this.chainValue[5] ^ Pack.littleEndianToLong(this.salt, 8);
            }
            this.chainValue[6] = blake2b_IV[6];
            this.chainValue[7] = blake2b_IV[7];
            if (this.personalization != null) {
                this.chainValue[6] = this.chainValue[6] ^ Pack.littleEndianToLong(this.personalization, 0);
                this.chainValue[7] = this.chainValue[7] ^ Pack.littleEndianToLong(this.personalization, 8);
            }
        }
    }

    private void initializeInternalState() {
        System.arraycopy(this.chainValue, 0, this.internalState, 0, this.chainValue.length);
        System.arraycopy(blake2b_IV, 0, this.internalState, this.chainValue.length, 4);
        this.internalState[12] = this.t0 ^ blake2b_IV[4];
        this.internalState[13] = this.t1 ^ blake2b_IV[5];
        this.internalState[14] = this.f0 ^ blake2b_IV[6];
        this.internalState[15] = this.f1 ^ blake2b_IV[7];
    }

    @Override
    public void update(byte by) {
        int n = 0;
        n = 128 - this.bufferPos;
        if (n == 0) {
            this.t0 += 128L;
            if (this.t0 == 0L) {
                ++this.t1;
            }
        } else {
            this.buffer[this.bufferPos] = by;
            ++this.bufferPos;
            return;
        }
        this.compress(this.buffer, 0);
        Arrays.fill(this.buffer, (byte)0);
        this.buffer[0] = by;
        this.bufferPos = 1;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3;
        if (byArray == null || n2 == 0) {
            return;
        }
        int n4 = 0;
        if (this.bufferPos != 0) {
            n4 = 128 - this.bufferPos;
            if (n4 < n2) {
                System.arraycopy(byArray, n, this.buffer, this.bufferPos, n4);
                this.t0 += 128L;
                if (this.t0 == 0L) {
                    ++this.t1;
                }
                this.compress(this.buffer, 0);
                this.bufferPos = 0;
                Arrays.fill(this.buffer, (byte)0);
            } else {
                System.arraycopy(byArray, n, this.buffer, this.bufferPos, n2);
                this.bufferPos += n2;
                return;
            }
        }
        int n5 = n + n2 - 128;
        for (n3 = n + n4; n3 < n5; n3 += 128) {
            this.t0 += 128L;
            if (this.t0 == 0L) {
                ++this.t1;
            }
            this.compress(byArray, n3);
        }
        System.arraycopy(byArray, n3, this.buffer, 0, n + n2 - n3);
        this.bufferPos += n + n2 - n3;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        if (n > byArray.length - this.digestLength) {
            throw new OutputLengthException("output buffer too short");
        }
        this.f0 = -1L;
        if (this.isLastNode) {
            this.f1 = -1L;
        }
        this.t0 += (long)this.bufferPos;
        if (this.bufferPos > 0 && this.t0 == 0L) {
            ++this.t1;
        }
        this.compress(this.buffer, 0);
        Arrays.fill(this.buffer, (byte)0);
        Arrays.fill(this.internalState, 0L);
        int n2 = this.digestLength >>> 3;
        int n3 = this.digestLength & 7;
        Pack.longToLittleEndian(this.chainValue, 0, n2, byArray, n);
        if (n3 > 0) {
            byte[] byArray2 = new byte[8];
            Pack.longToLittleEndian(this.chainValue[n2], byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n + this.digestLength - n3, n3);
        }
        Arrays.fill(this.chainValue, 0L);
        this.reset();
        return this.digestLength;
    }

    @Override
    public void reset() {
        this.bufferPos = 0;
        this.f0 = 0L;
        this.f1 = 0L;
        this.t0 = 0L;
        this.t1 = 0L;
        this.isLastNode = false;
        this.chainValue = null;
        Arrays.fill(this.buffer, (byte)0);
        if (this.key != null) {
            System.arraycopy(this.key, 0, this.buffer, 0, this.key.length);
            this.bufferPos = 128;
        }
        this.init();
    }

    private void compress(byte[] byArray, int n) {
        int n2;
        this.initializeInternalState();
        long[] lArray = new long[16];
        Pack.littleEndianToLong(byArray, n, lArray);
        for (n2 = 0; n2 < ROUNDS; ++n2) {
            this.G(lArray[blake2b_sigma[n2][0]], lArray[blake2b_sigma[n2][1]], 0, 4, 8, 12);
            this.G(lArray[blake2b_sigma[n2][2]], lArray[blake2b_sigma[n2][3]], 1, 5, 9, 13);
            this.G(lArray[blake2b_sigma[n2][4]], lArray[blake2b_sigma[n2][5]], 2, 6, 10, 14);
            this.G(lArray[blake2b_sigma[n2][6]], lArray[blake2b_sigma[n2][7]], 3, 7, 11, 15);
            this.G(lArray[blake2b_sigma[n2][8]], lArray[blake2b_sigma[n2][9]], 0, 5, 10, 15);
            this.G(lArray[blake2b_sigma[n2][10]], lArray[blake2b_sigma[n2][11]], 1, 6, 11, 12);
            this.G(lArray[blake2b_sigma[n2][12]], lArray[blake2b_sigma[n2][13]], 2, 7, 8, 13);
            this.G(lArray[blake2b_sigma[n2][14]], lArray[blake2b_sigma[n2][15]], 3, 4, 9, 14);
        }
        for (n2 = 0; n2 < this.chainValue.length; ++n2) {
            this.chainValue[n2] = this.chainValue[n2] ^ this.internalState[n2] ^ this.internalState[n2 + 8];
        }
    }

    private void G(long l, long l2, int n, int n2, int n3, int n4) {
        this.internalState[n] = this.internalState[n] + this.internalState[n2] + l;
        this.internalState[n4] = Longs.rotateRight(this.internalState[n4] ^ this.internalState[n], 32);
        this.internalState[n3] = this.internalState[n3] + this.internalState[n4];
        this.internalState[n2] = Longs.rotateRight(this.internalState[n2] ^ this.internalState[n3], 24);
        this.internalState[n] = this.internalState[n] + this.internalState[n2] + l2;
        this.internalState[n4] = Longs.rotateRight(this.internalState[n4] ^ this.internalState[n], 16);
        this.internalState[n3] = this.internalState[n3] + this.internalState[n4];
        this.internalState[n2] = Longs.rotateRight(this.internalState[n2] ^ this.internalState[n3], 63);
    }

    protected void setAsLastNode() {
        this.isLastNode = true;
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2b";
    }

    @Override
    public int getDigestSize() {
        return this.digestLength;
    }

    @Override
    public int getByteLength() {
        return 128;
    }

    public void clearKey() {
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            Arrays.fill(this.buffer, (byte)0);
        }
    }

    public void clearSalt() {
        if (this.salt != null) {
            Arrays.fill(this.salt, (byte)0);
        }
    }
}

