/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.ClassicSort;
import com.esri.core.geometry.NumberUtils;

final class BucketSort {
    AttributeStreamOfInt32 m_buckets = new AttributeStreamOfInt32(0);
    AttributeStreamOfInt32 m_bucketed_indices = new AttributeStreamOfInt32(0);
    double m_min_value = 1.0;
    double m_max_value = -1.0;
    double m_dy = Double.NaN;
    static int MAXBUCKETS = 65536;

    public void sort(AttributeStreamOfInt32 indices, int begin, int end, ClassicSort sorter) {
        if (end - begin < 32) {
            sorter.userSort(begin, end, indices);
            return;
        }
        boolean b_fallback = true;
        try {
            double miny = NumberUtils.positiveInf();
            double maxy = NumberUtils.negativeInf();
            int i = begin;
            while (i < end) {
                double y = sorter.getValue(indices.get(i));
                if (y < miny) {
                    miny = y;
                }
                if (y > maxy) {
                    maxy = y;
                }
                ++i;
            }
            if (this.reset(end - begin, miny, maxy, end - begin)) {
                i = begin;
                while (i < end) {
                    int vertex = indices.get(i);
                    double y = sorter.getValue(vertex);
                    int bucket = this.getBucket(y);
                    this.m_buckets.set(bucket, this.m_buckets.get(bucket) + 1);
                    this.m_bucketed_indices.write(i - begin, vertex);
                    ++i;
                }
                int c = this.m_buckets.get(0);
                this.m_buckets.set(0, 0);
                int i2 = 1;
                int n = this.m_buckets.size();
                while (i2 < n) {
                    int b = this.m_buckets.get(i2);
                    this.m_buckets.set(i2, c);
                    c += b;
                    ++i2;
                }
                i2 = begin;
                while (i2 < end) {
                    int vertex = this.m_bucketed_indices.read(i2 - begin);
                    double y = sorter.getValue(vertex);
                    int bucket = this.getBucket(y);
                    int bucket_index = this.m_buckets.get(bucket);
                    indices.set(bucket_index + begin, vertex);
                    this.m_buckets.set(bucket, bucket_index + 1);
                    ++i2;
                }
                b_fallback = false;
            }
        }
        catch (Exception e) {
            this.m_buckets.resize(0);
            this.m_bucketed_indices.resize(0);
        }
        if (b_fallback) {
            sorter.userSort(begin, end, indices);
            return;
        }
        int j = 0;
        int i = 0;
        int n = this.m_buckets.size();
        while (i < n) {
            int j0 = j;
            j = this.m_buckets.get(i);
            if (j > j0) {
                sorter.userSort(begin + j0, begin + j, indices);
            }
            ++i;
        }
        assert (j == end);
        if (this.getBucketCount() > 100) {
            this.m_buckets.resize(0);
            this.m_bucketed_indices.resize(0);
        }
    }

    private boolean reset(int bucket_count, double min_value, double max_value, int capacity) {
        if (bucket_count < 2 || max_value == min_value) {
            return false;
        }
        int bc = Math.min(MAXBUCKETS, bucket_count);
        this.m_buckets.reserve(bc);
        this.m_buckets.resize(bc);
        this.m_buckets.setRange(0.0, 0, this.m_buckets.size());
        this.m_min_value = min_value;
        this.m_max_value = max_value;
        this.m_bucketed_indices.resize(capacity);
        this.m_dy = (max_value - min_value) / (double)(bc - 1);
        return true;
    }

    private int getBucket(double value) {
        assert (value >= this.m_min_value && value <= this.m_max_value);
        int bucket = (int)((value - this.m_min_value) / this.m_dy);
        return bucket;
    }

    private int getBucketCount() {
        return this.m_buckets.size();
    }
}

