/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorProximity2D;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Proximity2DResult;
import com.esri.core.geometry.Proximity2DResultComparator;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIterator;
import java.util.ArrayList;
import java.util.Collections;

class OperatorProximity2DLocal
extends OperatorProximity2D {
    OperatorProximity2DLocal() {
    }

    @Override
    public Proximity2DResult getNearestCoordinate(Geometry geom, Point inputPoint, boolean bTestPolygonInterior) {
        return this.getNearestCoordinate(geom, inputPoint, bTestPolygonInterior, false);
    }

    @Override
    public Proximity2DResult getNearestCoordinate(Geometry geom, Point inputPoint, boolean bTestPolygonInterior, boolean bCalculateLeftRightSide) {
        if (geom.isEmpty()) {
            return new Proximity2DResult();
        }
        Point2D inputPoint2D = inputPoint.getXY();
        Geometry proxmityTestGeom = geom;
        int gt = geom.getType().value();
        if (gt == 197) {
            Polygon polygon = new Polygon();
            polygon.addEnvelope((Envelope)geom, false);
            proxmityTestGeom = polygon;
            gt = 1736;
        }
        switch (gt) {
            case 33: {
                return this.pointGetNearestVertex((Point)proxmityTestGeom, inputPoint2D);
            }
            case 550: {
                return this.multiVertexGetNearestVertex((MultiVertexGeometry)proxmityTestGeom, inputPoint2D);
            }
            case 1607: 
            case 1736: {
                return this.multiPathGetNearestCoordinate((MultiPath)proxmityTestGeom, inputPoint2D, bTestPolygonInterior, bCalculateLeftRightSide);
            }
        }
        throw new GeometryException("not implemented");
    }

    @Override
    public Proximity2DResult getNearestVertex(Geometry geom, Point inputPoint) {
        if (geom.isEmpty()) {
            return new Proximity2DResult();
        }
        Point2D inputPoint2D = inputPoint.getXY();
        Geometry proxmityTestGeom = geom;
        int gt = geom.getType().value();
        if (gt == 197) {
            Polygon polygon = new Polygon();
            polygon.addEnvelope((Envelope)geom, false);
            proxmityTestGeom = polygon;
            gt = 1736;
        }
        switch (gt) {
            case 33: {
                return this.pointGetNearestVertex((Point)proxmityTestGeom, inputPoint2D);
            }
            case 550: 
            case 1607: 
            case 1736: {
                return this.multiVertexGetNearestVertex((MultiVertexGeometry)proxmityTestGeom, inputPoint2D);
            }
        }
        throw new GeometryException("not implemented");
    }

    @Override
    public Proximity2DResult[] getNearestVertices(Geometry geom, Point inputPoint, double searchRadius, int maxVertexCountToReturn) {
        if (maxVertexCountToReturn < 0) {
            throw new IllegalArgumentException();
        }
        if (geom.isEmpty()) {
            return new Proximity2DResult[0];
        }
        Point2D inputPoint2D = inputPoint.getXY();
        Geometry proxmityTestGeom = geom;
        int gt = geom.getType().value();
        if (gt == 197) {
            Polygon polygon = new Polygon();
            polygon.addEnvelope((Envelope)geom, false);
            proxmityTestGeom = polygon;
            gt = 1736;
        }
        switch (gt) {
            case 33: {
                return this.pointGetNearestVertices((Point)proxmityTestGeom, inputPoint2D, searchRadius, maxVertexCountToReturn);
            }
            case 550: 
            case 1607: 
            case 1736: {
                return this.multiVertexGetNearestVertices((MultiVertexGeometry)proxmityTestGeom, inputPoint2D, searchRadius, maxVertexCountToReturn);
            }
        }
        throw new GeometryException("not implemented");
    }

    /*
     * Exception decompiling
     */
    Proximity2DResult multiPathGetNearestCoordinate(MultiPath geom, Point2D inputPoint, boolean bTestPolygonInterior, boolean bCalculateLeftRightSide) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Proximity2DResult pointGetNearestVertex(Point geom, Point2D input_point) {
        Point2D pt = geom.getXY();
        double distance = Point2D.distance(pt, input_point);
        return new Proximity2DResult(pt, 0, distance);
    }

    Proximity2DResult multiVertexGetNearestVertex(MultiVertexGeometry geom, Point2D inputPoint) {
        MultiVertexGeometryImpl mpImpl = (MultiVertexGeometryImpl)geom._getImpl();
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(0);
        int pointCount = geom.getPointCount();
        int closestIndex = 0;
        double closestx = 0.0;
        double closesty = 0.0;
        double closestDistanceSq = NumberUtils.doubleMax();
        int i = 0;
        while (i < pointCount) {
            Point2D pt = new Point2D();
            position.read(2 * i, pt);
            double distanceSq = Point2D.sqrDistance(pt, inputPoint);
            if (distanceSq < closestDistanceSq) {
                closestx = pt.x;
                closesty = pt.y;
                closestIndex = i;
                closestDistanceSq = distanceSq;
            }
            ++i;
        }
        Proximity2DResult result = new Proximity2DResult();
        result._setParams(closestx, closesty, closestIndex, Math.sqrt(closestDistanceSq));
        return result;
    }

    Proximity2DResult[] pointGetNearestVertices(Point geom, Point2D inputPoint, double searchRadius, int maxVertexCountToReturn) {
        Proximity2DResult[] resultArray;
        if (maxVertexCountToReturn == 0) {
            Proximity2DResult[] resultArray2 = new Proximity2DResult[]{};
            return resultArray2;
        }
        double searchRadiusSq = searchRadius * searchRadius;
        Point2D pt = geom.getXY();
        double distanceSq = Point2D.sqrDistance(pt, inputPoint);
        if (distanceSq <= searchRadiusSq) {
            resultArray = new Proximity2DResult[1];
            Proximity2DResult result = new Proximity2DResult();
            result._setParams(pt.x, pt.y, 0, Math.sqrt(distanceSq));
            resultArray[0] = result;
        } else {
            resultArray = new Proximity2DResult[]{};
        }
        return resultArray;
    }

    Proximity2DResult[] multiVertexGetNearestVertices(MultiVertexGeometry geom, Point2D inputPoint, double searchRadius, int maxVertexCountToReturn) {
        if (maxVertexCountToReturn == 0) {
            Proximity2DResult[] resultArray = new Proximity2DResult[]{};
            return resultArray;
        }
        MultiVertexGeometryImpl mpImpl = (MultiVertexGeometryImpl)geom._getImpl();
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(0);
        int pointCount = geom.getPointCount();
        ArrayList<Proximity2DResult> v = new ArrayList<Proximity2DResult>(maxVertexCountToReturn);
        int count = 0;
        double searchRadiusSq = searchRadius * searchRadius;
        int i = 0;
        while (i < pointCount) {
            double y;
            double yDiff;
            double x = position.read(2 * i);
            double xDiff = inputPoint.x - x;
            double distanceSq = xDiff * xDiff + (yDiff = inputPoint.y - (y = position.read(2 * i + 1))) * yDiff;
            if (distanceSq <= searchRadiusSq) {
                Proximity2DResult result = new Proximity2DResult();
                result._setParams(x, y, i, Math.sqrt(distanceSq));
                ++count;
                v.add(result);
            }
            ++i;
        }
        int vsize = v.size();
        Collections.sort(v, new Proximity2DResultComparator());
        if (maxVertexCountToReturn >= vsize) {
            return v.toArray(new Proximity2DResult[0]);
        }
        return v.subList(0, maxVertexCountToReturn).toArray(new Proximity2DResult[0]);
    }

    class Side_helper {
        int m_i1;
        int m_i2;
        boolean m_bRight1;
        boolean m_bRight2;

        Side_helper() {
        }

        void reset() {
            this.m_i1 = -1;
            this.m_i2 = -1;
            this.m_bRight1 = false;
            this.m_bRight2 = false;
        }

        int find_non_degenerate(SegmentIterator segIter, int vertexIndex, int pathIndex) {
            double length;
            Segment segment;
            segIter.resetToVertex(vertexIndex, pathIndex);
            while (segIter.hasNextSegment()) {
                segment = segIter.nextSegment();
                length = segment.calculateLength2D();
                if (length == 0.0) continue;
                return segIter.getStartPointIndex();
            }
            segIter.resetToVertex(vertexIndex, pathIndex);
            while (segIter.hasPreviousSegment()) {
                segment = segIter.previousSegment();
                length = segment.calculateLength2D();
                if (length == 0.0) continue;
                return segIter.getStartPointIndex();
            }
            return -1;
        }

        int find_prev_non_degenerate(SegmentIterator segIter, int index) {
            segIter.resetToVertex(index, -1);
            while (segIter.hasPreviousSegment()) {
                Segment segment = segIter.previousSegment();
                double length = segment.calculateLength2D();
                if (length == 0.0) continue;
                return segIter.getStartPointIndex();
            }
            return -1;
        }

        int find_next_non_degenerate(SegmentIterator segIter, int index) {
            segIter.resetToVertex(index, -1);
            segIter.nextSegment();
            while (segIter.hasNextSegment()) {
                Segment segment = segIter.nextSegment();
                double length = segment.calculateLength2D();
                if (length == 0.0) continue;
                return segIter.getStartPointIndex();
            }
            return -1;
        }

        void find_analysis_pair_from_index(Point2D inputPoint, SegmentIterator segIter, int vertexIndex, int pathIndex) {
            this.m_i1 = this.find_non_degenerate(segIter, vertexIndex, pathIndex);
            if (this.m_i1 != -1) {
                double d2;
                Point2D p2;
                double t2;
                Segment segment2;
                segIter.resetToVertex(this.m_i1, -1);
                Segment segment1 = segIter.nextSegment();
                double t1 = segment1.getClosestCoordinate(inputPoint, false);
                Point2D p1 = segment1.getCoord2D(t1);
                double d1 = Point2D.sqrDistance(p1, inputPoint);
                Point2D pq = new Point2D();
                pq.setCoords(p1);
                pq.sub(segment1.getStartXY());
                Point2D pr = new Point2D();
                pr.setCoords(inputPoint);
                pr.sub(segment1.getStartXY());
                this.m_bRight1 = pq.crossProduct(pr) < 0.0;
                this.m_i2 = this.find_next_non_degenerate(segIter, this.m_i1);
                if (this.m_i2 != -1) {
                    segIter.resetToVertex(this.m_i2, -1);
                    segment2 = segIter.nextSegment();
                    t2 = segment2.getClosestCoordinate(inputPoint, false);
                    p2 = segment2.getCoord2D(t2);
                    d2 = Point2D.sqrDistance(p2, inputPoint);
                    if (d2 > d1) {
                        this.m_i2 = -1;
                    } else {
                        pq.setCoords(p2);
                        pq.sub(segment2.getStartXY());
                        pr.setCoords(inputPoint);
                        pr.sub(segment2.getStartXY());
                        boolean bl = this.m_bRight2 = pq.crossProduct(pr) < 0.0;
                    }
                }
                if (this.m_i2 == -1) {
                    this.m_i2 = this.find_prev_non_degenerate(segIter, this.m_i1);
                    if (this.m_i2 != -1) {
                        segIter.resetToVertex(this.m_i2, -1);
                        segment2 = segIter.nextSegment();
                        t2 = segment2.getClosestCoordinate(inputPoint, false);
                        p2 = segment2.getCoord2D(t2);
                        d2 = Point2D.sqrDistance(p2, inputPoint);
                        if (d2 > d1) {
                            this.m_i2 = -1;
                        } else {
                            pq.setCoords(p2);
                            pq.sub(segment2.getStartXY());
                            pr.setCoords(inputPoint);
                            pr.sub(segment2.getStartXY());
                            this.m_bRight2 = pq.crossProduct(pr) < 0.0;
                            int itemp = this.m_i1;
                            this.m_i1 = this.m_i2;
                            this.m_i2 = itemp;
                            boolean btemp = this.m_bRight1;
                            this.m_bRight1 = this.m_bRight2;
                            this.m_bRight2 = btemp;
                        }
                    }
                }
            }
        }

        boolean calc_side(Point2D inputPoint, boolean bRight, MultiPath multipath, int vertexIndex, int pathIndex) {
            SegmentIterator segIter = multipath.querySegmentIterator();
            this.find_analysis_pair_from_index(inputPoint, segIter, vertexIndex, pathIndex);
            if (this.m_i1 != -1 && this.m_i2 == -1) {
                return this.m_bRight1;
            }
            if (this.m_i1 != -1 && this.m_i2 != -1) {
                if (this.m_bRight1 == this.m_bRight2) {
                    return this.m_bRight1;
                }
                segIter.resetToVertex(this.m_i1, -1);
                Segment segment1 = segIter.nextSegment();
                Point2D tang1 = segment1._getTangent(1.0);
                segIter.resetToVertex(this.m_i2, -1);
                Segment segment2 = segIter.nextSegment();
                Point2D tang2 = segment2._getTangent(0.0);
                double cross = tang1.crossProduct(tang2);
                return cross >= 0.0;
            }
            assert (this.m_i1 == -1 && this.m_i2 == -1);
            return bRight;
        }
    }
}

