/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.codec;

import io.airlift.drift.transport.netty.codec.HeaderCodec;
import io.airlift.drift.transport.netty.codec.HeaderTransport;
import io.airlift.drift.transport.netty.codec.Protocol;
import io.airlift.drift.transport.netty.codec.SimpleFrameCodec;
import io.airlift.drift.transport.netty.codec.SimpleFrameInfoDecoder;
import io.airlift.drift.transport.netty.codec.ThriftFramedDecoder;
import io.airlift.drift.transport.netty.codec.ThriftUnframedDecoder;
import io.airlift.units.DataSize;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldPrepender;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Transport {
    UNFRAMED{

        @Override
        public void addFrameHandlers(ChannelPipeline pipeline, Optional<Protocol> protocol, DataSize maxFrameSize, boolean assumeClientsSupportOutOfOrderResponses) {
            Protocol protocolType = protocol.orElseThrow(() -> new IllegalArgumentException("UNFRAMED transport requires a protocol"));
            pipeline.addLast("thriftUnframedDecoder", (ChannelHandler)new ThriftUnframedDecoder(protocolType, maxFrameSize, assumeClientsSupportOutOfOrderResponses));
            pipeline.addLast(new ChannelHandler[]{new SimpleFrameCodec(this, protocolType, assumeClientsSupportOutOfOrderResponses)});
        }
    }
    ,
    FRAMED{

        @Override
        public void addFrameHandlers(ChannelPipeline pipeline, Optional<Protocol> protocol, DataSize maxFrameSize, boolean assumeClientsSupportOutOfOrderResponses) {
            Protocol protocolType = protocol.orElseThrow(() -> new IllegalArgumentException("FRAMED transport requires a protocol"));
            pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
            SimpleFrameInfoDecoder frameInfoDecoder = new SimpleFrameInfoDecoder(FRAMED, protocolType, assumeClientsSupportOutOfOrderResponses);
            pipeline.addLast("thriftFramedDecoder", (ChannelHandler)new ThriftFramedDecoder(frameInfoDecoder, Math.toIntExact(maxFrameSize.toBytes())));
            pipeline.addLast(new ChannelHandler[]{new SimpleFrameCodec(this, protocolType, assumeClientsSupportOutOfOrderResponses)});
        }
    }
    ,
    HEADER{

        @Override
        public void addFrameHandlers(ChannelPipeline pipeline, Optional<Protocol> protocol, DataSize maxFrameSize, boolean assumeClientsSupportOutOfOrderResponses) {
            pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
            pipeline.addLast("thriftFramedDecoder", (ChannelHandler)new ThriftFramedDecoder(HeaderTransport::tryDecodeFrameInfo, Math.toIntExact(maxFrameSize.toBytes())));
            pipeline.addLast(new ChannelHandler[]{new HeaderCodec()});
        }
    };


    public abstract void addFrameHandlers(ChannelPipeline var1, Optional<Protocol> var2, DataSize var3, boolean var4);
}

