/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.ssl;

import com.google.errorprone.annotations.CheckReturnValue;
import io.airlift.drift.protocol.TTransport;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCounted;

public class TChannelBufferOutputTransport
implements TTransport,
ReferenceCounted {
    private final ByteBuf buffer;

    public TChannelBufferOutputTransport(ByteBufAllocator byteBufAllocator) {
        this(byteBufAllocator.buffer(1024));
    }

    public TChannelBufferOutputTransport(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public ByteBuf getBuffer() {
        return this.buffer.retainedDuplicate();
    }

    public void write(byte[] buf, int off, int len) {
        this.buffer.writeBytes(buf, off, len);
    }

    public void read(byte[] buf, int off, int len) {
        throw new UnsupportedOperationException();
    }

    public int refCnt() {
        return this.buffer.refCnt();
    }

    public ReferenceCounted retain() {
        this.buffer.retain();
        return this;
    }

    public ReferenceCounted retain(int increment) {
        this.buffer.retain(increment);
        return this;
    }

    public ReferenceCounted touch() {
        this.buffer.touch();
        return this;
    }

    public ReferenceCounted touch(Object hint) {
        this.buffer.touch(hint);
        return this;
    }

    @CheckReturnValue
    public boolean release() {
        return this.buffer.release();
    }

    public boolean release(int decrement) {
        return this.buffer.release(decrement);
    }
}

